Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# AuthCredential class
Interface that represents the credentials returned by an [AuthProvider](./auth.authprovider.md#authprovider_interface)<!-- -->.

Implementations specify the details about each auth provider's credential requirements.

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `AuthCredential` class.

<b>Signature:</b>

```typescript
export declare class AuthCredential 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [providerId](./auth.authcredential.md#authcredentialproviderid) |  | string | The authentication provider ID for the credential. |
|  [signInMethod](./auth.authcredential.md#authcredentialsigninmethod) |  | string | The authentication sign in method for the credential. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [toJSON()](./auth.authcredential.md#authcredentialtojson) |  | Returns a JSON-serializable representation of this object. |

## AuthCredential.providerId

The authentication provider ID for the credential.

For example, 'facebook.com', or 'google.com'.

<b>Signature:</b>

```typescript
readonly providerId: string;
```

## AuthCredential.signInMethod

The authentication sign in method for the credential.

For example, [SignInMethod](./auth.md#signinmethod)<!-- -->.EMAIL\_PASSWORD, or [SignInMethod](./auth.md#signinmethod)<!-- -->.EMAIL\_LINK. This corresponds to the sign-in method identifier as returned in [fetchSignInMethodsForEmail()](./auth.md#fetchsigninmethodsforemail_efb3887)<!-- -->.

<b>Signature:</b>

```typescript
readonly signInMethod: string;
```

## AuthCredential.toJSON()

Returns a JSON-serializable representation of this object.

<b>Signature:</b>

```typescript
toJSON(): object;
```
<b>Returns:</b>

object

a JSON-serializable representation of this object.

