Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# ConfirmationResult interface
A result from a phone number sign-in, link, or reauthenticate call.

<b>Signature:</b>

```typescript
export interface ConfirmationResult 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [verificationId](./auth.confirmationresult.md#confirmationresultverificationid) | string | The phone number authentication operation's verification ID. |

## Methods

|  Method | Description |
|  --- | --- |
|  [confirm(verificationCode)](./auth.confirmationresult.md#confirmationresultconfirm) | Finishes a phone number sign-in, link, or reauthentication. |

## ConfirmationResult.verificationId

The phone number authentication operation's verification ID.

This can be used along with the verification code to initialize a [PhoneAuthCredential](./auth.phoneauthcredential.md#phoneauthcredential_class)<!-- -->.

<b>Signature:</b>

```typescript
readonly verificationId: string;
```

## ConfirmationResult.confirm()

Finishes a phone number sign-in, link, or reauthentication.

<b>Signature:</b>

```typescript
confirm(verificationCode: string): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  verificationCode | string | The code that was sent to the user's mobile device. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### Example


```javascript
const confirmationResult = await signInWithPhoneNumber(auth, phoneNumber, applicationVerifier);
// Obtain verificationCode from the user.
const userCredential = await confirmationResult.confirm(verificationCode);

```

