Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# Dependencies interface
The dependencies that can be used to initialize an [Auth](./auth.auth.md#auth_interface) instance.

The modular SDK enables tree shaking by allowing explicit declarations of dependencies. For example, a web app does not need to include code that enables Cordova redirect sign in. That functionality is therefore split into [browserPopupRedirectResolver](./auth.md#browserpopupredirectresolver) and [cordovaPopupRedirectResolver](./auth.md#cordovapopupredirectresolver)<!-- -->. The dependencies object is how Auth is configured to reduce bundle sizes.

There are two ways to initialize an [Auth](./auth.auth.md#auth_interface) instance: [getAuth()](./auth.md#getauth_cf608e1) and [initializeAuth()](./auth.md#initializeauth_ca77c9b)<!-- -->. `getAuth` initializes everything using platform-specific configurations, while `initializeAuth` takes a `Dependencies` object directly, giving you more control over what is used.

<b>Signature:</b>

```typescript
export interface Dependencies 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [errorMap](./auth.dependencies.md#dependencieserrormap) | [AuthErrorMap](./auth.autherrormap.md#autherrormap_interface) | Which [AuthErrorMap](./auth.autherrormap.md#autherrormap_interface) to use. |
|  [persistence](./auth.dependencies.md#dependenciespersistence) | [Persistence](./auth.persistence.md#persistence_interface) \| [Persistence](./auth.persistence.md#persistence_interface)<!-- -->\[\] | Which [Persistence](./auth.persistence.md#persistence_interface) to use. If this is an array, the first <code>Persistence</code> that the device supports is used. The SDK searches for an existing account in order and, if one is found in a secondary <code>Persistence</code>, the account is moved to the primary <code>Persistence</code>.<!-- -->If no persistence is provided, the SDK falls back on [inMemoryPersistence](./auth.md#inmemorypersistence)<!-- -->. |
|  [popupRedirectResolver](./auth.dependencies.md#dependenciespopupredirectresolver) | [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) | The [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) to use. This value depends on the platform. Options are [browserPopupRedirectResolver](./auth.md#browserpopupredirectresolver) and [cordovaPopupRedirectResolver](./auth.md#cordovapopupredirectresolver)<!-- -->. This field is optional if neither [signInWithPopup()](./auth.md#signinwithpopup_770f816) or [signInWithRedirect()](./auth.md#signinwithredirect_770f816) are being used. |

## Dependencies.errorMap

Which [AuthErrorMap](./auth.autherrormap.md#autherrormap_interface) to use.

<b>Signature:</b>

```typescript
errorMap?: AuthErrorMap;
```

## Dependencies.persistence

Which [Persistence](./auth.persistence.md#persistence_interface) to use. If this is an array, the first `Persistence` that the device supports is used. The SDK searches for an existing account in order and, if one is found in a secondary `Persistence`<!-- -->, the account is moved to the primary `Persistence`<!-- -->.

If no persistence is provided, the SDK falls back on [inMemoryPersistence](./auth.md#inmemorypersistence)<!-- -->.

<b>Signature:</b>

```typescript
persistence?: Persistence | Persistence[];
```

## Dependencies.popupRedirectResolver

The [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) to use. This value depends on the platform. Options are [browserPopupRedirectResolver](./auth.md#browserpopupredirectresolver) and [cordovaPopupRedirectResolver](./auth.md#cordovapopupredirectresolver)<!-- -->. This field is optional if neither [signInWithPopup()](./auth.md#signinwithpopup_770f816) or [signInWithRedirect()](./auth.md#signinwithredirect_770f816) are being used.

<b>Signature:</b>

```typescript
popupRedirectResolver?: PopupRedirectResolver;
```
