Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# EmailAuthProvider class
Provider for generating [EmailAuthCredential](./auth.emailauthcredential.md#emailauthcredential_class)<!-- -->.

<b>Signature:</b>

```typescript
export declare class EmailAuthProvider implements AuthProvider 
```
<b>Implements:</b> [AuthProvider](./auth.authprovider.md#authprovider_interface)

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [EMAIL\_LINK\_SIGN\_IN\_METHOD](./auth.emailauthprovider.md#emailauthprovideremail_link_sign_in_method) | <code>static</code> | 'emailLink' | Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.EMAIL\_LINK. |
|  [EMAIL\_PASSWORD\_SIGN\_IN\_METHOD](./auth.emailauthprovider.md#emailauthprovideremail_password_sign_in_method) | <code>static</code> | 'password' | Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.EMAIL\_PASSWORD. |
|  [PROVIDER\_ID](./auth.emailauthprovider.md#emailauthproviderprovider_id) | <code>static</code> | 'password' | Always set to [ProviderId](./auth.md#providerid)<!-- -->.PASSWORD, even for email link. |
|  [providerId](./auth.emailauthprovider.md#emailauthproviderproviderid) |  | "password" | Always set to [ProviderId](./auth.md#providerid)<!-- -->.PASSWORD, even for email link. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [credential(email, password)](./auth.emailauthprovider.md#emailauthprovidercredential) | <code>static</code> | Initialize an [AuthCredential](./auth.authcredential.md#authcredential_class) using an email and password. |
|  [credentialWithLink(email, emailLink)](./auth.emailauthprovider.md#emailauthprovidercredentialwithlink) | <code>static</code> | Initialize an [AuthCredential](./auth.authcredential.md#authcredential_class) using an email and an email link after a sign in with email link operation. |

## EmailAuthProvider.EMAIL\_LINK\_SIGN\_IN\_METHOD

Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.EMAIL\_LINK.

<b>Signature:</b>

```typescript
static readonly EMAIL_LINK_SIGN_IN_METHOD: 'emailLink';
```

## EmailAuthProvider.EMAIL\_PASSWORD\_SIGN\_IN\_METHOD

Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.EMAIL\_PASSWORD.

<b>Signature:</b>

```typescript
static readonly EMAIL_PASSWORD_SIGN_IN_METHOD: 'password';
```

## EmailAuthProvider.PROVIDER\_ID

Always set to [ProviderId](./auth.md#providerid)<!-- -->.PASSWORD, even for email link.

<b>Signature:</b>

```typescript
static readonly PROVIDER_ID: 'password';
```

## EmailAuthProvider.providerId

Always set to [ProviderId](./auth.md#providerid)<!-- -->.PASSWORD, even for email link.

<b>Signature:</b>

```typescript
readonly providerId: "password";
```

## EmailAuthProvider.credential()

Initialize an [AuthCredential](./auth.authcredential.md#authcredential_class) using an email and password.

<b>Signature:</b>

```typescript
static credential(email: string, password: string): EmailAuthCredential;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  email | string | Email address. |
|  password | string | User account password. |

<b>Returns:</b>

[EmailAuthCredential](./auth.emailauthcredential.md#emailauthcredential_class)

The auth provider credential.

### Example 1


```javascript
const authCredential = EmailAuthProvider.credential(email, password);
const userCredential = await signInWithCredential(auth, authCredential);

```

### Example 2


```javascript
const userCredential = await signInWithEmailAndPassword(auth, email, password);

```

## EmailAuthProvider.credentialWithLink()

Initialize an [AuthCredential](./auth.authcredential.md#authcredential_class) using an email and an email link after a sign in with email link operation.

<b>Signature:</b>

```typescript
static credentialWithLink(email: string, emailLink: string): EmailAuthCredential;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  email | string | Email address. |
|  emailLink | string | Sign-in email link. |

<b>Returns:</b>

[EmailAuthCredential](./auth.emailauthcredential.md#emailauthcredential_class)

- The auth provider credential.

### Example 1


```javascript
const authCredential = EmailAuthProvider.credentialWithLink(auth, email, emailLink);
const userCredential = await signInWithCredential(auth, authCredential);

```

### Example 2


```javascript
await sendSignInLinkToEmail(auth, email);
// Obtain emailLink from user.
const userCredential = await signInWithEmailLink(auth, email, emailLink);

```

