Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# FacebookAuthProvider class
Provider for generating an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) for [ProviderId](./auth.md#providerid)<!-- -->.FACEBOOK.

<b>Signature:</b>

```typescript
export declare class FacebookAuthProvider extends BaseOAuthProvider 
```
<b>Extends:</b> BaseOAuthProvider

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)()](./auth.facebookauthprovider.md#facebookauthproviderconstructor) |  | Constructs a new instance of the <code>FacebookAuthProvider</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [FACEBOOK\_SIGN\_IN\_METHOD](./auth.facebookauthprovider.md#facebookauthproviderfacebook_sign_in_method) | <code>static</code> | 'facebook.com' | Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.FACEBOOK. |
|  [PROVIDER\_ID](./auth.facebookauthprovider.md#facebookauthproviderprovider_id) | <code>static</code> | 'facebook.com' | Always set to [ProviderId](./auth.md#providerid)<!-- -->.FACEBOOK. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [credential(accessToken)](./auth.facebookauthprovider.md#facebookauthprovidercredential) | <code>static</code> | Creates a credential for Facebook. |
|  [credentialFromError(error)](./auth.facebookauthprovider.md#facebookauthprovidercredentialfromerror) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation. |
|  [credentialFromResult(userCredential)](./auth.facebookauthprovider.md#facebookauthprovidercredentialfromresult) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->. |

## FacebookAuthProvider.(constructor)

Constructs a new instance of the `FacebookAuthProvider` class

<b>Signature:</b>

```typescript
constructor();
```

## FacebookAuthProvider.FACEBOOK\_SIGN\_IN\_METHOD

Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.FACEBOOK.

<b>Signature:</b>

```typescript
static readonly FACEBOOK_SIGN_IN_METHOD: 'facebook.com';
```

## FacebookAuthProvider.PROVIDER\_ID

Always set to [ProviderId](./auth.md#providerid)<!-- -->.FACEBOOK.

<b>Signature:</b>

```typescript
static readonly PROVIDER_ID: 'facebook.com';
```

## FacebookAuthProvider.credential()

Creates a credential for Facebook.

<b>Signature:</b>

```typescript
static credential(accessToken: string): OAuthCredential;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  accessToken | string | Facebook access token. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class)

### Example


```javascript
// `event` from the Facebook auth.authResponseChange callback.
const credential = FacebookAuthProvider.credential(event.authResponse.accessToken);
const result = await signInWithCredential(credential);

```

## FacebookAuthProvider.credentialFromError()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation.

<b>Signature:</b>

```typescript
static credentialFromError(error: FirebaseError): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  error | [FirebaseError](./util.firebaseerror.md#firebaseerror_class) |  |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

## FacebookAuthProvider.credentialFromResult()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->.

<b>Signature:</b>

```typescript
static credentialFromResult(userCredential: UserCredential): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  userCredential | [UserCredential](./auth.usercredential.md#usercredential_interface) | The user credential. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

### Example 1


```javascript
// Sign in using a redirect.
const provider = new FacebookAuthProvider();
// Start a sign in process for an unauthenticated user.
provider.addScope('user_birthday');
await signInWithRedirect(auth, provider);
// This will trigger a full page redirect away from your app

// After returning from the redirect when your app initializes you can obtain the result
const result = await getRedirectResult(auth);
if (result) {
  // This is the signed-in user
  const user = result.user;
  // This gives you a Facebook Access Token.
  const credential = FacebookAuthProvider.credentialFromResult(result);
  const token = credential.accessToken;
}

```

### Example 2


```javascript
// Sign in using a popup.
const provider = new FacebookAuthProvider();
provider.addScope('user_birthday');
const result = await signInWithPopup(auth, provider);

// The signed-in user info.
const user = result.user;
// This gives you a Facebook Access Token.
const credential = FacebookAuthProvider.credentialFromResult(result);
const token = credential.accessToken;

```

