Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# GithubAuthProvider class
Provider for generating an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) for [ProviderId](./auth.md#providerid)<!-- -->.GITHUB.

GitHub requires an OAuth 2.0 redirect, so you can either handle the redirect directly, or use the [signInWithPopup()](./auth.md#signinwithpopup_770f816) handler:

<b>Signature:</b>

```typescript
export declare class GithubAuthProvider extends BaseOAuthProvider 
```
<b>Extends:</b> BaseOAuthProvider

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)()](./auth.githubauthprovider.md#githubauthproviderconstructor) |  | Constructs a new instance of the <code>GithubAuthProvider</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [GITHUB\_SIGN\_IN\_METHOD](./auth.githubauthprovider.md#githubauthprovidergithub_sign_in_method) | <code>static</code> | 'github.com' | Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.GITHUB. |
|  [PROVIDER\_ID](./auth.githubauthprovider.md#githubauthproviderprovider_id) | <code>static</code> | 'github.com' | Always set to [ProviderId](./auth.md#providerid)<!-- -->.GITHUB. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [credential(accessToken)](./auth.githubauthprovider.md#githubauthprovidercredential) | <code>static</code> | Creates a credential for GitHub. |
|  [credentialFromError(error)](./auth.githubauthprovider.md#githubauthprovidercredentialfromerror) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation. |
|  [credentialFromResult(userCredential)](./auth.githubauthprovider.md#githubauthprovidercredentialfromresult) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->. |

## GithubAuthProvider.(constructor)

Constructs a new instance of the `GithubAuthProvider` class

<b>Signature:</b>

```typescript
constructor();
```

## GithubAuthProvider.GITHUB\_SIGN\_IN\_METHOD

Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.GITHUB.

<b>Signature:</b>

```typescript
static readonly GITHUB_SIGN_IN_METHOD: 'github.com';
```

## GithubAuthProvider.PROVIDER\_ID

Always set to [ProviderId](./auth.md#providerid)<!-- -->.GITHUB.

<b>Signature:</b>

```typescript
static readonly PROVIDER_ID: 'github.com';
```

## GithubAuthProvider.credential()

Creates a credential for GitHub.

<b>Signature:</b>

```typescript
static credential(accessToken: string): OAuthCredential;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  accessToken | string | GitHub access token. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class)

## GithubAuthProvider.credentialFromError()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation.

<b>Signature:</b>

```typescript
static credentialFromError(error: FirebaseError): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  error | [FirebaseError](./util.firebaseerror.md#firebaseerror_class) |  |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

## GithubAuthProvider.credentialFromResult()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->.

<b>Signature:</b>

```typescript
static credentialFromResult(userCredential: UserCredential): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  userCredential | [UserCredential](./auth.usercredential.md#usercredential_interface) | The user credential. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

### Example 1


```javascript
// Sign in using a redirect.
const provider = new GithubAuthProvider();
// Start a sign in process for an unauthenticated user.
provider.addScope('repo');
await signInWithRedirect(auth, provider);
// This will trigger a full page redirect away from your app

// After returning from the redirect when your app initializes you can obtain the result
const result = await getRedirectResult(auth);
if (result) {
  // This is the signed-in user
  const user = result.user;
  // This gives you a GitHub Access Token.
  const credential = GithubAuthProvider.credentialFromResult(result);
  const token = credential.accessToken;
}

```

### Example 2


```javascript
// Sign in using a popup.
const provider = new GithubAuthProvider();
provider.addScope('repo');
const result = await signInWithPopup(auth, provider);

// The signed-in user info.
const user = result.user;
// This gives you a GitHub Access Token.
const credential = GithubAuthProvider.credentialFromResult(result);
const token = credential.accessToken;

```

