Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# GoogleAuthProvider class
Provider for generating an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) for [ProviderId](./auth.md#providerid)<!-- -->.GOOGLE.

<b>Signature:</b>

```typescript
export declare class GoogleAuthProvider extends BaseOAuthProvider 
```
<b>Extends:</b> BaseOAuthProvider

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)()](./auth.googleauthprovider.md#googleauthproviderconstructor) |  | Constructs a new instance of the <code>GoogleAuthProvider</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [GOOGLE\_SIGN\_IN\_METHOD](./auth.googleauthprovider.md#googleauthprovidergoogle_sign_in_method) | <code>static</code> | 'google.com' | Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.GOOGLE. |
|  [PROVIDER\_ID](./auth.googleauthprovider.md#googleauthproviderprovider_id) | <code>static</code> | 'google.com' | Always set to [ProviderId](./auth.md#providerid)<!-- -->.GOOGLE. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [credential(idToken, accessToken)](./auth.googleauthprovider.md#googleauthprovidercredential) | <code>static</code> | Creates a credential for Google. At least one of ID token and access token is required. |
|  [credentialFromError(error)](./auth.googleauthprovider.md#googleauthprovidercredentialfromerror) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation. |
|  [credentialFromResult(userCredential)](./auth.googleauthprovider.md#googleauthprovidercredentialfromresult) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->. |

## GoogleAuthProvider.(constructor)

Constructs a new instance of the `GoogleAuthProvider` class

<b>Signature:</b>

```typescript
constructor();
```

## GoogleAuthProvider.GOOGLE\_SIGN\_IN\_METHOD

Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.GOOGLE.

<b>Signature:</b>

```typescript
static readonly GOOGLE_SIGN_IN_METHOD: 'google.com';
```

## GoogleAuthProvider.PROVIDER\_ID

Always set to [ProviderId](./auth.md#providerid)<!-- -->.GOOGLE.

<b>Signature:</b>

```typescript
static readonly PROVIDER_ID: 'google.com';
```

## GoogleAuthProvider.credential()

Creates a credential for Google. At least one of ID token and access token is required.

<b>Signature:</b>

```typescript
static credential(idToken?: string | null, accessToken?: string | null): OAuthCredential;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  idToken | string \| null | Google ID token. |
|  accessToken | string \| null | Google access token. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class)

### Example


```javascript
// \`googleUser\` from the onsuccess Google Sign In callback.
const credential = GoogleAuthProvider.credential(googleUser.getAuthResponse().id_token);
const result = await signInWithCredential(credential);

```

## GoogleAuthProvider.credentialFromError()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation.

<b>Signature:</b>

```typescript
static credentialFromError(error: FirebaseError): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  error | [FirebaseError](./util.firebaseerror.md#firebaseerror_class) |  |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

## GoogleAuthProvider.credentialFromResult()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->.

<b>Signature:</b>

```typescript
static credentialFromResult(userCredential: UserCredential): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  userCredential | [UserCredential](./auth.usercredential.md#usercredential_interface) | The user credential. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

### Example 1


```javascript
// Sign in using a redirect.
const provider = new GoogleAuthProvider();
// Start a sign in process for an unauthenticated user.
provider.addScope('profile');
provider.addScope('email');
await signInWithRedirect(auth, provider);
// This will trigger a full page redirect away from your app

// After returning from the redirect when your app initializes you can obtain the result
const result = await getRedirectResult(auth);
if (result) {
  // This is the signed-in user
  const user = result.user;
  // This gives you a Google Access Token.
  const credential = GoogleAuthProvider.credentialFromResult(result);
  const token = credential.accessToken;
}

```

### Example 2


```javascript
// Sign in using a popup.
const provider = new GoogleAuthProvider();
provider.addScope('profile');
provider.addScope('email');
const result = await signInWithPopup(auth, provider);

// The signed-in user info.
const user = result.user;
// This gives you a Google Access Token.
const credential = GoogleAuthProvider.credentialFromResult(result);
const token = credential.accessToken;

```

