Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# IdTokenResult interface
Interface representing ID token result obtained from [User.getIdTokenResult()](./auth.user.md#usergetidtokenresult)<!-- -->.

`IdTokenResult` contains the ID token JWT string and other helper properties for getting different data associated with the token as well as all the decoded payload claims.

Note that these claims are not to be trusted as they are parsed client side. Only server side verification can guarantee the integrity of the token claims.

<b>Signature:</b>

```typescript
export interface IdTokenResult 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [authTime](./auth.idtokenresult.md#idtokenresultauthtime) | string | The authentication time formatted as a UTC string. |
|  [claims](./auth.idtokenresult.md#idtokenresultclaims) | [ParsedToken](./auth.parsedtoken.md#parsedtoken_interface) | The entire payload claims of the ID token including the standard reserved claims as well as the custom claims. |
|  [expirationTime](./auth.idtokenresult.md#idtokenresultexpirationtime) | string | The ID token expiration time formatted as a UTC string. |
|  [issuedAtTime](./auth.idtokenresult.md#idtokenresultissuedattime) | string | The ID token issuance time formatted as a UTC string. |
|  [signInProvider](./auth.idtokenresult.md#idtokenresultsigninprovider) | string \| null | The sign-in provider through which the ID token was obtained (anonymous, custom, phone, password, etc). |
|  [signInSecondFactor](./auth.idtokenresult.md#idtokenresultsigninsecondfactor) | string \| null | The type of second factor associated with this session, provided the user was multi-factor authenticated (eg. phone, etc). |
|  [token](./auth.idtokenresult.md#idtokenresulttoken) | string | The Firebase Auth ID token JWT string. |

## IdTokenResult.authTime

The authentication time formatted as a UTC string.

This is the time the user authenticated (signed in) and not the time the token was refreshed.

<b>Signature:</b>

```typescript
authTime: string;
```

## IdTokenResult.claims

The entire payload claims of the ID token including the standard reserved claims as well as the custom claims.

<b>Signature:</b>

```typescript
claims: ParsedToken;
```

## IdTokenResult.expirationTime

The ID token expiration time formatted as a UTC string.

<b>Signature:</b>

```typescript
expirationTime: string;
```

## IdTokenResult.issuedAtTime

The ID token issuance time formatted as a UTC string.

<b>Signature:</b>

```typescript
issuedAtTime: string;
```

## IdTokenResult.signInProvider

The sign-in provider through which the ID token was obtained (anonymous, custom, phone, password, etc).

Note, this does not map to provider IDs.

<b>Signature:</b>

```typescript
signInProvider: string | null;
```

## IdTokenResult.signInSecondFactor

The type of second factor associated with this session, provided the user was multi-factor authenticated (eg. phone, etc).

<b>Signature:</b>

```typescript
signInSecondFactor: string | null;
```

## IdTokenResult.token

The Firebase Auth ID token JWT string.

<b>Signature:</b>

```typescript
token: string;
```
