Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# auth package
Firebase Authentication

## Functions

|  Function | Description |
|  --- | --- |
|  <b>function(app, ...)</b> |
|  [getAuth(app)](./auth.md#getauth_cf608e1) | Returns the Auth instance associated with the provided [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)<!-- -->. If no instance exists, initializes an Auth instance with platform-specific default dependencies. |
|  [initializeAuth(app, deps)](./auth.md#initializeauth_ca77c9b) | Initializes an [Auth](./auth.auth.md#auth_interface) instance with fine-grained control over [Dependencies](./auth.dependencies.md#dependencies_interface)<!-- -->. |
|  <b>function(storage, ...)</b> |
|  [getReactNativePersistence(storage)](./auth.md#getreactnativepersistence_bab4ada) | Returns a persistence object that wraps <code>AsyncStorage</code> imported from <code>react-native</code> or <code>@react-native-community/async-storage</code>, and can be used in the persistence dependency field in [initializeAuth()](./auth.md#initializeauth_ca77c9b)<!-- -->. |
|  <b>function(auth, ...)</b> |
|  [applyActionCode(auth, oobCode)](./auth.md#applyactioncode_d2ae15a) | Applies a verification code sent to the user by email or other out-of-band mechanism. |
|  [beforeAuthStateChanged(auth, callback, onAbort)](./auth.md#beforeauthstatechanged_22f2ab6) | Adds a blocking callback that runs before an auth state change sets a new user. |
|  [checkActionCode(auth, oobCode)](./auth.md#checkactioncode_d2ae15a) | Checks a verification code sent to the user by email or other out-of-band mechanism. |
|  [confirmPasswordReset(auth, oobCode, newPassword)](./auth.md#confirmpasswordreset_749dad8) | Completes the password reset process, given a confirmation code and new password. |
|  [connectAuthEmulator(auth, url, options)](./auth.md#connectauthemulator_657c7e5) | Changes the [Auth](./auth.auth.md#auth_interface) instance to communicate with the Firebase Auth Emulator, instead of production Firebase Auth services. |
|  [createUserWithEmailAndPassword(auth, email, password)](./auth.md#createuserwithemailandpassword_21ad33b) | Creates a new user account associated with the specified email address and password. |
|  [fetchSignInMethodsForEmail(auth, email)](./auth.md#fetchsigninmethodsforemail_efb3887) | Gets the list of possible sign in methods for the given email address. This method returns an empty list when [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection) is enabled, irrespective of the number of authentication methods available for the given email. |
|  [getMultiFactorResolver(auth, error)](./auth.md#getmultifactorresolver_201ba61) | Provides a [MultiFactorResolver](./auth.multifactorresolver.md#multifactorresolver_interface) suitable for completion of a multi-factor flow. |
|  [getRedirectResult(auth, resolver)](./auth.md#getredirectresult_c35dc1f) | Returns a [UserCredential](./auth.usercredential.md#usercredential_interface) from the redirect-based sign-in flow. |
|  [initializeRecaptchaConfig(auth)](./auth.md#initializerecaptchaconfig_2a61ea7) | Loads the reCAPTCHA configuration into the <code>Auth</code> instance. |
|  [isSignInWithEmailLink(auth, emailLink)](./auth.md#issigninwithemaillink_db04f1d) | Checks if an incoming link is a sign-in with email link suitable for [signInWithEmailLink()](./auth.md#signinwithemaillink_ed14c53)<!-- -->. |
|  [onAuthStateChanged(auth, nextOrObserver, error, completed)](./auth.md#onauthstatechanged_b0d07ab) | Adds an observer for changes to the user's sign-in state. |
|  [onIdTokenChanged(auth, nextOrObserver, error, completed)](./auth.md#onidtokenchanged_b0d07ab) | Adds an observer for changes to the signed-in user's ID token. |
|  [revokeAccessToken(auth, token)](./auth.md#revokeaccesstoken_5556ad5) | Revokes the given access token. Currently only supports Apple OAuth access tokens. |
|  [sendPasswordResetEmail(auth, email, actionCodeSettings)](./auth.md#sendpasswordresetemail_95b079b) | Sends a password reset email to the given email address. This method does not throw an error when there's no user account with the given email address and [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection) is enabled. |
|  [sendSignInLinkToEmail(auth, email, actionCodeSettings)](./auth.md#sendsigninlinktoemail_95b079b) | Sends a sign-in email link to the user with the specified email. |
|  [setPersistence(auth, persistence)](./auth.md#setpersistence_a3592ac) | Changes the type of persistence on the [Auth](./auth.auth.md#auth_interface) instance for the currently saved <code>Auth</code> session and applies this type of persistence for future sign-in requests, including sign-in with redirect requests. |
|  [signInAnonymously(auth)](./auth.md#signinanonymously_2a61ea7) | Asynchronously signs in as an anonymous user. |
|  [signInWithCredential(auth, credential)](./auth.md#signinwithcredential_8074518) | Asynchronously signs in with the given credentials. |
|  [signInWithCustomToken(auth, customToken)](./auth.md#signinwithcustomtoken_32af683) | Asynchronously signs in using a custom token. |
|  [signInWithEmailAndPassword(auth, email, password)](./auth.md#signinwithemailandpassword_21ad33b) | Asynchronously signs in using an email and password. |
|  [signInWithEmailLink(auth, email, emailLink)](./auth.md#signinwithemaillink_ed14c53) | Asynchronously signs in using an email and sign-in email link. |
|  [signInWithPhoneNumber(auth, phoneNumber, appVerifier)](./auth.md#signinwithphonenumber_75b2560) | Asynchronously signs in using a phone number. |
|  [signInWithPopup(auth, provider, resolver)](./auth.md#signinwithpopup_770f816) | Authenticates a Firebase client using a popup-based OAuth authentication flow. |
|  [signInWithRedirect(auth, provider, resolver)](./auth.md#signinwithredirect_770f816) | Authenticates a Firebase client using a full-page redirect flow. |
|  [signOut(auth)](./auth.md#signout_2a61ea7) | Signs out the current user. |
|  [updateCurrentUser(auth, user)](./auth.md#updatecurrentuser_9d96fff) | Asynchronously sets the provided user as [Auth.currentUser](./auth.auth.md#authcurrentuser) on the [Auth](./auth.auth.md#auth_interface) instance. |
|  [useDeviceLanguage(auth)](./auth.md#usedevicelanguage_2a61ea7) | Sets the current language to the default device/browser preference. |
|  [validatePassword(auth, password)](./auth.md#validatepassword_4dc4ad2) | Validates the password against the password policy configured for the project or tenant. |
|  [verifyPasswordResetCode(auth, code)](./auth.md#verifypasswordresetcode_01e0a1a) | Checks a password reset code sent to the user by email or other out-of-band mechanism. |
|  <b>function(link, ...)</b> |
|  [parseActionCodeURL(link)](./auth.md#parseactioncodeurl_51293c3) | Parses the email action link string and returns an [ActionCodeURL](./auth.actioncodeurl.md#actioncodeurl_class) if the link is valid, otherwise returns null. |
|  <b>function(user, ...)</b> |
|  [deleteUser(user)](./auth.md#deleteuser_52b2e2e) | Deletes and signs out the user. |
|  [getIdToken(user, forceRefresh)](./auth.md#getidtoken_ce7d429) | Returns a JSON Web Token (JWT) used to identify the user to a Firebase service. |
|  [getIdTokenResult(user, forceRefresh)](./auth.md#getidtokenresult_ce7d429) | Returns a deserialized JSON Web Token (JWT) used to identify the user to a Firebase service. |
|  [linkWithCredential(user, credential)](./auth.md#linkwithcredential_60f8043) | Links the user account with the given credentials. |
|  [linkWithPhoneNumber(user, phoneNumber, appVerifier)](./auth.md#linkwithphonenumber_9ed75fe) | Links the user account with the given phone number. |
|  [linkWithPopup(user, provider, resolver)](./auth.md#linkwithpopup_41c0b31) | Links the authenticated provider to the user account using a pop-up based OAuth flow. |
|  [linkWithRedirect(user, provider, resolver)](./auth.md#linkwithredirect_41c0b31) | Links the [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class) to the user account using a full-page redirect flow. |
|  [multiFactor(user)](./auth.md#multifactor_52b2e2e) | The [MultiFactorUser](./auth.multifactoruser.md#multifactoruser_interface) corresponding to the user. |
|  [reauthenticateWithCredential(user, credential)](./auth.md#reauthenticatewithcredential_60f8043) | Re-authenticates a user using a fresh credential. |
|  [reauthenticateWithPhoneNumber(user, phoneNumber, appVerifier)](./auth.md#reauthenticatewithphonenumber_9ed75fe) | Re-authenticates a user using a fresh phone credential. |
|  [reauthenticateWithPopup(user, provider, resolver)](./auth.md#reauthenticatewithpopup_41c0b31) | Reauthenticates the current user with the specified [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class) using a pop-up based OAuth flow. |
|  [reauthenticateWithRedirect(user, provider, resolver)](./auth.md#reauthenticatewithredirect_41c0b31) | Reauthenticates the current user with the specified [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class) using a full-page redirect flow. |
|  [reload(user)](./auth.md#reload_52b2e2e) | Reloads user account data, if signed in. |
|  [sendEmailVerification(user, actionCodeSettings)](./auth.md#sendemailverification_6a885d6) | Sends a verification email to a user. |
|  [unlink(user, providerId)](./auth.md#unlink_f289a14) | Unlinks a provider from a user account. |
|  [updateEmail(user, newEmail)](./auth.md#updateemail_7737d57) | Updates the user's email address. |
|  [updatePassword(user, newPassword)](./auth.md#updatepassword_6df673e) | Updates the user's password. |
|  [updatePhoneNumber(user, credential)](./auth.md#updatephonenumber_0105c49) | Updates the user's phone number. |
|  [updateProfile(user, { displayName, photoURL: photoUrl })](./auth.md#updateprofile_017e12d) | Updates a user's profile data. |
|  [verifyBeforeUpdateEmail(user, newEmail, actionCodeSettings)](./auth.md#verifybeforeupdateemail_09d6f11) | Sends a verification email to a new email address. |
|  <b>function(userCredential, ...)</b> |
|  [getAdditionalUserInfo(userCredential)](./auth.md#getadditionaluserinfo_838a6bd) | Extracts provider specific [AdditionalUserInfo](./auth.additionaluserinfo.md#additionaluserinfo_interface) for the given credential. |

## Classes

|  Class | Description |
|  --- | --- |
|  [ActionCodeURL](./auth.actioncodeurl.md#actioncodeurl_class) | A utility class to parse email action URLs such as password reset, email verification, email link sign in, etc. |
|  [AuthCredential](./auth.authcredential.md#authcredential_class) | Interface that represents the credentials returned by an [AuthProvider](./auth.authprovider.md#authprovider_interface)<!-- -->. |
|  [EmailAuthCredential](./auth.emailauthcredential.md#emailauthcredential_class) | Interface that represents the credentials returned by [EmailAuthProvider](./auth.emailauthprovider.md#emailauthprovider_class) for [ProviderId](./auth.md#providerid)<!-- -->.PASSWORD |
|  [EmailAuthProvider](./auth.emailauthprovider.md#emailauthprovider_class) | Provider for generating [EmailAuthCredential](./auth.emailauthcredential.md#emailauthcredential_class)<!-- -->. |
|  [FacebookAuthProvider](./auth.facebookauthprovider.md#facebookauthprovider_class) | Provider for generating an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) for [ProviderId](./auth.md#providerid)<!-- -->.FACEBOOK. |
|  [GithubAuthProvider](./auth.githubauthprovider.md#githubauthprovider_class) | Provider for generating an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) for [ProviderId](./auth.md#providerid)<!-- -->.GITHUB. |
|  [GoogleAuthProvider](./auth.googleauthprovider.md#googleauthprovider_class) | Provider for generating an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) for [ProviderId](./auth.md#providerid)<!-- -->.GOOGLE. |
|  [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) | Represents the OAuth credentials returned by an [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class)<!-- -->. |
|  [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class) | Provider for generating generic [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class)<!-- -->. |
|  [PhoneAuthCredential](./auth.phoneauthcredential.md#phoneauthcredential_class) | Represents the credentials returned by [PhoneAuthProvider](./auth.phoneauthprovider.md#phoneauthprovider_class)<!-- -->. |
|  [PhoneAuthProvider](./auth.phoneauthprovider.md#phoneauthprovider_class) | Provider for generating an [PhoneAuthCredential](./auth.phoneauthcredential.md#phoneauthcredential_class)<!-- -->. |
|  [PhoneMultiFactorGenerator](./auth.phonemultifactorgenerator.md#phonemultifactorgenerator_class) | Provider for generating a [PhoneMultiFactorAssertion](./auth.phonemultifactorassertion.md#phonemultifactorassertion_interface)<!-- -->. |
|  [RecaptchaVerifier](./auth.recaptchaverifier.md#recaptchaverifier_class) | An [reCAPTCHA](https://www.google.com/recaptcha/)<!-- -->-based application verifier. |
|  [SAMLAuthProvider](./auth.samlauthprovider.md#samlauthprovider_class) | An [AuthProvider](./auth.authprovider.md#authprovider_interface) for SAML. |
|  [TotpMultiFactorGenerator](./auth.totpmultifactorgenerator.md#totpmultifactorgenerator_class) | Provider for generating a [TotpMultiFactorAssertion](./auth.totpmultifactorassertion.md#totpmultifactorassertion_interface)<!-- -->. |
|  [TotpSecret](./auth.totpsecret.md#totpsecret_class) | Provider for generating a [TotpMultiFactorAssertion](./auth.totpmultifactorassertion.md#totpmultifactorassertion_interface)<!-- -->.<!-- -->Stores the shared secret key and other parameters to generate time-based OTPs. Implements methods to retrieve the shared secret key and generate a QR code URL. |
|  [TwitterAuthProvider](./auth.twitterauthprovider.md#twitterauthprovider_class) | Provider for generating an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) for [ProviderId](./auth.md#providerid)<!-- -->.TWITTER. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [ActionCodeInfo](./auth.actioncodeinfo.md#actioncodeinfo_interface) | A response from [checkActionCode()](./auth.md#checkactioncode_d2ae15a)<!-- -->. |
|  [ActionCodeSettings](./auth.actioncodesettings.md#actioncodesettings_interface) | An interface that defines the required continue/state URL with optional Android and iOS bundle identifiers. |
|  [AdditionalUserInfo](./auth.additionaluserinfo.md#additionaluserinfo_interface) | A structure containing additional user information from a federated identity provider. |
|  [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface) | A verifier for domain verification and abuse prevention. |
|  [Auth](./auth.auth.md#auth_interface) | Interface representing Firebase Auth service. |
|  [AuthError](./auth.autherror.md#autherror_interface) | Interface for an <code>Auth</code> error. |
|  [AuthErrorMap](./auth.autherrormap.md#autherrormap_interface) | A mapping of error codes to error messages. |
|  [AuthProvider](./auth.authprovider.md#authprovider_interface) | Interface that represents an auth provider, used to facilitate creating [AuthCredential](./auth.authcredential.md#authcredential_class)<!-- -->. |
|  [AuthSettings](./auth.authsettings.md#authsettings_interface) | Interface representing an [Auth](./auth.auth.md#auth_interface) instance's settings. |
|  [Config](./auth.config.md#config_interface) | Interface representing the <code>Auth</code> config. |
|  [ConfirmationResult](./auth.confirmationresult.md#confirmationresult_interface) | A result from a phone number sign-in, link, or reauthenticate call. |
|  [Dependencies](./auth.dependencies.md#dependencies_interface) | The dependencies that can be used to initialize an [Auth](./auth.auth.md#auth_interface) instance. |
|  [EmulatorConfig](./auth.emulatorconfig.md#emulatorconfig_interface) | Configuration of Firebase Authentication Emulator. |
|  [IdTokenResult](./auth.idtokenresult.md#idtokenresult_interface) | Interface representing ID token result obtained from [User.getIdTokenResult()](./auth.user.md#usergetidtokenresult)<!-- -->. |
|  [MultiFactorAssertion](./auth.multifactorassertion.md#multifactorassertion_interface) | The base class for asserting ownership of a second factor. |
|  [MultiFactorError](./auth.multifactorerror.md#multifactorerror_interface) | The error thrown when the user needs to provide a second factor to sign in successfully. |
|  [MultiFactorInfo](./auth.multifactorinfo.md#multifactorinfo_interface) | A structure containing the information of a second factor entity. |
|  [MultiFactorResolver](./auth.multifactorresolver.md#multifactorresolver_interface) | The class used to facilitate recovery from [MultiFactorError](./auth.multifactorerror.md#multifactorerror_interface) when a user needs to provide a second factor to sign in. |
|  [MultiFactorSession](./auth.multifactorsession.md#multifactorsession_interface) | An interface defining the multi-factor session object used for enrolling a second factor on a user or helping sign in an enrolled user with a second factor. |
|  [MultiFactorUser](./auth.multifactoruser.md#multifactoruser_interface) | An interface that defines the multi-factor related properties and operations pertaining to a [User](./auth.user.md#user_interface)<!-- -->. |
|  [OAuthCredentialOptions](./auth.oauthcredentialoptions.md#oauthcredentialoptions_interface) | Defines the options for initializing an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class)<!-- -->. |
|  [ParsedToken](./auth.parsedtoken.md#parsedtoken_interface) | Interface representing a parsed ID token. |
|  [PasswordPolicy](./auth.passwordpolicy.md#passwordpolicy_interface) | A structure specifying password policy requirements. |
|  [PasswordValidationStatus](./auth.passwordvalidationstatus.md#passwordvalidationstatus_interface) | A structure indicating which password policy requirements were met or violated and what the requirements are. |
|  [Persistence](./auth.persistence.md#persistence_interface) | An interface covering the possible persistence mechanism types. |
|  [PhoneMultiFactorAssertion](./auth.phonemultifactorassertion.md#phonemultifactorassertion_interface) | The class for asserting ownership of a phone second factor. Provided by [PhoneMultiFactorGenerator.assertion()](./auth.phonemultifactorgenerator.md#phonemultifactorgeneratorassertion)<!-- -->. |
|  [PhoneMultiFactorEnrollInfoOptions](./auth.phonemultifactorenrollinfooptions.md#phonemultifactorenrollinfooptions_interface) | Options used for enrolling a second factor. |
|  [PhoneMultiFactorInfo](./auth.phonemultifactorinfo.md#phonemultifactorinfo_interface) | The subclass of the [MultiFactorInfo](./auth.multifactorinfo.md#multifactorinfo_interface) interface for phone number second factors. The <code>factorId</code> of this second factor is [FactorId](./auth.md#factorid)<!-- -->.PHONE. |
|  [PhoneMultiFactorSignInInfoOptions](./auth.phonemultifactorsignininfooptions.md#phonemultifactorsignininfooptions_interface) | Options used for signing in with a second factor. |
|  [PhoneSingleFactorInfoOptions](./auth.phonesinglefactorinfooptions.md#phonesinglefactorinfooptions_interface) | Options used for single-factor sign-in. |
|  [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) | A resolver used for handling DOM specific operations like [signInWithPopup()](./auth.md#signinwithpopup_770f816) or [signInWithRedirect()](./auth.md#signinwithredirect_770f816)<!-- -->. |
|  [ReactNativeAsyncStorage](./auth.reactnativeasyncstorage.md#reactnativeasyncstorage_interface) | Interface for a supplied <code>AsyncStorage</code>. |
|  [RecaptchaParameters](./auth.recaptchaparameters.md#recaptchaparameters_interface) | Interface representing reCAPTCHA parameters.<!-- -->See the [reCAPTCHA docs](https://developers.google.com/recaptcha/docs/display#render_param) for the list of accepted parameters. All parameters are accepted except for <code>sitekey</code>: Firebase Auth provisions a reCAPTCHA for each project and will configure the site key upon rendering.<!-- -->For an invisible reCAPTCHA, set the <code>size</code> key to <code>invisible</code>. |
|  [TotpMultiFactorAssertion](./auth.totpmultifactorassertion.md#totpmultifactorassertion_interface) | The class for asserting ownership of a TOTP second factor. Provided by [TotpMultiFactorGenerator.assertionForEnrollment()](./auth.totpmultifactorgenerator.md#totpmultifactorgeneratorassertionforenrollment) and [TotpMultiFactorGenerator.assertionForSignIn()](./auth.totpmultifactorgenerator.md#totpmultifactorgeneratorassertionforsignin)<!-- -->. |
|  [TotpMultiFactorInfo](./auth.totpmultifactorinfo.md#totpmultifactorinfo_interface) | The subclass of the [MultiFactorInfo](./auth.multifactorinfo.md#multifactorinfo_interface) interface for TOTP second factors. The <code>factorId</code> of this second factor is [FactorId](./auth.md#factorid)<!-- -->.TOTP. |
|  [User](./auth.user.md#user_interface) | A user account. |
|  [UserCredential](./auth.usercredential.md#usercredential_interface) | A structure containing a [User](./auth.user.md#user_interface)<!-- -->, the [OperationType](./auth.md#operationtype)<!-- -->, and the provider ID. |
|  [UserInfo](./auth.userinfo.md#userinfo_interface) | User profile information, visible only to the Firebase project's apps. |
|  [UserMetadata](./auth.usermetadata.md#usermetadata_interface) | Interface representing a user's metadata. |

## Variables

|  Variable | Description |
|  --- | --- |
|  [ActionCodeOperation](./auth.md#actioncodeoperation) | An enumeration of the possible email action types. |
|  [AuthErrorCodes](./auth.md#autherrorcodes) | A map of potential <code>Auth</code> error codes, for easier comparison with errors thrown by the SDK. |
|  [browserCookiePersistence](./auth.md#browsercookiepersistence) | <b><i>(Public Preview)</i></b> An implementation of [Persistence](./auth.persistence.md#persistence_interface) of type <code>COOKIE</code>, for use on the client side in applications leveraging hybrid rendering and middleware. |
|  [browserLocalPersistence](./auth.md#browserlocalpersistence) | An implementation of [Persistence](./auth.persistence.md#persistence_interface) of type <code>LOCAL</code> using <code>localStorage</code> for the underlying storage. |
|  [browserPopupRedirectResolver](./auth.md#browserpopupredirectresolver) | An implementation of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) suitable for browser based applications. |
|  [browserSessionPersistence](./auth.md#browsersessionpersistence) | An implementation of [Persistence](./auth.persistence.md#persistence_interface) of <code>SESSION</code> using <code>sessionStorage</code> for the underlying storage. |
|  [cordovaPopupRedirectResolver](./auth.md#cordovapopupredirectresolver) | An implementation of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) suitable for Cordova based applications. |
|  [debugErrorMap](./auth.md#debugerrormap) | A verbose error map with detailed descriptions for most error codes.<!-- -->See discussion at [AuthErrorMap](./auth.autherrormap.md#autherrormap_interface) |
|  [FactorId](./auth.md#factorid) | An enum of factors that may be used for multifactor authentication. |
|  [indexedDBLocalPersistence](./auth.md#indexeddblocalpersistence) | An implementation of [Persistence](./auth.persistence.md#persistence_interface) of type <code>LOCAL</code> using <code>indexedDB</code> for the underlying storage. |
|  [inMemoryPersistence](./auth.md#inmemorypersistence) | An implementation of [Persistence](./auth.persistence.md#persistence_interface) of type 'NONE'. |
|  [OperationType](./auth.md#operationtype) | Enumeration of supported operation types. |
|  [prodErrorMap](./auth.md#proderrormap) | A minimal error map with all verbose error messages stripped.<!-- -->See discussion at [AuthErrorMap](./auth.autherrormap.md#autherrormap_interface) |
|  [ProviderId](./auth.md#providerid) | Enumeration of supported providers. |
|  [SignInMethod](./auth.md#signinmethod) | Enumeration of supported sign-in methods. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [CustomParameters](./auth.md#customparameters) | Map of OAuth Custom Parameters. |
|  [NextOrObserver](./auth.md#nextorobserver) | Type definition for an event callback. |
|  [PhoneInfoOptions](./auth.md#phoneinfooptions) | The information required to verify the ownership of a phone number. |
|  [UserProfile](./auth.md#userprofile) | User profile used in [AdditionalUserInfo](./auth.additionaluserinfo.md#additionaluserinfo_interface)<!-- -->. |

## function(app, ...)

### getAuth(app) {:#getauth_cf608e1}

Returns the Auth instance associated with the provided [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)<!-- -->. If no instance exists, initializes an Auth instance with platform-specific default dependencies.

<b>Signature:</b>

```typescript
export declare function getAuth(app?: FirebaseApp): Auth;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | The Firebase App. |

<b>Returns:</b>

[Auth](./auth.auth.md#auth_interface)

### initializeAuth(app, deps) {:#initializeauth_ca77c9b}

Initializes an [Auth](./auth.auth.md#auth_interface) instance with fine-grained control over [Dependencies](./auth.dependencies.md#dependencies_interface)<!-- -->.

This function allows more control over the [Auth](./auth.auth.md#auth_interface) instance than [getAuth()](./auth.md#getauth_cf608e1)<!-- -->. `getAuth` uses platform-specific defaults to supply the [Dependencies](./auth.dependencies.md#dependencies_interface)<!-- -->. In general, `getAuth` is the easiest way to initialize Auth and works for most use cases. Use `initializeAuth` if you need control over which persistence layer is used, or to minimize bundle size if you're not using either `signInWithPopup` or `signInWithRedirect`<!-- -->.

For example, if your app only uses anonymous accounts and you only want accounts saved for the current session, initialize `Auth` with:

```js
const auth = initializeAuth(app, {
  persistence: browserSessionPersistence,
  popupRedirectResolver: undefined,
});

```

<b>Signature:</b>

```typescript
export declare function initializeAuth(app: FirebaseApp, deps?: Dependencies): Auth;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) |  |
|  deps | [Dependencies](./auth.dependencies.md#dependencies_interface) |  |

<b>Returns:</b>

[Auth](./auth.auth.md#auth_interface)

## function(storage, ...)

### getReactNativePersistence(storage) {:#getreactnativepersistence_bab4ada}

Returns a persistence object that wraps `AsyncStorage` imported from `react-native` or `@react-native-community/async-storage`<!-- -->, and can be used in the persistence dependency field in [initializeAuth()](./auth.md#initializeauth_ca77c9b)<!-- -->.

<b>Signature:</b>

```typescript
export declare function getReactNativePersistence(storage: ReactNativeAsyncStorage): Persistence;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  storage | [ReactNativeAsyncStorage](./auth.reactnativeasyncstorage.md#reactnativeasyncstorage_interface) |  |

<b>Returns:</b>

[Persistence](./auth.persistence.md#persistence_interface)

## function(auth, ...)

### applyActionCode(auth, oobCode) {:#applyactioncode_d2ae15a}

Applies a verification code sent to the user by email or other out-of-band mechanism.

<b>Signature:</b>

```typescript
export declare function applyActionCode(auth: Auth, oobCode: string): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  oobCode | string | A verification code sent to the user. |

<b>Returns:</b>

Promise&lt;void&gt;

### beforeAuthStateChanged(auth, callback, onAbort) {:#beforeauthstatechanged_22f2ab6}

Adds a blocking callback that runs before an auth state change sets a new user.

<b>Signature:</b>

```typescript
export declare function beforeAuthStateChanged(auth: Auth, callback: (user: User | null) => void | Promise<void>, onAbort?: () => void): Unsubscribe;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  callback | (user: [User](./auth.user.md#user_interface) \| null) =&gt; void \| Promise&lt;void&gt; | callback triggered before new user value is set. If this throws, it blocks the user from being set. |
|  onAbort | () =&gt; void | callback triggered if a later <code>beforeAuthStateChanged()</code> callback throws, allowing you to undo any side effects. |

<b>Returns:</b>

[Unsubscribe](./util.md#unsubscribe)

### checkActionCode(auth, oobCode) {:#checkactioncode_d2ae15a}

Checks a verification code sent to the user by email or other out-of-band mechanism.

<b>Signature:</b>

```typescript
export declare function checkActionCode(auth: Auth, oobCode: string): Promise<ActionCodeInfo>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  oobCode | string | A verification code sent to the user. |

<b>Returns:</b>

Promise&lt;[ActionCodeInfo](./auth.actioncodeinfo.md#actioncodeinfo_interface)<!-- -->&gt;

metadata about the code.

### confirmPasswordReset(auth, oobCode, newPassword) {:#confirmpasswordreset_749dad8}

Completes the password reset process, given a confirmation code and new password.

<b>Signature:</b>

```typescript
export declare function confirmPasswordReset(auth: Auth, oobCode: string, newPassword: string): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  oobCode | string | A confirmation code sent to the user. |
|  newPassword | string | The new password. |

<b>Returns:</b>

Promise&lt;void&gt;

### connectAuthEmulator(auth, url, options) {:#connectauthemulator_657c7e5}

Changes the [Auth](./auth.auth.md#auth_interface) instance to communicate with the Firebase Auth Emulator, instead of production Firebase Auth services.

This must be called synchronously immediately following the first call to [initializeAuth()](./auth.md#initializeauth_ca77c9b)<!-- -->. Do not use with production credentials as emulator traffic is not encrypted.

<b>Signature:</b>

```typescript
export declare function connectAuthEmulator(auth: Auth, url: string, options?: {
    disableWarnings: boolean;
}): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  url | string | The URL at which the emulator is running (eg, 'http://localhost:9099'). |
|  options | { disableWarnings: boolean; } | Optional. <code>options.disableWarnings</code> defaults to <code>false</code>. Set it to <code>true</code> to disable the warning banner attached to the DOM. |

<b>Returns:</b>

void

### Example


```javascript
connectAuthEmulator(auth, 'http://127.0.0.1:9099', { disableWarnings: true });

```

### createUserWithEmailAndPassword(auth, email, password) {:#createuserwithemailandpassword_21ad33b}

Creates a new user account associated with the specified email address and password.

On successful creation of the user account, this user will also be signed in to your application.

User account creation can fail if the account already exists or the password is invalid.

This method is not supported on [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

Note: The email address acts as a unique identifier for the user and enables an email-based password reset. This function will create a new user account and set the initial user password.

<b>Signature:</b>

```typescript
export declare function createUserWithEmailAndPassword(auth: Auth, email: string, password: string): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  email | string | The user's email address. |
|  password | string | The user's chosen password. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### fetchSignInMethodsForEmail(auth, email) {:#fetchsigninmethodsforemail_efb3887}

Gets the list of possible sign in methods for the given email address. This method returns an empty list when [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection) is enabled, irrespective of the number of authentication methods available for the given email.

This is useful to differentiate methods of sign-in for the same provider, eg. [EmailAuthProvider](./auth.emailauthprovider.md#emailauthprovider_class) which has 2 methods of sign-in, [SignInMethod](./auth.md#signinmethod)<!-- -->.EMAIL\_PASSWORD and [SignInMethod](./auth.md#signinmethod)<!-- -->.EMAIL\_LINK.

<b>Signature:</b>

```typescript
export declare function fetchSignInMethodsForEmail(auth: Auth, email: string): Promise<string[]>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  email | string | The user's email address.<!-- -->Deprecated. Migrating off of this method is recommended as a security best-practice. Learn more in the Identity Platform documentation for [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection)<!-- -->. |

<b>Returns:</b>

Promise&lt;string\[\]&gt;

### getMultiFactorResolver(auth, error) {:#getmultifactorresolver_201ba61}

Provides a [MultiFactorResolver](./auth.multifactorresolver.md#multifactorresolver_interface) suitable for completion of a multi-factor flow.

<b>Signature:</b>

```typescript
export declare function getMultiFactorResolver(auth: Auth, error: MultiFactorError): MultiFactorResolver;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  error | [MultiFactorError](./auth.multifactorerror.md#multifactorerror_interface) | The [MultiFactorError](./auth.multifactorerror.md#multifactorerror_interface) raised during a sign-in, or reauthentication operation. |

<b>Returns:</b>

[MultiFactorResolver](./auth.multifactorresolver.md#multifactorresolver_interface)

### getRedirectResult(auth, resolver) {:#getredirectresult_c35dc1f}

Returns a [UserCredential](./auth.usercredential.md#usercredential_interface) from the redirect-based sign-in flow.

If sign-in succeeded, returns the signed in user. If sign-in was unsuccessful, fails with an error. If no redirect operation was called, returns `null`<!-- -->.

This method does not work in a Node.js environment or with [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function getRedirectResult(auth: Auth, resolver?: PopupRedirectResolver): Promise<UserCredential | null>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  resolver | [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) | An instance of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface)<!-- -->, optional if already supplied to [initializeAuth()](./auth.md#initializeauth_ca77c9b) or provided by [getAuth()](./auth.md#getauth_cf608e1)<!-- -->. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface) \| null&gt;

### Example


```javascript
// Sign in using a redirect.
const provider = new FacebookAuthProvider();
// You can add additional scopes to the provider:
provider.addScope('user_birthday');
// Start a sign in process for an unauthenticated user.
await signInWithRedirect(auth, provider);
// This will trigger a full page redirect away from your app

// After returning from the redirect when your app initializes you can obtain the result
const result = await getRedirectResult(auth);
if (result) {
  // This is the signed-in user
  const user = result.user;
  // This gives you a Facebook Access Token.
  const credential = provider.credentialFromResult(auth, result);
  const token = credential.accessToken;
}
// As this API can be used for sign-in, linking and reauthentication,
// check the operationType to determine what triggered this redirect
// operation.
const operationType = result.operationType;

```

### initializeRecaptchaConfig(auth) {:#initializerecaptchaconfig_2a61ea7}

Loads the reCAPTCHA configuration into the `Auth` instance.

This will load the reCAPTCHA config, which indicates whether the reCAPTCHA verification flow should be triggered for each auth provider, into the current Auth session.

If initializeRecaptchaConfig() is not invoked, the auth flow will always start without reCAPTCHA verification. If the provider is configured to require reCAPTCHA verification, the SDK will transparently load the reCAPTCHA config and restart the auth flows.

Thus, by calling this optional method, you will reduce the latency of future auth flows. Loading the reCAPTCHA config early will also enhance the signal collected by reCAPTCHA.

This method does not work in a Node.js environment.

<b>Signature:</b>

```typescript
export declare function initializeRecaptchaConfig(auth: Auth): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |

<b>Returns:</b>

Promise&lt;void&gt;

### Example


```javascript
initializeRecaptchaConfig(auth);

```

### isSignInWithEmailLink(auth, emailLink) {:#issigninwithemaillink_db04f1d}

Checks if an incoming link is a sign-in with email link suitable for [signInWithEmailLink()](./auth.md#signinwithemaillink_ed14c53)<!-- -->.

<b>Signature:</b>

```typescript
export declare function isSignInWithEmailLink(auth: Auth, emailLink: string): boolean;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  emailLink | string | The link sent to the user's email address. |

<b>Returns:</b>

boolean

### onAuthStateChanged(auth, nextOrObserver, error, completed) {:#onauthstatechanged_b0d07ab}

Adds an observer for changes to the user's sign-in state.

To keep the old behavior, see [onIdTokenChanged()](./auth.md#onidtokenchanged_b0d07ab)<!-- -->.

<b>Signature:</b>

```typescript
export declare function onAuthStateChanged(auth: Auth, nextOrObserver: NextOrObserver<User>, error?: ErrorFn, completed?: CompleteFn): Unsubscribe;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  nextOrObserver | [NextOrObserver](./auth.md#nextorobserver)<!-- -->&lt;[User](./auth.user.md#user_interface)<!-- -->&gt; | callback triggered on change. |
|  error | [ErrorFn](./util.md#errorfn) | Deprecated. This callback is never triggered. Errors on signing in/out can be caught in promises returned from sign-in/sign-out functions. |
|  completed | [CompleteFn](./util.md#completefn) | Deprecated. This callback is never triggered. |

<b>Returns:</b>

[Unsubscribe](./util.md#unsubscribe)

### onIdTokenChanged(auth, nextOrObserver, error, completed) {:#onidtokenchanged_b0d07ab}

Adds an observer for changes to the signed-in user's ID token.

This includes sign-in, sign-out, and token refresh events. This will not be triggered automatically upon ID token expiration. Use [User.getIdToken()](./auth.user.md#usergetidtoken) to refresh the ID token.

<b>Signature:</b>

```typescript
export declare function onIdTokenChanged(auth: Auth, nextOrObserver: NextOrObserver<User>, error?: ErrorFn, completed?: CompleteFn): Unsubscribe;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  nextOrObserver | [NextOrObserver](./auth.md#nextorobserver)<!-- -->&lt;[User](./auth.user.md#user_interface)<!-- -->&gt; | callback triggered on change. |
|  error | [ErrorFn](./util.md#errorfn) | Deprecated. This callback is never triggered. Errors on signing in/out can be caught in promises returned from sign-in/sign-out functions. |
|  completed | [CompleteFn](./util.md#completefn) | Deprecated. This callback is never triggered. |

<b>Returns:</b>

[Unsubscribe](./util.md#unsubscribe)

### revokeAccessToken(auth, token) {:#revokeaccesstoken_5556ad5}

Revokes the given access token. Currently only supports Apple OAuth access tokens.

<b>Signature:</b>

```typescript
export declare function revokeAccessToken(auth: Auth, token: string): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  token | string | The Apple OAuth access token. |

<b>Returns:</b>

Promise&lt;void&gt;

### sendPasswordResetEmail(auth, email, actionCodeSettings) {:#sendpasswordresetemail_95b079b}

Sends a password reset email to the given email address. This method does not throw an error when there's no user account with the given email address and [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection) is enabled.

To complete the password reset, call [confirmPasswordReset()](./auth.md#confirmpasswordreset_749dad8) with the code supplied in the email sent to the user, along with the new password specified by the user.

<b>Signature:</b>

```typescript
export declare function sendPasswordResetEmail(auth: Auth, email: string, actionCodeSettings?: ActionCodeSettings): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  email | string | The user's email address. |
|  actionCodeSettings | [ActionCodeSettings](./auth.actioncodesettings.md#actioncodesettings_interface) | The [ActionCodeSettings](./auth.actioncodesettings.md#actioncodesettings_interface)<!-- -->. |

<b>Returns:</b>

Promise&lt;void&gt;

### Example


```javascript
const actionCodeSettings = {
  url: 'https://www.example.com/?email=user@example.com',
  iOS: {
     bundleId: 'com.example.ios'
  },
  android: {
    packageName: 'com.example.android',
    installApp: true,
    minimumVersion: '12'
  },
  handleCodeInApp: true
};
await sendPasswordResetEmail(auth, 'user@example.com', actionCodeSettings);
// Obtain code from user.
await confirmPasswordReset('user@example.com', code);

```

### sendSignInLinkToEmail(auth, email, actionCodeSettings) {:#sendsigninlinktoemail_95b079b}

Sends a sign-in email link to the user with the specified email.

The sign-in operation has to always be completed in the app unlike other out of band email actions (password reset and email verifications). This is because, at the end of the flow, the user is expected to be signed in and their Auth state persisted within the app.

To complete sign in with the email link, call [signInWithEmailLink()](./auth.md#signinwithemaillink_ed14c53) with the email address and the email link supplied in the email sent to the user.

<b>Signature:</b>

```typescript
export declare function sendSignInLinkToEmail(auth: Auth, email: string, actionCodeSettings: ActionCodeSettings): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) |  |
|  email | string | The user's email address. |
|  actionCodeSettings | [ActionCodeSettings](./auth.actioncodesettings.md#actioncodesettings_interface) | The [ActionCodeSettings](./auth.actioncodesettings.md#actioncodesettings_interface)<!-- -->. |

<b>Returns:</b>

Promise&lt;void&gt;

### Example


```javascript
const actionCodeSettings = {
  url: 'https://www.example.com/?email=user@example.com',
  iOS: {
     bundleId: 'com.example.ios'
  },
  android: {
    packageName: 'com.example.android',
    installApp: true,
    minimumVersion: '12'
  },
  handleCodeInApp: true
};
await sendSignInLinkToEmail(auth, 'user@example.com', actionCodeSettings);
// Obtain emailLink from the user.
if(isSignInWithEmailLink(auth, emailLink)) {
  await signInWithEmailLink(auth, 'user@example.com', emailLink);
}

```

### setPersistence(auth, persistence) {:#setpersistence_a3592ac}

Changes the type of persistence on the [Auth](./auth.auth.md#auth_interface) instance for the currently saved `Auth` session and applies this type of persistence for future sign-in requests, including sign-in with redirect requests.

This makes it easy for a user signing in to specify whether their session should be remembered or not. It also makes it easier to never persist the `Auth` state for applications that are shared by other users or have sensitive data.

This method does not work in a Node.js environment or with [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function setPersistence(auth: Auth, persistence: Persistence): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  persistence | [Persistence](./auth.persistence.md#persistence_interface) | The [Persistence](./auth.persistence.md#persistence_interface) to use. |

<b>Returns:</b>

Promise&lt;void&gt;

A `Promise` that resolves once the persistence change has completed

### Example


```javascript
setPersistence(auth, browserSessionPersistence);

```

### signInAnonymously(auth) {:#signinanonymously_2a61ea7}

Asynchronously signs in as an anonymous user.

If there is already an anonymous user signed in, that user will be returned; otherwise, a new anonymous user identity will be created and returned.

This method is not supported by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function signInAnonymously(auth: Auth): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### signInWithCredential(auth, credential) {:#signinwithcredential_8074518}

Asynchronously signs in with the given credentials.

An [AuthProvider](./auth.authprovider.md#authprovider_interface) can be used to generate the credential.

This method is not supported by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function signInWithCredential(auth: Auth, credential: AuthCredential): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  credential | [AuthCredential](./auth.authcredential.md#authcredential_class) | The auth credential. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### signInWithCustomToken(auth, customToken) {:#signinwithcustomtoken_32af683}

Asynchronously signs in using a custom token.

Custom tokens are used to integrate Firebase Auth with existing auth systems, and must be generated by an auth backend using the [createCustomToken](https://firebase.google.com/docs/reference/admin/node/admin.auth.Auth#createcustomtoken) method in the [Admin SDK](https://firebase.google.com/docs/auth/admin) .

Fails with an error if the token is invalid, expired, or not accepted by the Firebase Auth service.

This method is not supported by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function signInWithCustomToken(auth: Auth, customToken: string): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  customToken | string | The custom token to sign in with. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### signInWithEmailAndPassword(auth, email, password) {:#signinwithemailandpassword_21ad33b}

Asynchronously signs in using an email and password.

Fails with an error if the email address and password do not match. When [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection) is enabled, this method fails with "auth/invalid-credential" in case of an invalid email/password.

This method is not supported on [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

Note: The user's password is NOT the password used to access the user's email account. The email address serves as a unique identifier for the user, and the password is used to access the user's account in your Firebase project. See also: [createUserWithEmailAndPassword()](./auth.md#createuserwithemailandpassword_21ad33b)<!-- -->.

<b>Signature:</b>

```typescript
export declare function signInWithEmailAndPassword(auth: Auth, email: string, password: string): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  email | string | The users email address. |
|  password | string | The users password. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### signInWithEmailLink(auth, email, emailLink) {:#signinwithemaillink_ed14c53}

Asynchronously signs in using an email and sign-in email link.

If no link is passed, the link is inferred from the current URL.

Fails with an error if the email address is invalid or OTP in email link expires.

This method is not supported by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

Note: Confirm the link is a sign-in email link before calling this method firebase.auth.Auth.isSignInWithEmailLink.

<b>Signature:</b>

```typescript
export declare function signInWithEmailLink(auth: Auth, email: string, emailLink?: string): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  email | string | The user's email address. |
|  emailLink | string | The link sent to the user's email address. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### Example


```javascript
const actionCodeSettings = {
  url: 'https://www.example.com/?email=user@example.com',
  iOS: {
     bundleId: 'com.example.ios'
  },
  android: {
    packageName: 'com.example.android',
    installApp: true,
    minimumVersion: '12'
  },
  handleCodeInApp: true
};
await sendSignInLinkToEmail(auth, 'user@example.com', actionCodeSettings);
// Obtain emailLink from the user.
if(isSignInWithEmailLink(auth, emailLink)) {
  await signInWithEmailLink(auth, 'user@example.com', emailLink);
}

```

### signInWithPhoneNumber(auth, phoneNumber, appVerifier) {:#signinwithphonenumber_75b2560}

Asynchronously signs in using a phone number.

This method sends a code via SMS to the given phone number, and returns a [ConfirmationResult](./auth.confirmationresult.md#confirmationresult_interface)<!-- -->. After the user provides the code sent to their phone, call [ConfirmationResult.confirm()](./auth.confirmationresult.md#confirmationresultconfirm) with the code to sign the user in.

For abuse prevention, this method requires a [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface)<!-- -->. This SDK includes an implementation based on reCAPTCHA v2, [RecaptchaVerifier](./auth.recaptchaverifier.md#recaptchaverifier_class)<!-- -->. This function can work on other platforms that do not support the [RecaptchaVerifier](./auth.recaptchaverifier.md#recaptchaverifier_class) (like React Native), but you need to use a third-party [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface) implementation.

If you've enabled project-level reCAPTCHA Enterprise bot protection in Enforce mode, you can omit the [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface)<!-- -->.

This method does not work in a Node.js environment or with [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function signInWithPhoneNumber(auth: Auth, phoneNumber: string, appVerifier?: ApplicationVerifier): Promise<ConfirmationResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  phoneNumber | string | The user's phone number in E.164 format (e.g. +16505550101). |
|  appVerifier | [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface) | The [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface)<!-- -->. |

<b>Returns:</b>

Promise&lt;[ConfirmationResult](./auth.confirmationresult.md#confirmationresult_interface)<!-- -->&gt;

### Example


```javascript
// 'recaptcha-container' is the ID of an element in the DOM.
const applicationVerifier = new firebase.auth.RecaptchaVerifier('recaptcha-container');
const confirmationResult = await signInWithPhoneNumber(auth, phoneNumber, applicationVerifier);
// Obtain a verificationCode from the user.
const credential = await confirmationResult.confirm(verificationCode);

```

### signInWithPopup(auth, provider, resolver) {:#signinwithpopup_770f816}

Authenticates a Firebase client using a popup-based OAuth authentication flow.

If succeeds, returns the signed in user along with the provider's credential. If sign in was unsuccessful, returns an error object containing additional information about the error.

This method does not work in a Node.js environment or with [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function signInWithPopup(auth: Auth, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  provider | [AuthProvider](./auth.authprovider.md#authprovider_interface) | The provider to authenticate. The provider has to be an [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class)<!-- -->. Non-OAuth providers like [EmailAuthProvider](./auth.emailauthprovider.md#emailauthprovider_class) will throw an error. |
|  resolver | [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) | An instance of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface)<!-- -->, optional if already supplied to [initializeAuth()](./auth.md#initializeauth_ca77c9b) or provided by [getAuth()](./auth.md#getauth_cf608e1)<!-- -->. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### Example


```javascript
// Sign in using a popup.
const provider = new FacebookAuthProvider();
const result = await signInWithPopup(auth, provider);

// The signed-in user info.
const user = result.user;
// This gives you a Facebook Access Token.
const credential = provider.credentialFromResult(auth, result);
const token = credential.accessToken;

```

### signInWithRedirect(auth, provider, resolver) {:#signinwithredirect_770f816}

Authenticates a Firebase client using a full-page redirect flow.

To handle the results and errors for this operation, refer to [getRedirectResult()](./auth.md#getredirectresult_c35dc1f)<!-- -->. Follow the [best practices](https://firebase.google.com/docs/auth/web/redirect-best-practices) when using [signInWithRedirect()](./auth.md#signinwithredirect_770f816)<!-- -->.

This method does not work in a Node.js environment or with [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function signInWithRedirect(auth: Auth, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<never>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  provider | [AuthProvider](./auth.authprovider.md#authprovider_interface) | The provider to authenticate. The provider has to be an [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class)<!-- -->. Non-OAuth providers like [EmailAuthProvider](./auth.emailauthprovider.md#emailauthprovider_class) will throw an error. |
|  resolver | [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) | An instance of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface)<!-- -->, optional if already supplied to [initializeAuth()](./auth.md#initializeauth_ca77c9b) or provided by [getAuth()](./auth.md#getauth_cf608e1)<!-- -->. |

<b>Returns:</b>

Promise&lt;never&gt;

### Example


```javascript
// Sign in using a redirect.
const provider = new FacebookAuthProvider();
// You can add additional scopes to the provider:
provider.addScope('user_birthday');
// Start a sign in process for an unauthenticated user.
await signInWithRedirect(auth, provider);
// This will trigger a full page redirect away from your app

// After returning from the redirect when your app initializes you can obtain the result
const result = await getRedirectResult(auth);
if (result) {
  // This is the signed-in user
  const user = result.user;
  // This gives you a Facebook Access Token.
  const credential = provider.credentialFromResult(auth, result);
  const token = credential.accessToken;
}
// As this API can be used for sign-in, linking and reauthentication,
// check the operationType to determine what triggered this redirect
// operation.
const operationType = result.operationType;

```

### signOut(auth) {:#signout_2a61ea7}

Signs out the current user.

This method is not supported by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function signOut(auth: Auth): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |

<b>Returns:</b>

Promise&lt;void&gt;

### updateCurrentUser(auth, user) {:#updatecurrentuser_9d96fff}

Asynchronously sets the provided user as [Auth.currentUser](./auth.auth.md#authcurrentuser) on the [Auth](./auth.auth.md#auth_interface) instance.

A new instance copy of the user provided will be made and set as currentUser.

This will trigger [onAuthStateChanged()](./auth.md#onauthstatechanged_b0d07ab) and [onIdTokenChanged()](./auth.md#onidtokenchanged_b0d07ab) listeners like other sign in methods.

The operation fails with an error if the user to be updated belongs to a different Firebase project.

This method is not supported by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function updateCurrentUser(auth: Auth, user: User | null): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  user | [User](./auth.user.md#user_interface) \| null | The new [User](./auth.user.md#user_interface)<!-- -->. |

<b>Returns:</b>

Promise&lt;void&gt;

### useDeviceLanguage(auth) {:#usedevicelanguage_2a61ea7}

Sets the current language to the default device/browser preference.

<b>Signature:</b>

```typescript
export declare function useDeviceLanguage(auth: Auth): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |

<b>Returns:</b>

void

### validatePassword(auth, password) {:#validatepassword_4dc4ad2}

Validates the password against the password policy configured for the project or tenant.

If no tenant ID is set on the `Auth` instance, then this method will use the password policy configured for the project. Otherwise, this method will use the policy configured for the tenant. If a password policy has not been configured, then the default policy configured for all projects will be used.

If an auth flow fails because a submitted password does not meet the password policy requirements and this method has previously been called, then this method will use the most recent policy available when called again.

<b>Signature:</b>

```typescript
export declare function validatePassword(auth: Auth, password: string): Promise<PasswordValidationStatus>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  password | string | The password to validate. |

<b>Returns:</b>

Promise&lt;[PasswordValidationStatus](./auth.passwordvalidationstatus.md#passwordvalidationstatus_interface)<!-- -->&gt;

### Example


```javascript
validatePassword(auth, 'some-password');

```

### verifyPasswordResetCode(auth, code) {:#verifypasswordresetcode_01e0a1a}

Checks a password reset code sent to the user by email or other out-of-band mechanism.

<b>Signature:</b>

```typescript
export declare function verifyPasswordResetCode(auth: Auth, code: string): Promise<string>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The [Auth](./auth.auth.md#auth_interface) instance. |
|  code | string | A verification code sent to the user. |

<b>Returns:</b>

Promise&lt;string&gt;

the user's email address if valid.

## function(link, ...)

### parseActionCodeURL(link) {:#parseactioncodeurl_51293c3}

Parses the email action link string and returns an [ActionCodeURL](./auth.actioncodeurl.md#actioncodeurl_class) if the link is valid, otherwise returns null.

<b>Signature:</b>

```typescript
export declare function parseActionCodeURL(link: string): ActionCodeURL | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  link | string |  |

<b>Returns:</b>

[ActionCodeURL](./auth.actioncodeurl.md#actioncodeurl_class) \| null

## function(user, ...)

### deleteUser(user) {:#deleteuser_52b2e2e}

Deletes and signs out the user.

Important: this is a security-sensitive operation that requires the user to have recently signed in. If this requirement isn't met, ask the user to authenticate again and then call [reauthenticateWithCredential()](./auth.md#reauthenticatewithcredential_60f8043)<!-- -->.

<b>Signature:</b>

```typescript
export declare function deleteUser(user: User): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |

<b>Returns:</b>

Promise&lt;void&gt;

### getIdToken(user, forceRefresh) {:#getidtoken_ce7d429}

Returns a JSON Web Token (JWT) used to identify the user to a Firebase service.

Returns the current token if it has not expired or if it will not expire in the next five minutes. Otherwise, this will refresh the token and return a new one.

<b>Signature:</b>

```typescript
export declare function getIdToken(user: User, forceRefresh?: boolean): Promise<string>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  forceRefresh | boolean | Force refresh regardless of token expiration. |

<b>Returns:</b>

Promise&lt;string&gt;

### getIdTokenResult(user, forceRefresh) {:#getidtokenresult_ce7d429}

Returns a deserialized JSON Web Token (JWT) used to identify the user to a Firebase service.

Returns the current token if it has not expired or if it will not expire in the next five minutes. Otherwise, this will refresh the token and return a new one.

<b>Signature:</b>

```typescript
export declare function getIdTokenResult(user: User, forceRefresh?: boolean): Promise<IdTokenResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  forceRefresh | boolean | Force refresh regardless of token expiration. |

<b>Returns:</b>

Promise&lt;[IdTokenResult](./auth.idtokenresult.md#idtokenresult_interface)<!-- -->&gt;

### linkWithCredential(user, credential) {:#linkwithcredential_60f8043}

Links the user account with the given credentials.

An [AuthProvider](./auth.authprovider.md#authprovider_interface) can be used to generate the credential.

<b>Signature:</b>

```typescript
export declare function linkWithCredential(user: User, credential: AuthCredential): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  credential | [AuthCredential](./auth.authcredential.md#authcredential_class) | The auth credential. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### linkWithPhoneNumber(user, phoneNumber, appVerifier) {:#linkwithphonenumber_9ed75fe}

Links the user account with the given phone number.

This method does not work in a Node.js environment.

<b>Signature:</b>

```typescript
export declare function linkWithPhoneNumber(user: User, phoneNumber: string, appVerifier?: ApplicationVerifier): Promise<ConfirmationResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  phoneNumber | string | The user's phone number in E.164 format (e.g. +16505550101). |
|  appVerifier | [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface) | The [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface)<!-- -->. |

<b>Returns:</b>

Promise&lt;[ConfirmationResult](./auth.confirmationresult.md#confirmationresult_interface)<!-- -->&gt;

### linkWithPopup(user, provider, resolver) {:#linkwithpopup_41c0b31}

Links the authenticated provider to the user account using a pop-up based OAuth flow.

If the linking is successful, the returned result will contain the user and the provider's credential.

This method does not work in a Node.js environment.

<b>Signature:</b>

```typescript
export declare function linkWithPopup(user: User, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  provider | [AuthProvider](./auth.authprovider.md#authprovider_interface) | The provider to authenticate. The provider has to be an [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class)<!-- -->. Non-OAuth providers like [EmailAuthProvider](./auth.emailauthprovider.md#emailauthprovider_class) will throw an error. |
|  resolver | [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) | An instance of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface)<!-- -->, optional if already supplied to [initializeAuth()](./auth.md#initializeauth_ca77c9b) or provided by [getAuth()](./auth.md#getauth_cf608e1)<!-- -->. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### Example


```javascript
// Sign in using some other provider.
const result = await signInWithEmailAndPassword(auth, email, password);
// Link using a popup.
const provider = new FacebookAuthProvider();
await linkWithPopup(result.user, provider);

```

### linkWithRedirect(user, provider, resolver) {:#linkwithredirect_41c0b31}

Links the [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class) to the user account using a full-page redirect flow.

To handle the results and errors for this operation, refer to [getRedirectResult()](./auth.md#getredirectresult_c35dc1f)<!-- -->. Follow the [best practices](https://firebase.google.com/docs/auth/web/redirect-best-practices) when using [linkWithRedirect()](./auth.md#linkwithredirect_41c0b31)<!-- -->.

This method does not work in a Node.js environment or with [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function linkWithRedirect(user: User, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<never>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  provider | [AuthProvider](./auth.authprovider.md#authprovider_interface) | The provider to authenticate. The provider has to be an [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class)<!-- -->. Non-OAuth providers like [EmailAuthProvider](./auth.emailauthprovider.md#emailauthprovider_class) will throw an error. |
|  resolver | [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) | An instance of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface)<!-- -->, optional if already supplied to [initializeAuth()](./auth.md#initializeauth_ca77c9b) or provided by [getAuth()](./auth.md#getauth_cf608e1)<!-- -->. |

<b>Returns:</b>

Promise&lt;never&gt;

### Example


```javascript
// Sign in using some other provider.
const result = await signInWithEmailAndPassword(auth, email, password);
// Link using a redirect.
const provider = new FacebookAuthProvider();
await linkWithRedirect(result.user, provider);
// This will trigger a full page redirect away from your app

// After returning from the redirect when your app initializes you can obtain the result
const result = await getRedirectResult(auth);

```

### multiFactor(user) {:#multifactor_52b2e2e}

The [MultiFactorUser](./auth.multifactoruser.md#multifactoruser_interface) corresponding to the user.

This is used to access all multi-factor properties and operations related to the user.

<b>Signature:</b>

```typescript
export declare function multiFactor(user: User): MultiFactorUser;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |

<b>Returns:</b>

[MultiFactorUser](./auth.multifactoruser.md#multifactoruser_interface)

### reauthenticateWithCredential(user, credential) {:#reauthenticatewithcredential_60f8043}

Re-authenticates a user using a fresh credential.

Use before operations such as [updatePassword()](./auth.md#updatepassword_6df673e) that require tokens from recent sign-in attempts. This method can be used to recover from a `CREDENTIAL_TOO_OLD_LOGIN_AGAIN` error or a `TOKEN_EXPIRED` error.

This method is not supported on any [User](./auth.user.md#user_interface) signed in by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function reauthenticateWithCredential(user: User, credential: AuthCredential): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  credential | [AuthCredential](./auth.authcredential.md#authcredential_class) | The auth credential. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### reauthenticateWithPhoneNumber(user, phoneNumber, appVerifier) {:#reauthenticatewithphonenumber_9ed75fe}

Re-authenticates a user using a fresh phone credential.

Use before operations such as [updatePassword()](./auth.md#updatepassword_6df673e) that require tokens from recent sign-in attempts.

This method does not work in a Node.js environment or on any [User](./auth.user.md#user_interface) signed in by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function reauthenticateWithPhoneNumber(user: User, phoneNumber: string, appVerifier?: ApplicationVerifier): Promise<ConfirmationResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  phoneNumber | string | The user's phone number in E.164 format (e.g. +16505550101). |
|  appVerifier | [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface) | The [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface)<!-- -->. |

<b>Returns:</b>

Promise&lt;[ConfirmationResult](./auth.confirmationresult.md#confirmationresult_interface)<!-- -->&gt;

### reauthenticateWithPopup(user, provider, resolver) {:#reauthenticatewithpopup_41c0b31}

Reauthenticates the current user with the specified [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class) using a pop-up based OAuth flow.

If the reauthentication is successful, the returned result will contain the user and the provider's credential.

This method does not work in a Node.js environment or on any [User](./auth.user.md#user_interface) signed in by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function reauthenticateWithPopup(user: User, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<UserCredential>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  provider | [AuthProvider](./auth.authprovider.md#authprovider_interface) | The provider to authenticate. The provider has to be an [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class)<!-- -->. Non-OAuth providers like [EmailAuthProvider](./auth.emailauthprovider.md#emailauthprovider_class) will throw an error. |
|  resolver | [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) | An instance of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface)<!-- -->, optional if already supplied to [initializeAuth()](./auth.md#initializeauth_ca77c9b) or provided by [getAuth()](./auth.md#getauth_cf608e1)<!-- -->. |

<b>Returns:</b>

Promise&lt;[UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->&gt;

### Example


```javascript
// Sign in using a popup.
const provider = new FacebookAuthProvider();
const result = await signInWithPopup(auth, provider);
// Reauthenticate using a popup.
await reauthenticateWithPopup(result.user, provider);

```

### reauthenticateWithRedirect(user, provider, resolver) {:#reauthenticatewithredirect_41c0b31}

Reauthenticates the current user with the specified [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class) using a full-page redirect flow.

To handle the results and errors for this operation, refer to [getRedirectResult()](./auth.md#getredirectresult_c35dc1f)<!-- -->. Follow the [best practices](https://firebase.google.com/docs/auth/web/redirect-best-practices) when using [reauthenticateWithRedirect()](./auth.md#reauthenticatewithredirect_41c0b31)<!-- -->.

This method does not work in a Node.js environment or with [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function reauthenticateWithRedirect(user: User, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<never>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  provider | [AuthProvider](./auth.authprovider.md#authprovider_interface) | The provider to authenticate. The provider has to be an [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class)<!-- -->. Non-OAuth providers like [EmailAuthProvider](./auth.emailauthprovider.md#emailauthprovider_class) will throw an error. |
|  resolver | [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) | An instance of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface)<!-- -->, optional if already supplied to [initializeAuth()](./auth.md#initializeauth_ca77c9b) or provided by [getAuth()](./auth.md#getauth_cf608e1)<!-- -->. |

<b>Returns:</b>

Promise&lt;never&gt;

### Example


```javascript
// Sign in using a redirect.
const provider = new FacebookAuthProvider();
const result = await signInWithRedirect(auth, provider);
// This will trigger a full page redirect away from your app

// After returning from the redirect when your app initializes you can obtain the result
const result = await getRedirectResult(auth);
// Reauthenticate using a redirect.
await reauthenticateWithRedirect(result.user, provider);
// This will again trigger a full page redirect away from your app

// After returning from the redirect when your app initializes you can obtain the result
const result = await getRedirectResult(auth);

```

### reload(user) {:#reload_52b2e2e}

Reloads user account data, if signed in.

<b>Signature:</b>

```typescript
export declare function reload(user: User): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |

<b>Returns:</b>

Promise&lt;void&gt;

### sendEmailVerification(user, actionCodeSettings) {:#sendemailverification_6a885d6}

Sends a verification email to a user.

The verification process is completed by calling [applyActionCode()](./auth.md#applyactioncode_d2ae15a)<!-- -->.

<b>Signature:</b>

```typescript
export declare function sendEmailVerification(user: User, actionCodeSettings?: ActionCodeSettings | null): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  actionCodeSettings | [ActionCodeSettings](./auth.actioncodesettings.md#actioncodesettings_interface) \| null | The [ActionCodeSettings](./auth.actioncodesettings.md#actioncodesettings_interface)<!-- -->. |

<b>Returns:</b>

Promise&lt;void&gt;

### Example


```javascript
const actionCodeSettings = {
  url: 'https://www.example.com/?email=user@example.com',
  iOS: {
     bundleId: 'com.example.ios'
  },
  android: {
    packageName: 'com.example.android',
    installApp: true,
    minimumVersion: '12'
  },
  handleCodeInApp: true
};
await sendEmailVerification(user, actionCodeSettings);
// Obtain code from the user.
await applyActionCode(auth, code);

```

### unlink(user, providerId) {:#unlink_f289a14}

Unlinks a provider from a user account.

<b>Signature:</b>

```typescript
export declare function unlink(user: User, providerId: string): Promise<User>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  providerId | string | The provider to unlink. |

<b>Returns:</b>

Promise&lt;[User](./auth.user.md#user_interface)<!-- -->&gt;

### updateEmail(user, newEmail) {:#updateemail_7737d57}

Updates the user's email address.

An email will be sent to the original email address (if it was set) that allows to revoke the email address change, in order to protect them from account hijacking.

This method is not supported on any [User](./auth.user.md#user_interface) signed in by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

Important: this is a security sensitive operation that requires the user to have recently signed in. If this requirement isn't met, ask the user to authenticate again and then call [reauthenticateWithCredential()](./auth.md#reauthenticatewithcredential_60f8043)<!-- -->.

<b>Signature:</b>

```typescript
export declare function updateEmail(user: User, newEmail: string): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  newEmail | string | The new email address.<!-- -->Throws "auth/operation-not-allowed" error when [Email Enumeration Protection](https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection) is enabled. Deprecated - Use [verifyBeforeUpdateEmail()](./auth.md#verifybeforeupdateemail_09d6f11) instead. |

<b>Returns:</b>

Promise&lt;void&gt;

### updatePassword(user, newPassword) {:#updatepassword_6df673e}

Updates the user's password.

Important: this is a security sensitive operation that requires the user to have recently signed in. If this requirement isn't met, ask the user to authenticate again and then call [reauthenticateWithCredential()](./auth.md#reauthenticatewithcredential_60f8043)<!-- -->.

<b>Signature:</b>

```typescript
export declare function updatePassword(user: User, newPassword: string): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  newPassword | string | The new password. |

<b>Returns:</b>

Promise&lt;void&gt;

### updatePhoneNumber(user, credential) {:#updatephonenumber_0105c49}

Updates the user's phone number.

This method does not work in a Node.js environment or on any [User](./auth.user.md#user_interface) signed in by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function updatePhoneNumber(user: User, credential: PhoneAuthCredential): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  credential | [PhoneAuthCredential](./auth.phoneauthcredential.md#phoneauthcredential_class) | A credential authenticating the new phone number. |

<b>Returns:</b>

Promise&lt;void&gt;

### Example


```
// 'recaptcha-container' is the ID of an element in the DOM.
const applicationVerifier = new RecaptchaVerifier('recaptcha-container');
const provider = new PhoneAuthProvider(auth);
const verificationId = await provider.verifyPhoneNumber('+16505550101', applicationVerifier);
// Obtain the verificationCode from the user.
const phoneCredential = PhoneAuthProvider.credential(verificationId, verificationCode);
await updatePhoneNumber(user, phoneCredential);

```

### updateProfile(user, { displayName, photoURL: photoUrl }) {:#updateprofile_017e12d}

Updates a user's profile data.

<b>Signature:</b>

```typescript
export declare function updateProfile(user: User, { displayName, photoURL: photoUrl }: {
    displayName?: string | null;
    photoURL?: string | null;
}): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  { displayName, photoURL: photoUrl } | { displayName?: string \| null; photoURL?: string \| null; } |  |

<b>Returns:</b>

Promise&lt;void&gt;

### verifyBeforeUpdateEmail(user, newEmail, actionCodeSettings) {:#verifybeforeupdateemail_09d6f11}

Sends a verification email to a new email address.

The user's email will be updated to the new one after being verified.

If you have a custom email action handler, you can complete the verification process by calling [applyActionCode()](./auth.md#applyactioncode_d2ae15a)<!-- -->.

<b>Signature:</b>

```typescript
export declare function verifyBeforeUpdateEmail(user: User, newEmail: string, actionCodeSettings?: ActionCodeSettings | null): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) | The user. |
|  newEmail | string | The new email address to be verified before update. |
|  actionCodeSettings | [ActionCodeSettings](./auth.actioncodesettings.md#actioncodesettings_interface) \| null | The [ActionCodeSettings](./auth.actioncodesettings.md#actioncodesettings_interface)<!-- -->. |

<b>Returns:</b>

Promise&lt;void&gt;

### Example


```javascript
const actionCodeSettings = {
  url: 'https://www.example.com/?email=user@example.com',
  iOS: {
     bundleId: 'com.example.ios'
  },
  android: {
    packageName: 'com.example.android',
    installApp: true,
    minimumVersion: '12'
  },
  handleCodeInApp: true
};
await verifyBeforeUpdateEmail(user, 'newemail@example.com', actionCodeSettings);
// Obtain code from the user.
await applyActionCode(auth, code);

```

## function(userCredential, ...)

### getAdditionalUserInfo(userCredential) {:#getadditionaluserinfo_838a6bd}

Extracts provider specific [AdditionalUserInfo](./auth.additionaluserinfo.md#additionaluserinfo_interface) for the given credential.

<b>Signature:</b>

```typescript
export declare function getAdditionalUserInfo(userCredential: UserCredential): AdditionalUserInfo | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  userCredential | [UserCredential](./auth.usercredential.md#usercredential_interface) | The user credential. |

<b>Returns:</b>

[AdditionalUserInfo](./auth.additionaluserinfo.md#additionaluserinfo_interface) \| null

## ActionCodeOperation

An enumeration of the possible email action types.

<b>Signature:</b>

```typescript
ActionCodeOperation: {
    readonly EMAIL_SIGNIN: "EMAIL_SIGNIN";
    readonly PASSWORD_RESET: "PASSWORD_RESET";
    readonly RECOVER_EMAIL: "RECOVER_EMAIL";
    readonly REVERT_SECOND_FACTOR_ADDITION: "REVERT_SECOND_FACTOR_ADDITION";
    readonly VERIFY_AND_CHANGE_EMAIL: "VERIFY_AND_CHANGE_EMAIL";
    readonly VERIFY_EMAIL: "VERIFY_EMAIL";
}
```

## AuthErrorCodes

A map of potential `Auth` error codes, for easier comparison with errors thrown by the SDK.

Note that you can't tree-shake individual keys in the map, so by using the map you might substantially increase your bundle size.

<b>Signature:</b>

```typescript
AUTH_ERROR_CODES_MAP_DO_NOT_USE_INTERNALLY: {
    readonly ADMIN_ONLY_OPERATION: "auth/admin-restricted-operation";
    readonly ARGUMENT_ERROR: "auth/argument-error";
    readonly APP_NOT_AUTHORIZED: "auth/app-not-authorized";
    readonly APP_NOT_INSTALLED: "auth/app-not-installed";
    readonly CAPTCHA_CHECK_FAILED: "auth/captcha-check-failed";
    readonly CODE_EXPIRED: "auth/code-expired";
    readonly CORDOVA_NOT_READY: "auth/cordova-not-ready";
    readonly CORS_UNSUPPORTED: "auth/cors-unsupported";
    readonly CREDENTIAL_ALREADY_IN_USE: "auth/credential-already-in-use";
    readonly CREDENTIAL_MISMATCH: "auth/custom-token-mismatch";
    readonly CREDENTIAL_TOO_OLD_LOGIN_AGAIN: "auth/requires-recent-login";
    readonly DEPENDENT_SDK_INIT_BEFORE_AUTH: "auth/dependent-sdk-initialized-before-auth";
    readonly DYNAMIC_LINK_NOT_ACTIVATED: "auth/dynamic-link-not-activated";
    readonly EMAIL_CHANGE_NEEDS_VERIFICATION: "auth/email-change-needs-verification";
    readonly EMAIL_EXISTS: "auth/email-already-in-use";
    readonly EMULATOR_CONFIG_FAILED: "auth/emulator-config-failed";
    readonly EXPIRED_OOB_CODE: "auth/expired-action-code";
    readonly EXPIRED_POPUP_REQUEST: "auth/cancelled-popup-request";
    readonly INTERNAL_ERROR: "auth/internal-error";
    readonly INVALID_API_KEY: "auth/invalid-api-key";
    readonly INVALID_APP_CREDENTIAL: "auth/invalid-app-credential";
    readonly INVALID_APP_ID: "auth/invalid-app-id";
    readonly INVALID_AUTH: "auth/invalid-user-token";
    readonly INVALID_AUTH_EVENT: "auth/invalid-auth-event";
    readonly INVALID_CERT_HASH: "auth/invalid-cert-hash";
    readonly INVALID_CODE: "auth/invalid-verification-code";
    readonly INVALID_CONTINUE_URI: "auth/invalid-continue-uri";
    readonly INVALID_CORDOVA_CONFIGURATION: "auth/invalid-cordova-configuration";
    readonly INVALID_CUSTOM_TOKEN: "auth/invalid-custom-token";
    readonly INVALID_DYNAMIC_LINK_DOMAIN: "auth/invalid-dynamic-link-domain";
    readonly INVALID_EMAIL: "auth/invalid-email";
    readonly INVALID_EMULATOR_SCHEME: "auth/invalid-emulator-scheme";
    readonly INVALID_IDP_RESPONSE: "auth/invalid-credential";
    readonly INVALID_LOGIN_CREDENTIALS: "auth/invalid-credential";
    readonly INVALID_MESSAGE_PAYLOAD: "auth/invalid-message-payload";
    readonly INVALID_MFA_SESSION: "auth/invalid-multi-factor-session";
    readonly INVALID_OAUTH_CLIENT_ID: "auth/invalid-oauth-client-id";
    readonly INVALID_OAUTH_PROVIDER: "auth/invalid-oauth-provider";
    readonly INVALID_OOB_CODE: "auth/invalid-action-code";
    readonly INVALID_ORIGIN: "auth/unauthorized-domain";
    readonly INVALID_PASSWORD: "auth/wrong-password";
    readonly INVALID_PERSISTENCE: "auth/invalid-persistence-type";
    readonly INVALID_PHONE_NUMBER: "auth/invalid-phone-number";
    readonly INVALID_PROVIDER_ID: "auth/invalid-provider-id";
    readonly INVALID_RECIPIENT_EMAIL: "auth/invalid-recipient-email";
    readonly INVALID_SENDER: "auth/invalid-sender";
    readonly INVALID_SESSION_INFO: "auth/invalid-verification-id";
    readonly INVALID_TENANT_ID: "auth/invalid-tenant-id";
    readonly MFA_INFO_NOT_FOUND: "auth/multi-factor-info-not-found";
    readonly MFA_REQUIRED: "auth/multi-factor-auth-required";
    readonly MISSING_ANDROID_PACKAGE_NAME: "auth/missing-android-pkg-name";
    readonly MISSING_APP_CREDENTIAL: "auth/missing-app-credential";
    readonly MISSING_AUTH_DOMAIN: "auth/auth-domain-config-required";
    readonly MISSING_CODE: "auth/missing-verification-code";
    readonly MISSING_CONTINUE_URI: "auth/missing-continue-uri";
    readonly MISSING_IFRAME_START: "auth/missing-iframe-start";
    readonly MISSING_IOS_BUNDLE_ID: "auth/missing-ios-bundle-id";
    readonly MISSING_OR_INVALID_NONCE: "auth/missing-or-invalid-nonce";
    readonly MISSING_MFA_INFO: "auth/missing-multi-factor-info";
    readonly MISSING_MFA_SESSION: "auth/missing-multi-factor-session";
    readonly MISSING_PHONE_NUMBER: "auth/missing-phone-number";
    readonly MISSING_PASSWORD: "auth/missing-password";
    readonly MISSING_SESSION_INFO: "auth/missing-verification-id";
    readonly MODULE_DESTROYED: "auth/app-deleted";
    readonly NEED_CONFIRMATION: "auth/account-exists-with-different-credential";
    readonly NETWORK_REQUEST_FAILED: "auth/network-request-failed";
    readonly NULL_USER: "auth/null-user";
    readonly NO_AUTH_EVENT: "auth/no-auth-event";
    readonly NO_SUCH_PROVIDER: "auth/no-such-provider";
    readonly OPERATION_NOT_ALLOWED: "auth/operation-not-allowed";
    readonly OPERATION_NOT_SUPPORTED: "auth/operation-not-supported-in-this-environment";
    readonly POPUP_BLOCKED: "auth/popup-blocked";
    readonly POPUP_CLOSED_BY_USER: "auth/popup-closed-by-user";
    readonly PROVIDER_ALREADY_LINKED: "auth/provider-already-linked";
    readonly QUOTA_EXCEEDED: "auth/quota-exceeded";
    readonly REDIRECT_CANCELLED_BY_USER: "auth/redirect-cancelled-by-user";
    readonly REDIRECT_OPERATION_PENDING: "auth/redirect-operation-pending";
    readonly REJECTED_CREDENTIAL: "auth/rejected-credential";
    readonly SECOND_FACTOR_ALREADY_ENROLLED: "auth/second-factor-already-in-use";
    readonly SECOND_FACTOR_LIMIT_EXCEEDED: "auth/maximum-second-factor-count-exceeded";
    readonly TENANT_ID_MISMATCH: "auth/tenant-id-mismatch";
    readonly TIMEOUT: "auth/timeout";
    readonly TOKEN_EXPIRED: "auth/user-token-expired";
    readonly TOO_MANY_ATTEMPTS_TRY_LATER: "auth/too-many-requests";
    readonly UNAUTHORIZED_DOMAIN: "auth/unauthorized-continue-uri";
    readonly UNSUPPORTED_FIRST_FACTOR: "auth/unsupported-first-factor";
    readonly UNSUPPORTED_PERSISTENCE: "auth/unsupported-persistence-type";
    readonly UNSUPPORTED_TENANT_OPERATION: "auth/unsupported-tenant-operation";
    readonly UNVERIFIED_EMAIL: "auth/unverified-email";
    readonly USER_CANCELLED: "auth/user-cancelled";
    readonly USER_DELETED: "auth/user-not-found";
    readonly USER_DISABLED: "auth/user-disabled";
    readonly USER_MISMATCH: "auth/user-mismatch";
    readonly USER_SIGNED_OUT: "auth/user-signed-out";
    readonly WEAK_PASSWORD: "auth/weak-password";
    readonly WEB_STORAGE_UNSUPPORTED: "auth/web-storage-unsupported";
    readonly ALREADY_INITIALIZED: "auth/already-initialized";
    readonly RECAPTCHA_NOT_ENABLED: "auth/recaptcha-not-enabled";
    readonly MISSING_RECAPTCHA_TOKEN: "auth/missing-recaptcha-token";
    readonly INVALID_RECAPTCHA_TOKEN: "auth/invalid-recaptcha-token";
    readonly INVALID_RECAPTCHA_ACTION: "auth/invalid-recaptcha-action";
    readonly MISSING_CLIENT_TYPE: "auth/missing-client-type";
    readonly MISSING_RECAPTCHA_VERSION: "auth/missing-recaptcha-version";
    readonly INVALID_RECAPTCHA_VERSION: "auth/invalid-recaptcha-version";
    readonly INVALID_REQ_TYPE: "auth/invalid-req-type";
    readonly INVALID_HOSTING_LINK_DOMAIN: "auth/invalid-hosting-link-domain";
}
```

## browserCookiePersistence

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

An implementation of [Persistence](./auth.persistence.md#persistence_interface) of type `COOKIE`<!-- -->, for use on the client side in applications leveraging hybrid rendering and middleware.

This persistence method requires companion middleware to function, such as that provided by [ReactFire](https://firebaseopensource.com/projects/firebaseextended/reactfire/) for NextJS.

<b>Signature:</b>

```typescript
browserCookiePersistence: Persistence
```

## browserLocalPersistence

An implementation of [Persistence](./auth.persistence.md#persistence_interface) of type `LOCAL` using `localStorage` for the underlying storage.

<b>Signature:</b>

```typescript
browserLocalPersistence: Persistence
```

## browserPopupRedirectResolver

An implementation of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) suitable for browser based applications.

This method does not work in a Node.js environment.

<b>Signature:</b>

```typescript
browserPopupRedirectResolver: PopupRedirectResolver
```

## browserSessionPersistence

An implementation of [Persistence](./auth.persistence.md#persistence_interface) of `SESSION` using `sessionStorage` for the underlying storage.

<b>Signature:</b>

```typescript
browserSessionPersistence: Persistence
```

## cordovaPopupRedirectResolver

An implementation of [PopupRedirectResolver](./auth.popupredirectresolver.md#popupredirectresolver_interface) suitable for Cordova based applications.

<b>Signature:</b>

```typescript
cordovaPopupRedirectResolver: PopupRedirectResolver
```

## debugErrorMap

A verbose error map with detailed descriptions for most error codes.

See discussion at [AuthErrorMap](./auth.autherrormap.md#autherrormap_interface)

<b>Signature:</b>

```typescript
debugErrorMap: AuthErrorMap
```

## FactorId

An enum of factors that may be used for multifactor authentication.

<b>Signature:</b>

```typescript
FactorId: {
    readonly PHONE: "phone";
    readonly TOTP: "totp";
}
```

## indexedDBLocalPersistence

An implementation of [Persistence](./auth.persistence.md#persistence_interface) of type `LOCAL` using `indexedDB` for the underlying storage.

<b>Signature:</b>

```typescript
indexedDBLocalPersistence: Persistence
```

## inMemoryPersistence

An implementation of [Persistence](./auth.persistence.md#persistence_interface) of type 'NONE'.

<b>Signature:</b>

```typescript
inMemoryPersistence: Persistence
```

## OperationType

Enumeration of supported operation types.

<b>Signature:</b>

```typescript
OperationType: {
    readonly LINK: "link";
    readonly REAUTHENTICATE: "reauthenticate";
    readonly SIGN_IN: "signIn";
}
```

## prodErrorMap

A minimal error map with all verbose error messages stripped.

See discussion at [AuthErrorMap](./auth.autherrormap.md#autherrormap_interface)

<b>Signature:</b>

```typescript
prodErrorMap: AuthErrorMap
```

## ProviderId

Enumeration of supported providers.

<b>Signature:</b>

```typescript
ProviderId: {
    readonly FACEBOOK: "facebook.com";
    readonly GITHUB: "github.com";
    readonly GOOGLE: "google.com";
    readonly PASSWORD: "password";
    readonly PHONE: "phone";
    readonly TWITTER: "twitter.com";
}
```

## SignInMethod

Enumeration of supported sign-in methods.

<b>Signature:</b>

```typescript
SignInMethod: {
    readonly EMAIL_LINK: "emailLink";
    readonly EMAIL_PASSWORD: "password";
    readonly FACEBOOK: "facebook.com";
    readonly GITHUB: "github.com";
    readonly GOOGLE: "google.com";
    readonly PHONE: "phone";
    readonly TWITTER: "twitter.com";
}
```

## CustomParameters

Map of OAuth Custom Parameters.

<b>Signature:</b>

```typescript
export type CustomParameters = Record<string, string>;
```

## NextOrObserver

Type definition for an event callback.

<b>Signature:</b>

```typescript
export type NextOrObserver<T> = NextFn<T | null> | Observer<T | null>;
```

## PhoneInfoOptions

The information required to verify the ownership of a phone number.

The information that's required depends on whether you are doing single-factor sign-in, multi-factor enrollment or multi-factor sign-in.

<b>Signature:</b>

```typescript
export type PhoneInfoOptions = PhoneSingleFactorInfoOptions | PhoneMultiFactorEnrollInfoOptions | PhoneMultiFactorSignInInfoOptions;
```

## UserProfile

User profile used in [AdditionalUserInfo](./auth.additionaluserinfo.md#additionaluserinfo_interface)<!-- -->.

<b>Signature:</b>

```typescript
export type UserProfile = Record<string, unknown>;
```
