Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# MultiFactorError interface
The error thrown when the user needs to provide a second factor to sign in successfully.

The error code for this error is `auth/multi-factor-auth-required`<!-- -->.

<b>Signature:</b>

```typescript
export interface MultiFactorError extends AuthError 
```
<b>Extends:</b> [AuthError](./auth.autherror.md#autherror_interface)

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [customData](./auth.multifactorerror.md#multifactorerrorcustomdata) | [AuthError](./auth.autherror.md#autherror_interface)<!-- -->\['customData'\] &amp; { readonly operationType: (typeof [OperationTypeMap](./auth.md#operationtype)<!-- -->)\[keyof typeof [OperationTypeMap](./auth.md#operationtype)<!-- -->\]; } | Details about the MultiFactorError. |

## MultiFactorError.customData

Details about the MultiFactorError.

<b>Signature:</b>

```typescript
readonly customData: AuthError['customData'] & {
        readonly operationType: (typeof OperationTypeMap)[keyof typeof OperationTypeMap];
    };
```

### Example


```javascript
let resolver;
let multiFactorHints;

signInWithEmailAndPassword(auth, email, password)
    .then((result) => {
      // User signed in. No 2nd factor challenge is needed.
    })
    .catch((error) => {
      if (error.code == 'auth/multi-factor-auth-required') {
        resolver = getMultiFactorResolver(auth, error);
        multiFactorHints = resolver.hints;
      } else {
        // Handle other errors.
      }
    });

// Obtain a multiFactorAssertion by verifying the second factor.

const userCredential = await resolver.resolveSignIn(multiFactorAssertion);

```

