Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# OAuthCredential class
Represents the OAuth credentials returned by an [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class)<!-- -->.

Implementations specify the details about each auth provider's credential requirements.

<b>Signature:</b>

```typescript
export declare class OAuthCredential extends AuthCredential 
```
<b>Extends:</b> [AuthCredential](./auth.authcredential.md#authcredential_class)

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [accessToken](./auth.oauthcredential.md#oauthcredentialaccesstoken) |  | string | The OAuth access token associated with the credential if it belongs to an [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class)<!-- -->, such as <code>facebook.com</code>, <code>twitter.com</code>, etc. |
|  [idToken](./auth.oauthcredential.md#oauthcredentialidtoken) |  | string | The OAuth ID token associated with the credential if it belongs to an OIDC provider, such as <code>google.com</code>. |
|  [secret](./auth.oauthcredential.md#oauthcredentialsecret) |  | string | The OAuth access token secret associated with the credential if it belongs to an OAuth 1.0 provider, such as <code>twitter.com</code>. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [fromJSON(json)](./auth.oauthcredential.md#oauthcredentialfromjson) | <code>static</code> | Static method to deserialize a JSON representation of an object into an [AuthCredential](./auth.authcredential.md#authcredential_class)<!-- -->. |
|  [toJSON()](./auth.oauthcredential.md#oauthcredentialtojson) |  | Returns a JSON-serializable representation of this object. |

## OAuthCredential.accessToken

The OAuth access token associated with the credential if it belongs to an [OAuthProvider](./auth.oauthprovider.md#oauthprovider_class)<!-- -->, such as `facebook.com`<!-- -->, `twitter.com`<!-- -->, etc.

<b>Signature:</b>

```typescript
accessToken?: string;
```

## OAuthCredential.idToken

The OAuth ID token associated with the credential if it belongs to an OIDC provider, such as `google.com`<!-- -->.

<b>Signature:</b>

```typescript
idToken?: string;
```

## OAuthCredential.secret

The OAuth access token secret associated with the credential if it belongs to an OAuth 1.0 provider, such as `twitter.com`<!-- -->.

<b>Signature:</b>

```typescript
secret?: string;
```

## OAuthCredential.fromJSON()

Static method to deserialize a JSON representation of an object into an [AuthCredential](./auth.authcredential.md#authcredential_class)<!-- -->.

<b>Signature:</b>

```typescript
static fromJSON(json: string | object): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  json | string \| object | Input can be either Object or the stringified representation of the object. When string is provided, JSON.parse would be called first. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

If the JSON input does not represent an [AuthCredential](./auth.authcredential.md#authcredential_class)<!-- -->, null is returned.

## OAuthCredential.toJSON()

Returns a JSON-serializable representation of this object.

<b>Signature:</b>

```typescript
toJSON(): object;
```
<b>Returns:</b>

object

a JSON-serializable representation of this object.

