Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# OAuthProvider class
Provider for generating generic [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class)<!-- -->.

<b>Signature:</b>

```typescript
export declare class OAuthProvider extends BaseOAuthProvider 
```
<b>Extends:</b> BaseOAuthProvider

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [credential(params)](./auth.oauthprovider.md#oauthprovidercredential) |  | Creates a [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a generic OAuth provider's access token or ID token. |
|  [credentialFromError(error)](./auth.oauthprovider.md#oauthprovidercredentialfromerror) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation. |
|  [credentialFromJSON(json)](./auth.oauthprovider.md#oauthprovidercredentialfromjson) | <code>static</code> | Creates an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a JSON string or a plain object. |
|  [credentialFromResult(userCredential)](./auth.oauthprovider.md#oauthprovidercredentialfromresult) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->. |

## OAuthProvider.credential()

Creates a [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a generic OAuth provider's access token or ID token.

The raw nonce is required when an ID token with a nonce field is provided. The SHA-256 hash of the raw nonce must match the nonce field in the ID token.

<b>Signature:</b>

```typescript
credential(params: OAuthCredentialOptions): OAuthCredential;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  params | [OAuthCredentialOptions](./auth.oauthcredentialoptions.md#oauthcredentialoptions_interface) | Either the options object containing the ID token, access token and raw nonce or the ID token string. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class)

### Example


```javascript
// `googleUser` from the onsuccess Google Sign In callback.
// Initialize a generate OAuth provider with a `google.com` providerId.
const provider = new OAuthProvider('google.com');
const credential = provider.credential({
  idToken: googleUser.getAuthResponse().id_token,
});
const result = await signInWithCredential(credential);

```

## OAuthProvider.credentialFromError()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation.

<b>Signature:</b>

```typescript
static credentialFromError(error: FirebaseError): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  error | [FirebaseError](./util.firebaseerror.md#firebaseerror_class) |  |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

## OAuthProvider.credentialFromJSON()

Creates an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a JSON string or a plain object.

<b>Signature:</b>

```typescript
static credentialFromJSON(json: object | string): OAuthCredential;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  json | object \| string | A plain object or a JSON string |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class)

## OAuthProvider.credentialFromResult()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->.

<b>Signature:</b>

```typescript
static credentialFromResult(userCredential: UserCredential): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  userCredential | [UserCredential](./auth.usercredential.md#usercredential_interface) | The user credential. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

### Example 1


```javascript
// Sign in using a redirect.
const provider = new OAuthProvider('google.com');
// Start a sign in process for an unauthenticated user.
provider.addScope('profile');
provider.addScope('email');
await signInWithRedirect(auth, provider);
// This will trigger a full page redirect away from your app

// After returning from the redirect when your app initializes you can obtain the result
const result = await getRedirectResult(auth);
if (result) {
  // This is the signed-in user
  const user = result.user;
  // This gives you a OAuth Access Token for the provider.
  const credential = provider.credentialFromResult(auth, result);
  const token = credential.accessToken;
}

```

### Example 2


```javascript
// Sign in using a popup.
const provider = new OAuthProvider('google.com');
provider.addScope('profile');
provider.addScope('email');
const result = await signInWithPopup(auth, provider);

// The signed-in user info.
const user = result.user;
// This gives you a OAuth Access Token for the provider.
const credential = provider.credentialFromResult(auth, result);
const token = credential.accessToken;

```

