Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# PasswordPolicy interface
A structure specifying password policy requirements.

<b>Signature:</b>

```typescript
export interface PasswordPolicy 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [allowedNonAlphanumericCharacters](./auth.passwordpolicy.md#passwordpolicyallowednonalphanumericcharacters) | string | List of characters that are considered non-alphanumeric during validation. |
|  [customStrengthOptions](./auth.passwordpolicy.md#passwordpolicycustomstrengthoptions) | { readonly minPasswordLength?: number; readonly maxPasswordLength?: number; readonly containsLowercaseLetter?: boolean; readonly containsUppercaseLetter?: boolean; readonly containsNumericCharacter?: boolean; readonly containsNonAlphanumericCharacter?: boolean; } | Requirements enforced by this password policy. |
|  [enforcementState](./auth.passwordpolicy.md#passwordpolicyenforcementstate) | string | The enforcement state of the policy. Can be 'OFF' or 'ENFORCE'. |
|  [forceUpgradeOnSignin](./auth.passwordpolicy.md#passwordpolicyforceupgradeonsignin) | boolean | Whether existing passwords must meet the policy. |

## PasswordPolicy.allowedNonAlphanumericCharacters

List of characters that are considered non-alphanumeric during validation.

<b>Signature:</b>

```typescript
readonly allowedNonAlphanumericCharacters: string;
```

## PasswordPolicy.customStrengthOptions

Requirements enforced by this password policy.

<b>Signature:</b>

```typescript
readonly customStrengthOptions: {
        readonly minPasswordLength?: number;
        readonly maxPasswordLength?: number;
        readonly containsLowercaseLetter?: boolean;
        readonly containsUppercaseLetter?: boolean;
        readonly containsNumericCharacter?: boolean;
        readonly containsNonAlphanumericCharacter?: boolean;
    };
```

## PasswordPolicy.enforcementState

The enforcement state of the policy. Can be 'OFF' or 'ENFORCE'.

<b>Signature:</b>

```typescript
readonly enforcementState: string;
```

## PasswordPolicy.forceUpgradeOnSignin

Whether existing passwords must meet the policy.

<b>Signature:</b>

```typescript
readonly forceUpgradeOnSignin: boolean;
```
