Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# PasswordValidationStatus interface
A structure indicating which password policy requirements were met or violated and what the requirements are.

<b>Signature:</b>

```typescript
export interface PasswordValidationStatus 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [containsLowercaseLetter](./auth.passwordvalidationstatus.md#passwordvalidationstatuscontainslowercaseletter) | boolean | Whether the password contains a lowercase letter, or undefined if not required. |
|  [containsNonAlphanumericCharacter](./auth.passwordvalidationstatus.md#passwordvalidationstatuscontainsnonalphanumericcharacter) | boolean | Whether the password contains a non-alphanumeric character, or undefined if not required. |
|  [containsNumericCharacter](./auth.passwordvalidationstatus.md#passwordvalidationstatuscontainsnumericcharacter) | boolean | Whether the password contains a numeric character, or undefined if not required. |
|  [containsUppercaseLetter](./auth.passwordvalidationstatus.md#passwordvalidationstatuscontainsuppercaseletter) | boolean | Whether the password contains an uppercase letter, or undefined if not required. |
|  [isValid](./auth.passwordvalidationstatus.md#passwordvalidationstatusisvalid) | boolean | Whether the password meets all requirements. |
|  [meetsMaxPasswordLength](./auth.passwordvalidationstatus.md#passwordvalidationstatusmeetsmaxpasswordlength) | boolean | Whether the password meets the maximum password length, or undefined if not required. |
|  [meetsMinPasswordLength](./auth.passwordvalidationstatus.md#passwordvalidationstatusmeetsminpasswordlength) | boolean | Whether the password meets the minimum password length, or undefined if not required. |
|  [passwordPolicy](./auth.passwordvalidationstatus.md#passwordvalidationstatuspasswordpolicy) | [PasswordPolicy](./auth.passwordpolicy.md#passwordpolicy_interface) | The policy used to validate the password. |

## PasswordValidationStatus.containsLowercaseLetter

Whether the password contains a lowercase letter, or undefined if not required.

<b>Signature:</b>

```typescript
readonly containsLowercaseLetter?: boolean;
```

## PasswordValidationStatus.containsNonAlphanumericCharacter

Whether the password contains a non-alphanumeric character, or undefined if not required.

<b>Signature:</b>

```typescript
readonly containsNonAlphanumericCharacter?: boolean;
```

## PasswordValidationStatus.containsNumericCharacter

Whether the password contains a numeric character, or undefined if not required.

<b>Signature:</b>

```typescript
readonly containsNumericCharacter?: boolean;
```

## PasswordValidationStatus.containsUppercaseLetter

Whether the password contains an uppercase letter, or undefined if not required.

<b>Signature:</b>

```typescript
readonly containsUppercaseLetter?: boolean;
```

## PasswordValidationStatus.isValid

Whether the password meets all requirements.

<b>Signature:</b>

```typescript
readonly isValid: boolean;
```

## PasswordValidationStatus.meetsMaxPasswordLength

Whether the password meets the maximum password length, or undefined if not required.

<b>Signature:</b>

```typescript
readonly meetsMaxPasswordLength?: boolean;
```

## PasswordValidationStatus.meetsMinPasswordLength

Whether the password meets the minimum password length, or undefined if not required.

<b>Signature:</b>

```typescript
readonly meetsMinPasswordLength?: boolean;
```

## PasswordValidationStatus.passwordPolicy

The policy used to validate the password.

<b>Signature:</b>

```typescript
readonly passwordPolicy: PasswordPolicy;
```
