Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# PhoneAuthProvider class
Provider for generating an [PhoneAuthCredential](./auth.phoneauthcredential.md#phoneauthcredential_class)<!-- -->.

`PhoneAuthProvider` does not work in a Node.js environment.

<b>Signature:</b>

```typescript
export declare class PhoneAuthProvider 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(auth)](./auth.phoneauthprovider.md#phoneauthproviderconstructor) |  | Constructs a new instance of the <code>PhoneAuthProvider</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [PHONE\_SIGN\_IN\_METHOD](./auth.phoneauthprovider.md#phoneauthproviderphone_sign_in_method) | <code>static</code> | 'phone' | Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.PHONE. |
|  [PROVIDER\_ID](./auth.phoneauthprovider.md#phoneauthproviderprovider_id) | <code>static</code> | 'phone' | Always set to [ProviderId](./auth.md#providerid)<!-- -->.PHONE. |
|  [providerId](./auth.phoneauthprovider.md#phoneauthproviderproviderid) |  | "phone" | Always set to [ProviderId](./auth.md#providerid)<!-- -->.PHONE. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [credential(verificationId, verificationCode)](./auth.phoneauthprovider.md#phoneauthprovidercredential) | <code>static</code> | Creates a phone auth credential, given the verification ID from [PhoneAuthProvider.verifyPhoneNumber()](./auth.phoneauthprovider.md#phoneauthproviderverifyphonenumber) and the code that was sent to the user's mobile device. |
|  [credentialFromError(error)](./auth.phoneauthprovider.md#phoneauthprovidercredentialfromerror) | <code>static</code> | Returns an [AuthCredential](./auth.authcredential.md#authcredential_class) when passed an error. |
|  [credentialFromResult(userCredential)](./auth.phoneauthprovider.md#phoneauthprovidercredentialfromresult) | <code>static</code> | Generates an [AuthCredential](./auth.authcredential.md#authcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->. |
|  [verifyPhoneNumber(phoneOptions, applicationVerifier)](./auth.phoneauthprovider.md#phoneauthproviderverifyphonenumber) |  | Starts a phone number authentication flow by sending a verification code to the given phone number. |

## PhoneAuthProvider.(constructor)

Constructs a new instance of the `PhoneAuthProvider` class

<b>Signature:</b>

```typescript
constructor(auth: Auth);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  auth | [Auth](./auth.auth.md#auth_interface) | The Firebase [Auth](./auth.auth.md#auth_interface) instance in which sign-ins should occur. |

## PhoneAuthProvider.PHONE\_SIGN\_IN\_METHOD

Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.PHONE.

<b>Signature:</b>

```typescript
static readonly PHONE_SIGN_IN_METHOD: 'phone';
```

## PhoneAuthProvider.PROVIDER\_ID

Always set to [ProviderId](./auth.md#providerid)<!-- -->.PHONE.

<b>Signature:</b>

```typescript
static readonly PROVIDER_ID: 'phone';
```

## PhoneAuthProvider.providerId

Always set to [ProviderId](./auth.md#providerid)<!-- -->.PHONE.

<b>Signature:</b>

```typescript
readonly providerId: "phone";
```

## PhoneAuthProvider.credential()

Creates a phone auth credential, given the verification ID from [PhoneAuthProvider.verifyPhoneNumber()](./auth.phoneauthprovider.md#phoneauthproviderverifyphonenumber) and the code that was sent to the user's mobile device.

<b>Signature:</b>

```typescript
static credential(verificationId: string, verificationCode: string): PhoneAuthCredential;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  verificationId | string | The verification ID returned from [PhoneAuthProvider.verifyPhoneNumber()](./auth.phoneauthprovider.md#phoneauthproviderverifyphonenumber)<!-- -->. |
|  verificationCode | string | The verification code sent to the user's mobile device. |

<b>Returns:</b>

[PhoneAuthCredential](./auth.phoneauthcredential.md#phoneauthcredential_class)

The auth provider credential.

### Example 1


```javascript
const provider = new PhoneAuthProvider(auth);
const verificationId = provider.verifyPhoneNumber(phoneNumber, applicationVerifier);
// Obtain verificationCode from the user.
const authCredential = PhoneAuthProvider.credential(verificationId, verificationCode);
const userCredential = signInWithCredential(auth, authCredential);

```

### Example 2

An alternative flow is provided using the `signInWithPhoneNumber` method.

```javascript
const confirmationResult = await signInWithPhoneNumber(auth, phoneNumber, applicationVerifier);
// Obtain verificationCode from the user.
const userCredential = await confirmationResult.confirm(verificationCode);

```

## PhoneAuthProvider.credentialFromError()

Returns an [AuthCredential](./auth.authcredential.md#authcredential_class) when passed an error.

This method works for errors like `auth/account-exists-with-different-credentials`<!-- -->. This is useful for recovering when attempting to set a user's phone number but the number in question is already tied to another account. For example, the following code tries to update the current user's phone number, and if that fails, links the user with the account associated with that number:

```js
const provider = new PhoneAuthProvider(auth);
const verificationId = await provider.verifyPhoneNumber(number, verifier);
try {
  const code = ''; // Prompt the user for the verification code
  await updatePhoneNumber(
      auth.currentUser,
      PhoneAuthProvider.credential(verificationId, code));
} catch (e) {
  if ((e as FirebaseError)?.code === 'auth/account-exists-with-different-credential') {
    const cred = PhoneAuthProvider.credentialFromError(e);
    await linkWithCredential(auth.currentUser, cred);
  }
}

// At this point, auth.currentUser.phoneNumber === number.

```

<b>Signature:</b>

```typescript
static credentialFromError(error: FirebaseError): AuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  error | [FirebaseError](./util.firebaseerror.md#firebaseerror_class) | The error to generate a credential from. |

<b>Returns:</b>

[AuthCredential](./auth.authcredential.md#authcredential_class) \| null

## PhoneAuthProvider.credentialFromResult()

Generates an [AuthCredential](./auth.authcredential.md#authcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->.

<b>Signature:</b>

```typescript
static credentialFromResult(userCredential: UserCredential): AuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  userCredential | [UserCredential](./auth.usercredential.md#usercredential_interface) | The user credential. |

<b>Returns:</b>

[AuthCredential](./auth.authcredential.md#authcredential_class) \| null

## PhoneAuthProvider.verifyPhoneNumber()

Starts a phone number authentication flow by sending a verification code to the given phone number.

<b>Signature:</b>

```typescript
verifyPhoneNumber(phoneOptions: PhoneInfoOptions | string, applicationVerifier?: ApplicationVerifier): Promise<string>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  phoneOptions | [PhoneInfoOptions](./auth.md#phoneinfooptions) \| string |  |
|  applicationVerifier | [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface) | An [ApplicationVerifier](./auth.applicationverifier.md#applicationverifier_interface)<!-- -->, which prevents requests from unauthorized clients. This SDK includes an implementation based on reCAPTCHA v2, [RecaptchaVerifier](./auth.recaptchaverifier.md#recaptchaverifier_class)<!-- -->. If you've enabled reCAPTCHA Enterprise bot protection in Enforce mode, this parameter is optional; in all other configurations, the parameter is required. |

<b>Returns:</b>

Promise&lt;string&gt;

A Promise for a verification ID that can be passed to [PhoneAuthProvider.credential()](./auth.phoneauthprovider.md#phoneauthprovidercredential) to identify this flow.

### Example 1


```javascript
const provider = new PhoneAuthProvider(auth);
const verificationId = await provider.verifyPhoneNumber(phoneNumber, applicationVerifier);
// Obtain verificationCode from the user.
const authCredential = PhoneAuthProvider.credential(verificationId, verificationCode);
const userCredential = await signInWithCredential(auth, authCredential);

```

### Example 2

An alternative flow is provided using the `signInWithPhoneNumber` method.

```javascript
const confirmationResult = signInWithPhoneNumber(auth, phoneNumber, applicationVerifier);
// Obtain verificationCode from the user.
const userCredential = confirmationResult.confirm(verificationCode);

```

### Example


```javascript
// 'recaptcha-container' is the ID of an element in the DOM.
const applicationVerifier = new RecaptchaVerifier('recaptcha-container');
const provider = new PhoneAuthProvider(auth);
const verificationId = await provider.verifyPhoneNumber('+16505550101', applicationVerifier);
// Obtain the verificationCode from the user.
const phoneCredential = PhoneAuthProvider.credential(verificationId, verificationCode);
const userCredential = await signInWithCredential(auth, phoneCredential);

```

