Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# RecaptchaVerifier class
An [reCAPTCHA](https://www.google.com/recaptcha/)<!-- -->-based application verifier.

`RecaptchaVerifier` does not work in a Node.js environment.

<b>Signature:</b>

```typescript
export declare class RecaptchaVerifier implements ApplicationVerifierInternal 
```
<b>Implements:</b> ApplicationVerifierInternal

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(authExtern, containerOrId, parameters)](./auth.recaptchaverifier.md#recaptchaverifierconstructor) |  | Constructs a new instance of the <code>RecaptchaVerifier</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [type](./auth.recaptchaverifier.md#recaptchaverifiertype) |  | (not declared) | The application verifier type. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [clear()](./auth.recaptchaverifier.md#recaptchaverifierclear) |  | Clears the reCAPTCHA widget from the page and destroys the instance. |
|  [render()](./auth.recaptchaverifier.md#recaptchaverifierrender) |  | Renders the reCAPTCHA widget on the page. |
|  [verify()](./auth.recaptchaverifier.md#recaptchaverifierverify) |  | Waits for the user to solve the reCAPTCHA and resolves with the reCAPTCHA token. |

## RecaptchaVerifier.(constructor)

Constructs a new instance of the `RecaptchaVerifier` class

Check the reCAPTCHA docs for a comprehensive list. All parameters are accepted except for the sitekey. Firebase Auth backend provisions a reCAPTCHA for each project and will configure this upon rendering. For an invisible reCAPTCHA, a size key must have the value 'invisible'.

<b>Signature:</b>

```typescript
constructor(authExtern: Auth, containerOrId: HTMLElement | string, parameters?: RecaptchaParameters);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  authExtern | [Auth](./auth.auth.md#auth_interface) | The corresponding Firebase [Auth](./auth.auth.md#auth_interface) instance. |
|  containerOrId | HTMLElement \| string | The reCAPTCHA container parameter. |
|  parameters | [RecaptchaParameters](./auth.recaptchaparameters.md#recaptchaparameters_interface) | The optional reCAPTCHA parameters. |

## RecaptchaVerifier.type

The application verifier type.

For a reCAPTCHA verifier, this is 'recaptcha'.

<b>Signature:</b>

```typescript
readonly type = "recaptcha";
```

## RecaptchaVerifier.clear()

Clears the reCAPTCHA widget from the page and destroys the instance.

<b>Signature:</b>

```typescript
clear(): void;
```
<b>Returns:</b>

void

## RecaptchaVerifier.render()

Renders the reCAPTCHA widget on the page.

<b>Signature:</b>

```typescript
render(): Promise<number>;
```
<b>Returns:</b>

Promise&lt;number&gt;

A Promise that resolves with the reCAPTCHA widget ID.

## RecaptchaVerifier.verify()

Waits for the user to solve the reCAPTCHA and resolves with the reCAPTCHA token.

<b>Signature:</b>

```typescript
verify(): Promise<string>;
```
<b>Returns:</b>

Promise&lt;string&gt;

A Promise for the reCAPTCHA token.

