Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# SAMLAuthProvider class
An [AuthProvider](./auth.authprovider.md#authprovider_interface) for SAML.

<b>Signature:</b>

```typescript
export declare class SAMLAuthProvider extends FederatedAuthProvider 
```
<b>Extends:</b> FederatedAuthProvider

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(providerId)](./auth.samlauthprovider.md#samlauthproviderconstructor) |  | Constructor. The providerId must start with "saml." |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [credentialFromError(error)](./auth.samlauthprovider.md#samlauthprovidercredentialfromerror) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation. |
|  [credentialFromJSON(json)](./auth.samlauthprovider.md#samlauthprovidercredentialfromjson) | <code>static</code> | Creates an [AuthCredential](./auth.authcredential.md#authcredential_class) from a JSON string or a plain object. |
|  [credentialFromResult(userCredential)](./auth.samlauthprovider.md#samlauthprovidercredentialfromresult) | <code>static</code> | Generates an [AuthCredential](./auth.authcredential.md#authcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface) after a successful SAML flow completes. |

## SAMLAuthProvider.(constructor)

Constructor. The providerId must start with "saml."

<b>Signature:</b>

```typescript
constructor(providerId: string);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  providerId | string | SAML provider ID. |

## SAMLAuthProvider.credentialFromError()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation.

<b>Signature:</b>

```typescript
static credentialFromError(error: FirebaseError): AuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  error | [FirebaseError](./util.firebaseerror.md#firebaseerror_class) |  |

<b>Returns:</b>

[AuthCredential](./auth.authcredential.md#authcredential_class) \| null

## SAMLAuthProvider.credentialFromJSON()

Creates an [AuthCredential](./auth.authcredential.md#authcredential_class) from a JSON string or a plain object.

<b>Signature:</b>

```typescript
static credentialFromJSON(json: string | object): AuthCredential;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  json | string \| object | A plain object or a JSON string |

<b>Returns:</b>

[AuthCredential](./auth.authcredential.md#authcredential_class)

## SAMLAuthProvider.credentialFromResult()

Generates an [AuthCredential](./auth.authcredential.md#authcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface) after a successful SAML flow completes.

For example, to get an [AuthCredential](./auth.authcredential.md#authcredential_class)<!-- -->, you could write the following code:

```js
const userCredential = await signInWithPopup(auth, samlProvider);
const credential = SAMLAuthProvider.credentialFromResult(userCredential);

```

<b>Signature:</b>

```typescript
static credentialFromResult(userCredential: UserCredential): AuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  userCredential | [UserCredential](./auth.usercredential.md#usercredential_interface) | The user credential. |

<b>Returns:</b>

[AuthCredential](./auth.authcredential.md#authcredential_class) \| null

