Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# TotpSecret class
Provider for generating a [TotpMultiFactorAssertion](./auth.totpmultifactorassertion.md#totpmultifactorassertion_interface)<!-- -->.

Stores the shared secret key and other parameters to generate time-based OTPs. Implements methods to retrieve the shared secret key and generate a QR code URL.

<b>Signature:</b>

```typescript
export declare class TotpSecret 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [codeIntervalSeconds](./auth.totpsecret.md#totpsecretcodeintervalseconds) |  | number | The interval (in seconds) when the OTP codes should change. |
|  [codeLength](./auth.totpsecret.md#totpsecretcodelength) |  | number | Length of the one-time passwords to be generated. |
|  [enrollmentCompletionDeadline](./auth.totpsecret.md#totpsecretenrollmentcompletiondeadline) |  | string | The timestamp (UTC string) by which TOTP enrollment should be completed. |
|  [hashingAlgorithm](./auth.totpsecret.md#totpsecrethashingalgorithm) |  | string | Hashing algorithm used. |
|  [secretKey](./auth.totpsecret.md#totpsecretsecretkey) |  | string | Shared secret key/seed used for enrolling in TOTP MFA and generating OTPs. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [generateQrCodeUrl(accountName, issuer)](./auth.totpsecret.md#totpsecretgenerateqrcodeurl) |  | Returns a QR code URL as described in https://github.com/google/google-authenticator/wiki/Key-Uri-Format This can be displayed to the user as a QR code to be scanned into a TOTP app like Google Authenticator. If the optional parameters are unspecified, an accountName of <userEmail> and issuer of <firebaseAppName> are used. |

## TotpSecret.codeIntervalSeconds

The interval (in seconds) when the OTP codes should change.

<b>Signature:</b>

```typescript
readonly codeIntervalSeconds: number;
```

## TotpSecret.codeLength

Length of the one-time passwords to be generated.

<b>Signature:</b>

```typescript
readonly codeLength: number;
```

## TotpSecret.enrollmentCompletionDeadline

The timestamp (UTC string) by which TOTP enrollment should be completed.

<b>Signature:</b>

```typescript
readonly enrollmentCompletionDeadline: string;
```

## TotpSecret.hashingAlgorithm

Hashing algorithm used.

<b>Signature:</b>

```typescript
readonly hashingAlgorithm: string;
```

## TotpSecret.secretKey

Shared secret key/seed used for enrolling in TOTP MFA and generating OTPs.

<b>Signature:</b>

```typescript
readonly secretKey: string;
```

## TotpSecret.generateQrCodeUrl()

Returns a QR code URL as described in https://github.com/google/google-authenticator/wiki/Key-Uri-Format This can be displayed to the user as a QR code to be scanned into a TOTP app like Google Authenticator. If the optional parameters are unspecified, an accountName of <userEmail> and issuer of <firebaseAppName> are used.

<b>Signature:</b>

```typescript
generateQrCodeUrl(accountName?: string, issuer?: string): string;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  accountName | string | the name of the account/app along with a user identifier. |
|  issuer | string | issuer of the TOTP (likely the app name). |

<b>Returns:</b>

string

A QR code URL string.

