Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# TwitterAuthProvider class
Provider for generating an [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) for [ProviderId](./auth.md#providerid)<!-- -->.TWITTER.

<b>Signature:</b>

```typescript
export declare class TwitterAuthProvider extends BaseOAuthProvider 
```
<b>Extends:</b> BaseOAuthProvider

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)()](./auth.twitterauthprovider.md#twitterauthproviderconstructor) |  | Constructs a new instance of the <code>TwitterAuthProvider</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [PROVIDER\_ID](./auth.twitterauthprovider.md#twitterauthproviderprovider_id) | <code>static</code> | 'twitter.com' | Always set to [ProviderId](./auth.md#providerid)<!-- -->.TWITTER. |
|  [TWITTER\_SIGN\_IN\_METHOD](./auth.twitterauthprovider.md#twitterauthprovidertwitter_sign_in_method) | <code>static</code> | 'twitter.com' | Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.TWITTER. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [credential(token, secret)](./auth.twitterauthprovider.md#twitterauthprovidercredential) | <code>static</code> | Creates a credential for Twitter. |
|  [credentialFromError(error)](./auth.twitterauthprovider.md#twitterauthprovidercredentialfromerror) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation. |
|  [credentialFromResult(userCredential)](./auth.twitterauthprovider.md#twitterauthprovidercredentialfromresult) | <code>static</code> | Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->. |

## TwitterAuthProvider.(constructor)

Constructs a new instance of the `TwitterAuthProvider` class

<b>Signature:</b>

```typescript
constructor();
```

## TwitterAuthProvider.PROVIDER\_ID

Always set to [ProviderId](./auth.md#providerid)<!-- -->.TWITTER.

<b>Signature:</b>

```typescript
static readonly PROVIDER_ID: 'twitter.com';
```

## TwitterAuthProvider.TWITTER\_SIGN\_IN\_METHOD

Always set to [SignInMethod](./auth.md#signinmethod)<!-- -->.TWITTER.

<b>Signature:</b>

```typescript
static readonly TWITTER_SIGN_IN_METHOD: 'twitter.com';
```

## TwitterAuthProvider.credential()

Creates a credential for Twitter.

<b>Signature:</b>

```typescript
static credential(token: string, secret: string): OAuthCredential;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  token | string | Twitter access token. |
|  secret | string | Twitter secret. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class)

## TwitterAuthProvider.credentialFromError()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [AuthError](./auth.autherror.md#autherror_interface) which was thrown during a sign-in, link, or reauthenticate operation.

<b>Signature:</b>

```typescript
static credentialFromError(error: FirebaseError): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  error | [FirebaseError](./util.firebaseerror.md#firebaseerror_class) |  |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

## TwitterAuthProvider.credentialFromResult()

Used to extract the underlying [OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) from a [UserCredential](./auth.usercredential.md#usercredential_interface)<!-- -->.

<b>Signature:</b>

```typescript
static credentialFromResult(userCredential: UserCredential): OAuthCredential | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  userCredential | [UserCredential](./auth.usercredential.md#usercredential_interface) | The user credential. |

<b>Returns:</b>

[OAuthCredential](./auth.oauthcredential.md#oauthcredential_class) \| null

### Example 1


```javascript
// Sign in using a redirect.
const provider = new TwitterAuthProvider();
// Start a sign in process for an unauthenticated user.
await signInWithRedirect(auth, provider);
// This will trigger a full page redirect away from your app

// After returning from the redirect when your app initializes you can obtain the result
const result = await getRedirectResult(auth);
if (result) {
  // This is the signed-in user
  const user = result.user;
  // This gives you a Twitter Access Token and Secret.
  const credential = TwitterAuthProvider.credentialFromResult(result);
  const token = credential.accessToken;
  const secret = credential.secret;
}

```

### Example 2


```javascript
// Sign in using a popup.
const provider = new TwitterAuthProvider();
const result = await signInWithPopup(auth, provider);

// The signed-in user info.
const user = result.user;
// This gives you a Twitter Access Token and Secret.
const credential = TwitterAuthProvider.credentialFromResult(result);
const token = credential.accessToken;
const secret = credential.secret;

```

