Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# User interface
A user account.

<b>Signature:</b>

```typescript
export interface User extends UserInfo 
```
<b>Extends:</b> [UserInfo](./auth.userinfo.md#userinfo_interface)

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [emailVerified](./auth.user.md#useremailverified) | boolean | Whether the email has been verified with [sendEmailVerification()](./auth.md#sendemailverification_6a885d6) and [applyActionCode()](./auth.md#applyactioncode_d2ae15a)<!-- -->. |
|  [isAnonymous](./auth.user.md#userisanonymous) | boolean | Whether the user is authenticated using the [ProviderId](./auth.md#providerid)<!-- -->.ANONYMOUS provider. |
|  [metadata](./auth.user.md#usermetadata) | [UserMetadata](./auth.usermetadata.md#usermetadata_interface) | Additional metadata around user creation and sign-in times. |
|  [providerData](./auth.user.md#userproviderdata) | [UserInfo](./auth.userinfo.md#userinfo_interface)<!-- -->\[\] | Additional per provider such as displayName and profile information. |
|  [refreshToken](./auth.user.md#userrefreshtoken) | string | Refresh token used to reauthenticate the user. Avoid using this directly and prefer [User.getIdToken()](./auth.user.md#usergetidtoken) to refresh the ID token instead. |
|  [tenantId](./auth.user.md#usertenantid) | string \| null | The user's tenant ID. |

## Methods

|  Method | Description |
|  --- | --- |
|  [delete()](./auth.user.md#userdelete) | Deletes and signs out the user. |
|  [getIdToken(forceRefresh)](./auth.user.md#usergetidtoken) | Returns a JSON Web Token (JWT) used to identify the user to a Firebase service. |
|  [getIdTokenResult(forceRefresh)](./auth.user.md#usergetidtokenresult) | Returns a deserialized JSON Web Token (JWT) used to identify the user to a Firebase service. |
|  [reload()](./auth.user.md#userreload) | Refreshes the user, if signed in. |
|  [toJSON()](./auth.user.md#usertojson) | Returns a JSON-serializable representation of this object. |

## User.emailVerified

Whether the email has been verified with [sendEmailVerification()](./auth.md#sendemailverification_6a885d6) and [applyActionCode()](./auth.md#applyactioncode_d2ae15a)<!-- -->.

<b>Signature:</b>

```typescript
readonly emailVerified: boolean;
```

## User.isAnonymous

Whether the user is authenticated using the [ProviderId](./auth.md#providerid)<!-- -->.ANONYMOUS provider.

<b>Signature:</b>

```typescript
readonly isAnonymous: boolean;
```

## User.metadata

Additional metadata around user creation and sign-in times.

<b>Signature:</b>

```typescript
readonly metadata: UserMetadata;
```

## User.providerData

Additional per provider such as displayName and profile information.

<b>Signature:</b>

```typescript
readonly providerData: UserInfo[];
```

## User.refreshToken

Refresh token used to reauthenticate the user. Avoid using this directly and prefer [User.getIdToken()](./auth.user.md#usergetidtoken) to refresh the ID token instead.

<b>Signature:</b>

```typescript
readonly refreshToken: string;
```

## User.tenantId

The user's tenant ID.

This is a read-only property, which indicates the tenant ID used to sign in the user. This is null if the user is signed in from the parent project.

<b>Signature:</b>

```typescript
readonly tenantId: string | null;
```

### Example


```javascript
// Set the tenant ID on Auth instance.
auth.tenantId = 'TENANT_PROJECT_ID';

// All future sign-in request now include tenant ID.
const result = await signInWithEmailAndPassword(auth, email, password);
// result.user.tenantId should be 'TENANT_PROJECT_ID'.

```

## User.delete()

Deletes and signs out the user.

Important: this is a security-sensitive operation that requires the user to have recently signed in. If this requirement isn't met, ask the user to authenticate again and then call one of the reauthentication methods like [reauthenticateWithCredential()](./auth.md#reauthenticatewithcredential_60f8043)<!-- -->.

This method is not supported on any [User](./auth.user.md#user_interface) signed in by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
delete(): Promise<void>;
```
<b>Returns:</b>

Promise&lt;void&gt;

## User.getIdToken()

Returns a JSON Web Token (JWT) used to identify the user to a Firebase service.

Returns the current token if it has not expired or if it will not expire in the next five minutes. Otherwise, this will refresh the token and return a new one.

<b>Signature:</b>

```typescript
getIdToken(forceRefresh?: boolean): Promise<string>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  forceRefresh | boolean | Force refresh regardless of token expiration. |

<b>Returns:</b>

Promise&lt;string&gt;

## User.getIdTokenResult()

Returns a deserialized JSON Web Token (JWT) used to identify the user to a Firebase service.

Returns the current token if it has not expired or if it will not expire in the next five minutes. Otherwise, this will refresh the token and return a new one.

<b>Signature:</b>

```typescript
getIdTokenResult(forceRefresh?: boolean): Promise<IdTokenResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  forceRefresh | boolean | Force refresh regardless of token expiration. |

<b>Returns:</b>

Promise&lt;[IdTokenResult](./auth.idtokenresult.md#idtokenresult_interface)<!-- -->&gt;

## User.reload()

Refreshes the user, if signed in.

<b>Signature:</b>

```typescript
reload(): Promise<void>;
```
<b>Returns:</b>

Promise&lt;void&gt;

## User.toJSON()

Returns a JSON-serializable representation of this object.

<b>Signature:</b>

```typescript
toJSON(): object;
```
<b>Returns:</b>

object

A JSON-serializable representation of this object.

