Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# UserCredential interface
A structure containing a [User](./auth.user.md#user_interface)<!-- -->, the [OperationType](./auth.md#operationtype)<!-- -->, and the provider ID.

`operationType` could be [OperationType](./auth.md#operationtype)<!-- -->.SIGN\_IN for a sign-in operation, [OperationType](./auth.md#operationtype)<!-- -->.LINK for a linking operation and [OperationType](./auth.md#operationtype)<!-- -->.REAUTHENTICATE for a reauthentication operation.

<b>Signature:</b>

```typescript
export interface UserCredential 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [operationType](./auth.usercredential.md#usercredentialoperationtype) | (typeof [OperationTypeMap](./auth.md#operationtype)<!-- -->)\[keyof typeof [OperationTypeMap](./auth.md#operationtype)<!-- -->\] | The type of operation which was used to authenticate the user (such as sign-in or link). |
|  [providerId](./auth.usercredential.md#usercredentialproviderid) | string \| null | The provider which was used to authenticate the user. |
|  [user](./auth.usercredential.md#usercredentialuser) | [User](./auth.user.md#user_interface) | The user authenticated by this credential. |

## UserCredential.operationType

The type of operation which was used to authenticate the user (such as sign-in or link).

<b>Signature:</b>

```typescript
operationType: (typeof OperationTypeMap)[keyof typeof OperationTypeMap];
```

## UserCredential.providerId

The provider which was used to authenticate the user.

<b>Signature:</b>

```typescript
providerId: string | null;
```

## UserCredential.user

The user authenticated by this credential.

<b>Signature:</b>

```typescript
user: User;
```
