Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# DatabaseReference interface
A `DatabaseReference` represents a specific location in your Database and can be used for reading or writing data to that Database location.

You can reference the root or child location in your Database by calling `ref()` or `ref("child/path")`<!-- -->.

Writing is done with the `set()` method and reading can be done with the `on*()` method. See [https://firebase.google.com/docs/database/web/read-and-write](https://firebase.google.com/docs/database/web/read-and-write)

<b>Signature:</b>

```typescript
export declare interface DatabaseReference extends Query 
```
<b>Extends:</b> [Query](./database.query.md#query_interface)

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [key](./database.databasereference.md#databasereferencekey) | string \| null | The last part of the <code>DatabaseReference</code>'s path.<!-- -->For example, <code>&quot;ada&quot;</code> is the key for <code>https://&lt;DATABASE_NAME&gt;.firebaseio.com/users/ada</code>.<!-- -->The key of a root <code>DatabaseReference</code> is <code>null</code>. |
|  [parent](./database.databasereference.md#databasereferenceparent) | [DatabaseReference](./database.databasereference.md#databasereference_interface) \| null | The parent location of a <code>DatabaseReference</code>.<!-- -->The parent of a root <code>DatabaseReference</code> is <code>null</code>. |
|  [root](./database.databasereference.md#databasereferenceroot) | [DatabaseReference](./database.databasereference.md#databasereference_interface) | The root <code>DatabaseReference</code> of the Database. |

## DatabaseReference.key

The last part of the `DatabaseReference`<!-- -->'s path.

For example, `"ada"` is the key for `https://<DATABASE_NAME>.firebaseio.com/users/ada`<!-- -->.

The key of a root `DatabaseReference` is `null`<!-- -->.

<b>Signature:</b>

```typescript
readonly key: string | null;
```

## DatabaseReference.parent

The parent location of a `DatabaseReference`<!-- -->.

The parent of a root `DatabaseReference` is `null`<!-- -->.

<b>Signature:</b>

```typescript
readonly parent: DatabaseReference | null;
```

## DatabaseReference.root

The root `DatabaseReference` of the Database.

<b>Signature:</b>

```typescript
readonly root: DatabaseReference;
```
