Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# DataSnapshot class
A `DataSnapshot` contains data from a Database location.

Any time you read data from the Database, you receive the data as a `DataSnapshot`<!-- -->. A `DataSnapshot` is passed to the event callbacks you attach with `on()` or `once()`<!-- -->. You can extract the contents of the snapshot as a JavaScript object by calling the `val()` method. Alternatively, you can traverse into the snapshot by calling `child()` to return child snapshots (which you could then call `val()` on).

A `DataSnapshot` is an efficiently generated, immutable copy of the data at a Database location. It cannot be modified and will never change (to modify data, you always call the `set()` method on a `Reference` directly).

<b>Signature:</b>

```typescript
export declare class DataSnapshot 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [key](./database.datasnapshot.md#datasnapshotkey) |  | string \| null | The key (last part of the path) of the location of this <code>DataSnapshot</code>.<!-- -->The last token in a Database location is considered its key. For example, "ada" is the key for the /users/ada/ node. Accessing the key on any <code>DataSnapshot</code> will return the key for the location that generated it. However, accessing the key on the root URL of a Database will return <code>null</code>. |
|  [priority](./database.datasnapshot.md#datasnapshotpriority) |  | string \| number \| null | Gets the priority value of the data in this <code>DataSnapshot</code>.<!-- -->Applications need not use priority but can order collections by ordinary properties (see [Sorting and filtering data](https://firebase.google.com/docs/database/web/lists-of-data#sorting_and_filtering_data) ). |
|  [ref](./database.datasnapshot.md#datasnapshotref) |  | [DatabaseReference](./database.databasereference.md#databasereference_interface) | The location of this DataSnapshot. |
|  [size](./database.datasnapshot.md#datasnapshotsize) |  | number | Returns the number of child properties of this <code>DataSnapshot</code>. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [child(path)](./database.datasnapshot.md#datasnapshotchild) |  | Gets another <code>DataSnapshot</code> for the location at the specified relative path.<!-- -->Passing a relative path to the <code>child()</code> method of a DataSnapshot returns another <code>DataSnapshot</code> for the location at the specified relative path. The relative path can either be a simple child name (for example, "ada") or a deeper, slash-separated path (for example, "ada/name/first"). If the child location has no data, an empty <code>DataSnapshot</code> (that is, a <code>DataSnapshot</code> whose value is <code>null</code>) is returned. |
|  [exists()](./database.datasnapshot.md#datasnapshotexists) |  | Returns true if this <code>DataSnapshot</code> contains any data. It is slightly more efficient than using <code>snapshot.val() !== null</code>. |
|  [exportVal()](./database.datasnapshot.md#datasnapshotexportval) |  | Exports the entire contents of the DataSnapshot as a JavaScript object.<!-- -->The <code>exportVal()</code> method is similar to <code>val()</code>, except priority information is included (if available), making it suitable for backing up your data. |
|  [forEach(action)](./database.datasnapshot.md#datasnapshotforeach) |  | Enumerates the top-level children in the <code>IteratedDataSnapshot</code>.<!-- -->Because of the way JavaScript objects work, the ordering of data in the JavaScript object returned by <code>val()</code> is not guaranteed to match the ordering on the server nor the ordering of <code>onChildAdded()</code> events. That is where <code>forEach()</code> comes in handy. It guarantees the children of a <code>DataSnapshot</code> will be iterated in their query order.<!-- -->If no explicit <code>orderBy*()</code> method is used, results are returned ordered by key (unless priorities are used, in which case, results are returned by priority). |
|  [hasChild(path)](./database.datasnapshot.md#datasnapshothaschild) |  | Returns true if the specified child path has (non-null) data. |
|  [hasChildren()](./database.datasnapshot.md#datasnapshothaschildren) |  | Returns whether or not the <code>DataSnapshot</code> has any non-<code>null</code> child properties.<!-- -->You can use <code>hasChildren()</code> to determine if a <code>DataSnapshot</code> has any children. If it does, you can enumerate them using <code>forEach()</code>. If it doesn't, then either this snapshot contains a primitive value (which can be retrieved with <code>val()</code>) or it is empty (in which case, <code>val()</code> will return <code>null</code>). |
|  [toJSON()](./database.datasnapshot.md#datasnapshottojson) |  | Returns a JSON-serializable representation of this object. |
|  [val()](./database.datasnapshot.md#datasnapshotval) |  | Extracts a JavaScript value from a <code>DataSnapshot</code>.<!-- -->Depending on the data in a <code>DataSnapshot</code>, the <code>val()</code> method may return a scalar type (string, number, or boolean), an array, or an object. It may also return null, indicating that the <code>DataSnapshot</code> is empty (contains no data). |

## DataSnapshot.key

The key (last part of the path) of the location of this `DataSnapshot`<!-- -->.

The last token in a Database location is considered its key. For example, "ada" is the key for the /users/ada/ node. Accessing the key on any `DataSnapshot` will return the key for the location that generated it. However, accessing the key on the root URL of a Database will return `null`<!-- -->.

<b>Signature:</b>

```typescript
get key(): string | null;
```

## DataSnapshot.priority

Gets the priority value of the data in this `DataSnapshot`<!-- -->.

Applications need not use priority but can order collections by ordinary properties (see [Sorting and filtering data](https://firebase.google.com/docs/database/web/lists-of-data#sorting_and_filtering_data) ).

<b>Signature:</b>

```typescript
get priority(): string | number | null;
```

## DataSnapshot.ref

The location of this DataSnapshot.

<b>Signature:</b>

```typescript
readonly ref: DatabaseReference;
```

## DataSnapshot.size

Returns the number of child properties of this `DataSnapshot`<!-- -->.

<b>Signature:</b>

```typescript
get size(): number;
```

## DataSnapshot.child()

Gets another `DataSnapshot` for the location at the specified relative path.

Passing a relative path to the `child()` method of a DataSnapshot returns another `DataSnapshot` for the location at the specified relative path. The relative path can either be a simple child name (for example, "ada") or a deeper, slash-separated path (for example, "ada/name/first"). If the child location has no data, an empty `DataSnapshot` (that is, a `DataSnapshot` whose value is `null`<!-- -->) is returned.

<b>Signature:</b>

```typescript
child(path: string): DataSnapshot;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  path | string | A relative path to the location of child data. |

<b>Returns:</b>

[DataSnapshot](./database.datasnapshot.md#datasnapshot_class)

## DataSnapshot.exists()

Returns true if this `DataSnapshot` contains any data. It is slightly more efficient than using `snapshot.val() !== null`<!-- -->.

<b>Signature:</b>

```typescript
exists(): boolean;
```
<b>Returns:</b>

boolean

## DataSnapshot.exportVal()

Exports the entire contents of the DataSnapshot as a JavaScript object.

The `exportVal()` method is similar to `val()`<!-- -->, except priority information is included (if available), making it suitable for backing up your data.

<b>Signature:</b>

```typescript
exportVal(): any;
```
<b>Returns:</b>

any

The DataSnapshot's contents as a JavaScript value (Object, Array, string, number, boolean, or `null`<!-- -->).

## DataSnapshot.forEach()

Enumerates the top-level children in the `IteratedDataSnapshot`<!-- -->.

Because of the way JavaScript objects work, the ordering of data in the JavaScript object returned by `val()` is not guaranteed to match the ordering on the server nor the ordering of `onChildAdded()` events. That is where `forEach()` comes in handy. It guarantees the children of a `DataSnapshot` will be iterated in their query order.

If no explicit `orderBy*()` method is used, results are returned ordered by key (unless priorities are used, in which case, results are returned by priority).

<b>Signature:</b>

```typescript
forEach(action: (child: IteratedDataSnapshot) => boolean | void): boolean;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  action | (child: [IteratedDataSnapshot](./database.iterateddatasnapshot.md#iterateddatasnapshot_interface)<!-- -->) =&gt; boolean \| void | A function that will be called for each child DataSnapshot. The callback can return true to cancel further enumeration. |

<b>Returns:</b>

boolean

true if enumeration was canceled due to your callback returning true.

## DataSnapshot.hasChild()

Returns true if the specified child path has (non-null) data.

<b>Signature:</b>

```typescript
hasChild(path: string): boolean;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  path | string | A relative path to the location of a potential child. |

<b>Returns:</b>

boolean

`true` if data exists at the specified child path; else `false`<!-- -->.

## DataSnapshot.hasChildren()

Returns whether or not the `DataSnapshot` has any non-`null` child properties.

You can use `hasChildren()` to determine if a `DataSnapshot` has any children. If it does, you can enumerate them using `forEach()`<!-- -->. If it doesn't, then either this snapshot contains a primitive value (which can be retrieved with `val()`<!-- -->) or it is empty (in which case, `val()` will return `null`<!-- -->).

<b>Signature:</b>

```typescript
hasChildren(): boolean;
```
<b>Returns:</b>

boolean

true if this snapshot has any children; else false.

## DataSnapshot.toJSON()

Returns a JSON-serializable representation of this object.

<b>Signature:</b>

```typescript
toJSON(): object | null;
```
<b>Returns:</b>

object \| null

## DataSnapshot.val()

Extracts a JavaScript value from a `DataSnapshot`<!-- -->.

Depending on the data in a `DataSnapshot`<!-- -->, the `val()` method may return a scalar type (string, number, or boolean), an array, or an object. It may also return null, indicating that the `DataSnapshot` is empty (contains no data).

<b>Signature:</b>

```typescript
val(): any;
```
<b>Returns:</b>

any

The DataSnapshot's contents as a JavaScript value (Object, Array, string, number, boolean, or `null`<!-- -->).

