Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# Bytes class
An immutable object representing an array of bytes.

<b>Signature:</b>

```typescript
export declare class Bytes 
```

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [fromBase64String(base64)](./firestore_.bytes.md#bytesfrombase64string) | <code>static</code> | Creates a new <code>Bytes</code> object from the given Base64 string, converting it to bytes. |
|  [fromJSON(json)](./firestore_.bytes.md#bytesfromjson) | <code>static</code> | Builds a <code>Bytes</code> instance from a JSON object created by [Bytes.toJSON()](./firestore_.bytes.md#bytestojson)<!-- -->. |
|  [fromUint8Array(array)](./firestore_.bytes.md#bytesfromuint8array) | <code>static</code> | Creates a new <code>Bytes</code> object from the given Uint8Array. |
|  [isEqual(other)](./firestore_.bytes.md#bytesisequal) |  | Returns true if this <code>Bytes</code> object is equal to the provided one. |
|  [toBase64()](./firestore_.bytes.md#bytestobase64) |  | Returns the underlying bytes as a Base64-encoded string. |
|  [toJSON()](./firestore_.bytes.md#bytestojson) |  | Returns a JSON-serializable representation of this <code>Bytes</code> instance. |
|  [toString()](./firestore_.bytes.md#bytestostring) |  | Returns a string representation of the <code>Bytes</code> object. |
|  [toUint8Array()](./firestore_.bytes.md#bytestouint8array) |  | Returns the underlying bytes in a new <code>Uint8Array</code>. |

## Bytes.fromBase64String()

Creates a new `Bytes` object from the given Base64 string, converting it to bytes.

<b>Signature:</b>

```typescript
static fromBase64String(base64: string): Bytes;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  base64 | string | The Base64 string used to create the <code>Bytes</code> object. |

<b>Returns:</b>

[Bytes](./firestore_.bytes.md#bytes_class)

## Bytes.fromJSON()

Builds a `Bytes` instance from a JSON object created by [Bytes.toJSON()](./firestore_.bytes.md#bytestojson)<!-- -->.

<b>Signature:</b>

```typescript
static fromJSON(json: object): Bytes;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  json | object | a JSON object represention of a <code>Bytes</code> instance |

<b>Returns:</b>

[Bytes](./firestore_.bytes.md#bytes_class)

an instance of [Bytes](./firestore_.bytes.md#bytes_class) if the JSON object could be parsed. Throws a [FirestoreError](./firestore_.firestoreerror.md#firestoreerror_class) if an error occurs.

## Bytes.fromUint8Array()

Creates a new `Bytes` object from the given Uint8Array.

<b>Signature:</b>

```typescript
static fromUint8Array(array: Uint8Array): Bytes;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  array | Uint8Array | The Uint8Array used to create the <code>Bytes</code> object. |

<b>Returns:</b>

[Bytes](./firestore_.bytes.md#bytes_class)

## Bytes.isEqual()

Returns true if this `Bytes` object is equal to the provided one.

<b>Signature:</b>

```typescript
isEqual(other: Bytes): boolean;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  other | [Bytes](./firestore_.bytes.md#bytes_class) | The <code>Bytes</code> object to compare against. |

<b>Returns:</b>

boolean

true if this `Bytes` object is equal to the provided one.

## Bytes.toBase64()

Returns the underlying bytes as a Base64-encoded string.

<b>Signature:</b>

```typescript
toBase64(): string;
```
<b>Returns:</b>

string

The Base64-encoded string created from the `Bytes` object.

## Bytes.toJSON()

Returns a JSON-serializable representation of this `Bytes` instance.

<b>Signature:</b>

```typescript
toJSON(): object;
```
<b>Returns:</b>

object

a JSON representation of this object.

## Bytes.toString()

Returns a string representation of the `Bytes` object.

<b>Signature:</b>

```typescript
toString(): string;
```
<b>Returns:</b>

string

A string representation of the `Bytes` object.

## Bytes.toUint8Array()

Returns the underlying bytes in a new `Uint8Array`<!-- -->.

<b>Signature:</b>

```typescript
toUint8Array(): Uint8Array;
```
<b>Returns:</b>

Uint8Array

The Uint8Array created from the `Bytes` object.

