Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# CollectionReference class
A `CollectionReference` object can be used for adding documents, getting document references, and querying for documents (using [query()](./firestore_.md#query_9f7b0f4)<!-- -->).

<b>Signature:</b>

```typescript
export declare class CollectionReference<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> extends Query<AppModelType, DbModelType> 
```
<b>Extends:</b> [Query](./firestore_.query.md#query_class)<!-- -->&lt;AppModelType, DbModelType&gt;

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [id](./firestore_.collectionreference.md#collectionreferenceid) |  | string | The collection's identifier. |
|  [parent](./firestore_.collectionreference.md#collectionreferenceparent) |  | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;[DocumentData](./firestore_.documentdata.md#documentdata_interface)<!-- -->, [DocumentData](./firestore_.documentdata.md#documentdata_interface)<!-- -->&gt; \| null | A reference to the containing <code>DocumentReference</code> if this is a subcollection. If this isn't a subcollection, the reference is null. |
|  [path](./firestore_.collectionreference.md#collectionreferencepath) |  | string | A string representing the path of the referenced collection (relative to the root of the database). |
|  [type](./firestore_.collectionreference.md#collectionreferencetype) |  | (not declared) | The type of this Firestore reference. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [withConverter(converter)](./firestore_.collectionreference.md#collectionreferencewithconverter) |  | Applies a custom data converter to this <code>CollectionReference</code>, allowing you to use your own custom model objects with Firestore. When you call [addDoc()](./firestore_.md#adddoc_6e783ff) with the returned <code>CollectionReference</code> instance, the provided converter will convert between Firestore data of type <code>NewDbModelType</code> and your custom type <code>NewAppModelType</code>. |
|  [withConverter(converter)](./firestore_.collectionreference.md#collectionreferencewithconverter) |  | Removes the current converter. |

## CollectionReference.id

The collection's identifier.

<b>Signature:</b>

```typescript
get id(): string;
```

## CollectionReference.parent

A reference to the containing `DocumentReference` if this is a subcollection. If this isn't a subcollection, the reference is null.

<b>Signature:</b>

```typescript
get parent(): DocumentReference<DocumentData, DocumentData> | null;
```

## CollectionReference.path

A string representing the path of the referenced collection (relative to the root of the database).

<b>Signature:</b>

```typescript
get path(): string;
```

## CollectionReference.type

The type of this Firestore reference.

<b>Signature:</b>

```typescript
readonly type = "collection";
```

## CollectionReference.withConverter()

Applies a custom data converter to this `CollectionReference`<!-- -->, allowing you to use your own custom model objects with Firestore. When you call [addDoc()](./firestore_.md#adddoc_6e783ff) with the returned `CollectionReference` instance, the provided converter will convert between Firestore data of type `NewDbModelType` and your custom type `NewAppModelType`<!-- -->.

<b>Signature:</b>

```typescript
withConverter<NewAppModelType, NewDbModelType extends DocumentData = DocumentData>(converter: FirestoreDataConverter<NewAppModelType, NewDbModelType>): CollectionReference<NewAppModelType, NewDbModelType>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  converter | [FirestoreDataConverter](./firestore_.firestoredataconverter.md#firestoredataconverter_interface)<!-- -->&lt;NewAppModelType, NewDbModelType&gt; | Converts objects to and from Firestore. |

<b>Returns:</b>

[CollectionReference](./firestore_.collectionreference.md#collectionreference_class)<!-- -->&lt;NewAppModelType, NewDbModelType&gt;

A `CollectionReference` that uses the provided converter.

## CollectionReference.withConverter()

Removes the current converter.

<b>Signature:</b>

```typescript
withConverter(converter: null): CollectionReference<DocumentData, DocumentData>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  converter | null | <code>null</code> removes the current converter. |

<b>Returns:</b>

[CollectionReference](./firestore_.collectionreference.md#collectionreference_class)<!-- -->&lt;[DocumentData](./firestore_.documentdata.md#documentdata_interface)<!-- -->, [DocumentData](./firestore_.documentdata.md#documentdata_interface)<!-- -->&gt;

A `CollectionReference<DocumentData, DocumentData>` that does not use a converter.

