Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# DocumentChange interface
A `DocumentChange` represents a change to the documents matching a query. It contains the document affected and the type of change that occurred.

<b>Signature:</b>

```typescript
export declare interface DocumentChange<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [doc](./firestore_.documentchange.md#documentchangedoc) | [QueryDocumentSnapshot](./firestore_.querydocumentsnapshot.md#querydocumentsnapshot_class)<!-- -->&lt;AppModelType, DbModelType&gt; | The document affected by this change. |
|  [newIndex](./firestore_.documentchange.md#documentchangenewindex) | number | The index of the changed document in the result set immediately after this <code>DocumentChange</code> (i.e. supposing that all prior <code>DocumentChange</code> objects and the current <code>DocumentChange</code> object have been applied). Is -1 for 'removed' events. |
|  [oldIndex](./firestore_.documentchange.md#documentchangeoldindex) | number | The index of the changed document in the result set immediately prior to this <code>DocumentChange</code> (i.e. supposing that all prior <code>DocumentChange</code> objects have been applied). Is <code>-1</code> for 'added' events. |
|  [type](./firestore_.documentchange.md#documentchangetype) | [DocumentChangeType](./firestore_.md#documentchangetype) | The type of change ('added', 'modified', or 'removed'). |

## DocumentChange.doc

The document affected by this change.

<b>Signature:</b>

```typescript
readonly doc: QueryDocumentSnapshot<AppModelType, DbModelType>;
```

## DocumentChange.newIndex

The index of the changed document in the result set immediately after this `DocumentChange` (i.e. supposing that all prior `DocumentChange` objects and the current `DocumentChange` object have been applied). Is -1 for 'removed' events.

<b>Signature:</b>

```typescript
readonly newIndex: number;
```

## DocumentChange.oldIndex

The index of the changed document in the result set immediately prior to this `DocumentChange` (i.e. supposing that all prior `DocumentChange` objects have been applied). Is `-1` for 'added' events.

<b>Signature:</b>

```typescript
readonly oldIndex: number;
```

## DocumentChange.type

The type of change ('added', 'modified', or 'removed').

<b>Signature:</b>

```typescript
readonly type: DocumentChangeType;
```
