Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# DocumentReference class
A `DocumentReference` refers to a document location in a Firestore database and can be used to write, read, or listen to the location. The document at the referenced location may or may not exist.

<b>Signature:</b>

```typescript
export declare class DocumentReference<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [converter](./firestore_.documentreference.md#documentreferenceconverter) |  | [FirestoreDataConverter](./firestore_.firestoredataconverter.md#firestoredataconverter_interface)<!-- -->&lt;AppModelType, DbModelType&gt; \| null | If provided, the <code>FirestoreDataConverter</code> associated with this instance. |
|  [firestore](./firestore_.documentreference.md#documentreferencefirestore) |  | [Firestore](./firestore_.firestore.md#firestore_class) | The [Firestore](./firestore_.firestore.md#firestore_class) instance the document is in. This is useful for performing transactions, for example. |
|  [id](./firestore_.documentreference.md#documentreferenceid) |  | string | The document's identifier within its collection. |
|  [parent](./firestore_.documentreference.md#documentreferenceparent) |  | [CollectionReference](./firestore_.collectionreference.md#collectionreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | The collection this <code>DocumentReference</code> belongs to. |
|  [path](./firestore_.documentreference.md#documentreferencepath) |  | string | A string representing the path of the referenced document (relative to the root of the database). |
|  [type](./firestore_.documentreference.md#documentreferencetype) |  | (not declared) | The type of this Firestore reference. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [fromJSON(firestore, json)](./firestore_.documentreference.md#documentreferencefromjson) | <code>static</code> | Builds a <code>DocumentReference</code> instance from a JSON object created by [DocumentReference.toJSON()](./firestore_.documentreference.md#documentreferencetojson)<!-- -->. |
|  [fromJSON(firestore, json, converter)](./firestore_.documentreference.md#documentreferencefromjson) | <code>static</code> | Builds a <code>DocumentReference</code> instance from a JSON object created by [DocumentReference.toJSON()](./firestore_.documentreference.md#documentreferencetojson)<!-- -->. |
|  [toJSON()](./firestore_.documentreference.md#documentreferencetojson) |  | Returns a JSON-serializable representation of this <code>DocumentReference</code> instance. |
|  [withConverter(converter)](./firestore_.documentreference.md#documentreferencewithconverter) |  | Applies a custom data converter to this <code>DocumentReference</code>, allowing you to use your own custom model objects with Firestore. When you call [setDoc()](./firestore_lite.md#setdoc_ee215ad)<!-- -->, [getDoc()](./firestore_lite.md#getdoc_4569087)<!-- -->, etc. with the returned <code>DocumentReference</code> instance, the provided converter will convert between Firestore data of type <code>NewDbModelType</code> and your custom type <code>NewAppModelType</code>. |
|  [withConverter(converter)](./firestore_.documentreference.md#documentreferencewithconverter) |  | Removes the current converter. |

## DocumentReference.converter

If provided, the `FirestoreDataConverter` associated with this instance.

<b>Signature:</b>

```typescript
readonly converter: FirestoreDataConverter<AppModelType, DbModelType> | null;
```

## DocumentReference.firestore

The [Firestore](./firestore_.firestore.md#firestore_class) instance the document is in. This is useful for performing transactions, for example.

<b>Signature:</b>

```typescript
readonly firestore: Firestore;
```

## DocumentReference.id

The document's identifier within its collection.

<b>Signature:</b>

```typescript
get id(): string;
```

## DocumentReference.parent

The collection this `DocumentReference` belongs to.

<b>Signature:</b>

```typescript
get parent(): CollectionReference<AppModelType, DbModelType>;
```

## DocumentReference.path

A string representing the path of the referenced document (relative to the root of the database).

<b>Signature:</b>

```typescript
get path(): string;
```

## DocumentReference.type

The type of this Firestore reference.

<b>Signature:</b>

```typescript
readonly type = "document";
```

## DocumentReference.fromJSON()

Builds a `DocumentReference` instance from a JSON object created by [DocumentReference.toJSON()](./firestore_.documentreference.md#documentreferencetojson)<!-- -->.

<b>Signature:</b>

```typescript
static fromJSON(firestore: Firestore, json: object): DocumentReference;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  firestore | [Firestore](./firestore_.firestore.md#firestore_class) | The [Firestore](./firestore_.firestore.md#firestore_class) instance the snapshot should be loaded for. |
|  json | object | a JSON object represention of a <code>DocumentReference</code> instance |

<b>Returns:</b>

[DocumentReference](./firestore_.documentreference.md#documentreference_class)

an instance of [DocumentReference](./firestore_.documentreference.md#documentreference_class) if the JSON object could be parsed. Throws a [FirestoreError](./firestore_.firestoreerror.md#firestoreerror_class) if an error occurs.

## DocumentReference.fromJSON()

Builds a `DocumentReference` instance from a JSON object created by [DocumentReference.toJSON()](./firestore_.documentreference.md#documentreferencetojson)<!-- -->.

<b>Signature:</b>

```typescript
static fromJSON<NewAppModelType = DocumentData, NewDbModelType extends DocumentData = DocumentData>(firestore: Firestore, json: object, converter: FirestoreDataConverter<NewAppModelType, NewDbModelType>): DocumentReference<NewAppModelType, NewDbModelType>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  firestore | [Firestore](./firestore_.firestore.md#firestore_class) | The [Firestore](./firestore_.firestore.md#firestore_class) instance the snapshot should be loaded for. |
|  json | object | a JSON object represention of a <code>DocumentReference</code> instance |
|  converter | [FirestoreDataConverter](./firestore_.firestoredataconverter.md#firestoredataconverter_interface)<!-- -->&lt;NewAppModelType, NewDbModelType&gt; | Converts objects to and from Firestore. |

<b>Returns:</b>

[DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;NewAppModelType, NewDbModelType&gt;

an instance of [DocumentReference](./firestore_.documentreference.md#documentreference_class) if the JSON object could be parsed. Throws a [FirestoreError](./firestore_.firestoreerror.md#firestoreerror_class) if an error occurs.

## DocumentReference.toJSON()

Returns a JSON-serializable representation of this `DocumentReference` instance.

<b>Signature:</b>

```typescript
toJSON(): object;
```
<b>Returns:</b>

object

a JSON representation of this object.

## DocumentReference.withConverter()

Applies a custom data converter to this `DocumentReference`<!-- -->, allowing you to use your own custom model objects with Firestore. When you call [setDoc()](./firestore_lite.md#setdoc_ee215ad)<!-- -->, [getDoc()](./firestore_lite.md#getdoc_4569087)<!-- -->, etc. with the returned `DocumentReference` instance, the provided converter will convert between Firestore data of type `NewDbModelType` and your custom type `NewAppModelType`<!-- -->.

<b>Signature:</b>

```typescript
withConverter<NewAppModelType, NewDbModelType extends DocumentData = DocumentData>(converter: FirestoreDataConverter<NewAppModelType, NewDbModelType>): DocumentReference<NewAppModelType, NewDbModelType>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  converter | [FirestoreDataConverter](./firestore_.firestoredataconverter.md#firestoredataconverter_interface)<!-- -->&lt;NewAppModelType, NewDbModelType&gt; | Converts objects to and from Firestore. |

<b>Returns:</b>

[DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;NewAppModelType, NewDbModelType&gt;

A `DocumentReference` that uses the provided converter.

## DocumentReference.withConverter()

Removes the current converter.

<b>Signature:</b>

```typescript
withConverter(converter: null): DocumentReference<DocumentData, DocumentData>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  converter | null | <code>null</code> removes the current converter. |

<b>Returns:</b>

[DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;[DocumentData](./firestore_.documentdata.md#documentdata_interface)<!-- -->, [DocumentData](./firestore_.documentdata.md#documentdata_interface)<!-- -->&gt;

A `DocumentReference<DocumentData, DocumentData>` that does not use a converter.

