Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# DocumentSnapshot class
A `DocumentSnapshot` contains data read from a document in your Firestore database. The data can be extracted with `.data()` or `.get(<field>)` to get a specific field.

For a `DocumentSnapshot` that points to a non-existing document, any data access will return 'undefined'. You can use the `exists()` method to explicitly verify a document's existence.

<b>Signature:</b>

```typescript
export declare class DocumentSnapshot<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)()](./firestore_.documentsnapshot.md#documentsnapshotconstructor) |  | Constructs a new instance of the <code>DocumentSnapshot</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [id](./firestore_.documentsnapshot.md#documentsnapshotid) |  | string | Property of the <code>DocumentSnapshot</code> that provides the document's ID. |
|  [metadata](./firestore_.documentsnapshot.md#documentsnapshotmetadata) |  | [SnapshotMetadata](./firestore_.snapshotmetadata.md#snapshotmetadata_class) | Metadata about the <code>DocumentSnapshot</code>, including information about its source and local modifications. |
|  [ref](./firestore_.documentsnapshot.md#documentsnapshotref) |  | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | The <code>DocumentReference</code> for the document included in the <code>DocumentSnapshot</code>. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [data(options)](./firestore_.documentsnapshot.md#documentsnapshotdata) |  | Retrieves all fields in the document as an <code>Object</code>. Returns <code>undefined</code> if the document doesn't exist.<!-- -->By default, <code>serverTimestamp()</code> values that have not yet been set to their final value will be returned as <code>null</code>. You can override this by passing an options object. |
|  [exists()](./firestore_.documentsnapshot.md#documentsnapshotexists) |  | Returns whether or not the data exists. True if the document exists. |
|  [get(fieldPath, options)](./firestore_.documentsnapshot.md#documentsnapshotget) |  | Retrieves the field specified by <code>fieldPath</code>. Returns <code>undefined</code> if the document or field doesn't exist.<!-- -->By default, a <code>serverTimestamp()</code> that has not yet been set to its final value will be returned as <code>null</code>. You can override this by passing an options object. |
|  [toJSON()](./firestore_.documentsnapshot.md#documentsnapshottojson) |  | Returns a JSON-serializable representation of this <code>DocumentSnapshot</code> instance. |

## DocumentSnapshot.(constructor)

Constructs a new instance of the `DocumentSnapshot` class

<b>Signature:</b>

```typescript
protected constructor();
```

## DocumentSnapshot.id

Property of the `DocumentSnapshot` that provides the document's ID.

<b>Signature:</b>

```typescript
get id(): string;
```

## DocumentSnapshot.metadata

Metadata about the `DocumentSnapshot`<!-- -->, including information about its source and local modifications.

<b>Signature:</b>

```typescript
readonly metadata: SnapshotMetadata;
```

## DocumentSnapshot.ref

The `DocumentReference` for the document included in the `DocumentSnapshot`<!-- -->.

<b>Signature:</b>

```typescript
get ref(): DocumentReference<AppModelType, DbModelType>;
```

## DocumentSnapshot.data()

Retrieves all fields in the document as an `Object`<!-- -->. Returns `undefined` if the document doesn't exist.

By default, `serverTimestamp()` values that have not yet been set to their final value will be returned as `null`<!-- -->. You can override this by passing an options object.

<b>Signature:</b>

```typescript
data(options?: SnapshotOptions): AppModelType | undefined;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | [SnapshotOptions](./firestore_.snapshotoptions.md#snapshotoptions_interface) | An options object to configure how data is retrieved from the snapshot (for example the desired behavior for server timestamps that have not yet been set to their final value). |

<b>Returns:</b>

AppModelType \| undefined

An `Object` containing all fields in the document or `undefined` if the document doesn't exist.

## DocumentSnapshot.exists()

Returns whether or not the data exists. True if the document exists.

<b>Signature:</b>

```typescript
exists(): this is QueryDocumentSnapshot<AppModelType, DbModelType>;
```
<b>Returns:</b>

this is [QueryDocumentSnapshot](./firestore_.querydocumentsnapshot.md#querydocumentsnapshot_class)<!-- -->&lt;AppModelType, DbModelType&gt;

## DocumentSnapshot.get()

Retrieves the field specified by `fieldPath`<!-- -->. Returns `undefined` if the document or field doesn't exist.

By default, a `serverTimestamp()` that has not yet been set to its final value will be returned as `null`<!-- -->. You can override this by passing an options object.

<b>Signature:</b>

```typescript
get(fieldPath: string | FieldPath, options?: SnapshotOptions): any;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  fieldPath | string \| [FieldPath](./firestore_.fieldpath.md#fieldpath_class) | The path (for example 'foo' or 'foo.bar') to a specific field. |
|  options | [SnapshotOptions](./firestore_.snapshotoptions.md#snapshotoptions_interface) | An options object to configure how the field is retrieved from the snapshot (for example the desired behavior for server timestamps that have not yet been set to their final value). |

<b>Returns:</b>

any

The data at the specified field location or undefined if no such field exists in the document.

## DocumentSnapshot.toJSON()

Returns a JSON-serializable representation of this `DocumentSnapshot` instance.

<b>Signature:</b>

```typescript
toJSON(): object;
```
<b>Returns:</b>

object

a JSON representation of this object. Throws a [FirestoreError](./firestore_.firestoreerror.md#firestoreerror_class) if this `DocumentSnapshot` has pending writes.

