Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# GeoPoint class
An immutable object representing a geographic location in Firestore. The location is represented as latitude/longitude pair.

Latitude values are in the range of \[-90, 90\]. Longitude values are in the range of \[-180, 180\].

<b>Signature:</b>

```typescript
export declare class GeoPoint 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(latitude, longitude)](./firestore_.geopoint.md#geopointconstructor) |  | Creates a new immutable <code>GeoPoint</code> object with the provided latitude and longitude values. |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [latitude](./firestore_.geopoint.md#geopointlatitude) |  | number | The latitude of this <code>GeoPoint</code> instance. |
|  [longitude](./firestore_.geopoint.md#geopointlongitude) |  | number | The longitude of this <code>GeoPoint</code> instance. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [fromJSON(json)](./firestore_.geopoint.md#geopointfromjson) | <code>static</code> | Builds a <code>GeoPoint</code> instance from a JSON object created by [GeoPoint.toJSON()](./firestore_.geopoint.md#geopointtojson)<!-- -->. |
|  [isEqual(other)](./firestore_.geopoint.md#geopointisequal) |  | Returns true if this <code>GeoPoint</code> is equal to the provided one. |
|  [toJSON()](./firestore_.geopoint.md#geopointtojson) |  | Returns a JSON-serializable representation of this <code>GeoPoint</code> instance. |

## GeoPoint.(constructor)

Creates a new immutable `GeoPoint` object with the provided latitude and longitude values.

<b>Signature:</b>

```typescript
constructor(latitude: number, longitude: number);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  latitude | number | The latitude as number between -90 and 90. |
|  longitude | number | The longitude as number between -180 and 180. |

## GeoPoint.latitude

The latitude of this `GeoPoint` instance.

<b>Signature:</b>

```typescript
get latitude(): number;
```

## GeoPoint.longitude

The longitude of this `GeoPoint` instance.

<b>Signature:</b>

```typescript
get longitude(): number;
```

## GeoPoint.fromJSON()

Builds a `GeoPoint` instance from a JSON object created by [GeoPoint.toJSON()](./firestore_.geopoint.md#geopointtojson)<!-- -->.

<b>Signature:</b>

```typescript
static fromJSON(json: object): GeoPoint;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  json | object | a JSON object represention of a <code>GeoPoint</code> instance |

<b>Returns:</b>

[GeoPoint](./firestore_.geopoint.md#geopoint_class)

an instance of [GeoPoint](./firestore_.geopoint.md#geopoint_class) if the JSON object could be parsed. Throws a [FirestoreError](./firestore_.firestoreerror.md#firestoreerror_class) if an error occurs.

## GeoPoint.isEqual()

Returns true if this `GeoPoint` is equal to the provided one.

<b>Signature:</b>

```typescript
isEqual(other: GeoPoint): boolean;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  other | [GeoPoint](./firestore_.geopoint.md#geopoint_class) | The <code>GeoPoint</code> to compare against. |

<b>Returns:</b>

boolean

true if this `GeoPoint` is equal to the provided one.

## GeoPoint.toJSON()

Returns a JSON-serializable representation of this `GeoPoint` instance.

<b>Signature:</b>

```typescript
toJSON(): {
        latitude: number;
        longitude: number;
        type: string;
    };
```
<b>Returns:</b>

{ latitude: number; longitude: number; type: string; }

a JSON representation of this object.

