Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# PersistentCacheSettings interface
An settings object to configure an `PersistentLocalCache` instance.

Persistent cache cannot be used in a Node.js environment.

<b>Signature:</b>

```typescript
export declare interface PersistentCacheSettings 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [cacheSizeBytes](./firestore_.persistentcachesettings.md#persistentcachesettingscachesizebytes) | number | An approximate cache size threshold for the on-disk data. If the cache grows beyond this size, Firestore will start removing data that hasn't been recently used. The SDK does not guarantee that the cache will stay below that size, only that if the cache exceeds the given size, cleanup will be attempted.<!-- -->The default value is 40 MB. The threshold must be set to at least 1 MB, and can be set to <code>CACHE_SIZE_UNLIMITED</code> to disable garbage collection. |
|  [tabManager](./firestore_.persistentcachesettings.md#persistentcachesettingstabmanager) | [PersistentTabManager](./firestore_.md#persistenttabmanager) | Specifies how multiple tabs/windows will be managed by the SDK. |

## PersistentCacheSettings.cacheSizeBytes

An approximate cache size threshold for the on-disk data. If the cache grows beyond this size, Firestore will start removing data that hasn't been recently used. The SDK does not guarantee that the cache will stay below that size, only that if the cache exceeds the given size, cleanup will be attempted.

The default value is 40 MB. The threshold must be set to at least 1 MB, and can be set to `CACHE_SIZE_UNLIMITED` to disable garbage collection.

<b>Signature:</b>

```typescript
cacheSizeBytes?: number;
```

## PersistentCacheSettings.tabManager

Specifies how multiple tabs/windows will be managed by the SDK.

<b>Signature:</b>

```typescript
tabManager?: PersistentTabManager;
```
