Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# Query class
A `Query` refers to a query which you can read or listen to. You can also construct refined `Query` objects by adding filters and ordering.

<b>Signature:</b>

```typescript
export declare class Query<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)()](./firestore_.query.md#queryconstructor) |  | Constructs a new instance of the <code>Query</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [converter](./firestore_.query.md#queryconverter) |  | [FirestoreDataConverter](./firestore_.firestoredataconverter.md#firestoredataconverter_interface)<!-- -->&lt;AppModelType, DbModelType&gt; \| null | If provided, the <code>FirestoreDataConverter</code> associated with this instance. |
|  [firestore](./firestore_.query.md#queryfirestore) |  | [Firestore](./firestore_.firestore.md#firestore_class) | The <code>Firestore</code> instance for the Firestore database (useful for performing transactions, etc.). |
|  [type](./firestore_.query.md#querytype) |  | 'query' \| 'collection' | The type of this Firestore reference. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [withConverter(converter)](./firestore_.query.md#querywithconverter) |  | Removes the current converter. |
|  [withConverter(converter)](./firestore_.query.md#querywithconverter) |  | Applies a custom data converter to this query, allowing you to use your own custom model objects with Firestore. When you call [getDocs()](./firestore_.md#getdocs_4e56953) with the returned query, the provided converter will convert between Firestore data of type <code>NewDbModelType</code> and your custom type <code>NewAppModelType</code>. |

## Query.(constructor)

Constructs a new instance of the `Query` class

<b>Signature:</b>

```typescript
protected constructor();
```

## Query.converter

If provided, the `FirestoreDataConverter` associated with this instance.

<b>Signature:</b>

```typescript
readonly converter: FirestoreDataConverter<AppModelType, DbModelType> | null;
```

## Query.firestore

The `Firestore` instance for the Firestore database (useful for performing transactions, etc.).

<b>Signature:</b>

```typescript
readonly firestore: Firestore;
```

## Query.type

The type of this Firestore reference.

<b>Signature:</b>

```typescript
readonly type: 'query' | 'collection';
```

## Query.withConverter()

Removes the current converter.

<b>Signature:</b>

```typescript
withConverter(converter: null): Query<DocumentData, DocumentData>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  converter | null | <code>null</code> removes the current converter. |

<b>Returns:</b>

[Query](./firestore_.query.md#query_class)<!-- -->&lt;[DocumentData](./firestore_.documentdata.md#documentdata_interface)<!-- -->, [DocumentData](./firestore_.documentdata.md#documentdata_interface)<!-- -->&gt;

A `Query<DocumentData, DocumentData>` that does not use a converter.

## Query.withConverter()

Applies a custom data converter to this query, allowing you to use your own custom model objects with Firestore. When you call [getDocs()](./firestore_.md#getdocs_4e56953) with the returned query, the provided converter will convert between Firestore data of type `NewDbModelType` and your custom type `NewAppModelType`<!-- -->.

<b>Signature:</b>

```typescript
withConverter<NewAppModelType, NewDbModelType extends DocumentData = DocumentData>(converter: FirestoreDataConverter<NewAppModelType, NewDbModelType>): Query<NewAppModelType, NewDbModelType>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  converter | [FirestoreDataConverter](./firestore_.firestoredataconverter.md#firestoredataconverter_interface)<!-- -->&lt;NewAppModelType, NewDbModelType&gt; | Converts objects to and from Firestore. |

<b>Returns:</b>

[Query](./firestore_.query.md#query_class)<!-- -->&lt;NewAppModelType, NewDbModelType&gt;

A `Query` that uses the provided converter.

