Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# QuerySnapshot class
A `QuerySnapshot` contains zero or more `DocumentSnapshot` objects representing the results of a query. The documents can be accessed as an array via the `docs` property or enumerated using the `forEach` method. The number of documents can be determined via the `empty` and `size` properties.

<b>Signature:</b>

```typescript
export declare class QuerySnapshot<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [docs](./firestore_.querysnapshot.md#querysnapshotdocs) |  | Array&lt;[QueryDocumentSnapshot](./firestore_.querydocumentsnapshot.md#querydocumentsnapshot_class)<!-- -->&lt;AppModelType, DbModelType&gt;&gt; | An array of all the documents in the <code>QuerySnapshot</code>. |
|  [empty](./firestore_.querysnapshot.md#querysnapshotempty) |  | boolean | True if there are no documents in the <code>QuerySnapshot</code>. |
|  [metadata](./firestore_.querysnapshot.md#querysnapshotmetadata) |  | [SnapshotMetadata](./firestore_.snapshotmetadata.md#snapshotmetadata_class) | Metadata about this snapshot, concerning its source and if it has local modifications. |
|  [query](./firestore_.querysnapshot.md#querysnapshotquery) |  | [Query](./firestore_.query.md#query_class)<!-- -->&lt;AppModelType, DbModelType&gt; | The query on which you called <code>get</code> or <code>onSnapshot</code> in order to get this <code>QuerySnapshot</code>. |
|  [size](./firestore_.querysnapshot.md#querysnapshotsize) |  | number | The number of documents in the <code>QuerySnapshot</code>. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [docChanges(options)](./firestore_.querysnapshot.md#querysnapshotdocchanges) |  | Returns an array of the documents changes since the last snapshot. If this is the first snapshot, all documents will be in the list as 'added' changes. |
|  [forEach(callback, thisArg)](./firestore_.querysnapshot.md#querysnapshotforeach) |  | Enumerates all of the documents in the <code>QuerySnapshot</code>. |
|  [toJSON()](./firestore_.querysnapshot.md#querysnapshottojson) |  | Returns a JSON-serializable representation of this <code>QuerySnapshot</code> instance. |

## QuerySnapshot.docs

An array of all the documents in the `QuerySnapshot`<!-- -->.

<b>Signature:</b>

```typescript
get docs(): Array<QueryDocumentSnapshot<AppModelType, DbModelType>>;
```

## QuerySnapshot.empty

True if there are no documents in the `QuerySnapshot`<!-- -->.

<b>Signature:</b>

```typescript
get empty(): boolean;
```

## QuerySnapshot.metadata

Metadata about this snapshot, concerning its source and if it has local modifications.

<b>Signature:</b>

```typescript
readonly metadata: SnapshotMetadata;
```

## QuerySnapshot.query

The query on which you called `get` or `onSnapshot` in order to get this `QuerySnapshot`<!-- -->.

<b>Signature:</b>

```typescript
readonly query: Query<AppModelType, DbModelType>;
```

## QuerySnapshot.size

The number of documents in the `QuerySnapshot`<!-- -->.

<b>Signature:</b>

```typescript
get size(): number;
```

## QuerySnapshot.docChanges()

Returns an array of the documents changes since the last snapshot. If this is the first snapshot, all documents will be in the list as 'added' changes.

<b>Signature:</b>

```typescript
docChanges(options?: SnapshotListenOptions): Array<DocumentChange<AppModelType, DbModelType>>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | [SnapshotListenOptions](./firestore_.snapshotlistenoptions.md#snapshotlistenoptions_interface) | <code>SnapshotListenOptions</code> that control whether metadata-only changes (i.e. only <code>DocumentSnapshot.metadata</code> changed) should trigger snapshot events. |

<b>Returns:</b>

Array&lt;[DocumentChange](./firestore_.documentchange.md#documentchange_interface)<!-- -->&lt;AppModelType, DbModelType&gt;&gt;

## QuerySnapshot.forEach()

Enumerates all of the documents in the `QuerySnapshot`<!-- -->.

<b>Signature:</b>

```typescript
forEach(callback: (result: QueryDocumentSnapshot<AppModelType, DbModelType>) => void, thisArg?: unknown): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  callback | (result: [QueryDocumentSnapshot](./firestore_.querydocumentsnapshot.md#querydocumentsnapshot_class)<!-- -->&lt;AppModelType, DbModelType&gt;) =&gt; void | A callback to be called with a <code>QueryDocumentSnapshot</code> for each document in the snapshot. |
|  thisArg | unknown | The <code>this</code> binding for the callback. |

<b>Returns:</b>

void

## QuerySnapshot.toJSON()

Returns a JSON-serializable representation of this `QuerySnapshot` instance.

<b>Signature:</b>

```typescript
toJSON(): object;
```
<b>Returns:</b>

object

a JSON representation of this object. Throws a [FirestoreError](./firestore_.firestoreerror.md#firestoreerror_class) if this `QuerySnapshot` has pending writes.

