Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# SnapshotMetadata class
Metadata about a snapshot, describing the state of the snapshot.

<b>Signature:</b>

```typescript
export declare class SnapshotMetadata 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [fromCache](./firestore_.snapshotmetadata.md#snapshotmetadatafromcache) |  | boolean | True if the snapshot was created from cached data rather than guaranteed up-to-date server data. If your listener has opted into metadata updates (via <code>SnapshotListenOptions</code>) you will receive another snapshot with <code>fromCache</code> set to false once the client has received up-to-date data from the backend. |
|  [hasPendingWrites](./firestore_.snapshotmetadata.md#snapshotmetadatahaspendingwrites) |  | boolean | True if the snapshot contains the result of local writes (for example <code>set()</code> or <code>update()</code> calls) that have not yet been committed to the backend. If your listener has opted into metadata updates (via <code>SnapshotListenOptions</code>) you will receive another snapshot with <code>hasPendingWrites</code> equal to false once the writes have been committed to the backend. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [isEqual(other)](./firestore_.snapshotmetadata.md#snapshotmetadataisequal) |  | Returns true if this <code>SnapshotMetadata</code> is equal to the provided one. |

## SnapshotMetadata.fromCache

True if the snapshot was created from cached data rather than guaranteed up-to-date server data. If your listener has opted into metadata updates (via `SnapshotListenOptions`<!-- -->) you will receive another snapshot with `fromCache` set to false once the client has received up-to-date data from the backend.

<b>Signature:</b>

```typescript
readonly fromCache: boolean;
```

## SnapshotMetadata.hasPendingWrites

True if the snapshot contains the result of local writes (for example `set()` or `update()` calls) that have not yet been committed to the backend. If your listener has opted into metadata updates (via `SnapshotListenOptions`<!-- -->) you will receive another snapshot with `hasPendingWrites` equal to false once the writes have been committed to the backend.

<b>Signature:</b>

```typescript
readonly hasPendingWrites: boolean;
```

## SnapshotMetadata.isEqual()

Returns true if this `SnapshotMetadata` is equal to the provided one.

<b>Signature:</b>

```typescript
isEqual(other: SnapshotMetadata): boolean;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  other | [SnapshotMetadata](./firestore_.snapshotmetadata.md#snapshotmetadata_class) | The <code>SnapshotMetadata</code> to compare against. |

<b>Returns:</b>

boolean

true if this `SnapshotMetadata` is equal to the provided one.

