Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# Timestamp class
A `Timestamp` represents a point in time independent of any time zone or calendar, represented as seconds and fractions of seconds at nanosecond resolution in UTC Epoch time.

It is encoded using the Proleptic Gregorian Calendar which extends the Gregorian calendar backwards to year one. It is encoded assuming all minutes are 60 seconds long, i.e. leap seconds are "smeared" so that no leap second table is needed for interpretation. Range is from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z.

For examples and further specifications, refer to the [Timestamp definition](https://github.com/google/protobuf/blob/master/src/google/protobuf/timestamp.proto)<!-- -->.

<b>Signature:</b>

```typescript
export declare class Timestamp 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(seconds, nanoseconds)](./firestore_.timestamp.md#timestampconstructor) |  | Creates a new timestamp. |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [nanoseconds](./firestore_.timestamp.md#timestampnanoseconds) |  | number | The fractions of a second at nanosecond resolution.\* |
|  [seconds](./firestore_.timestamp.md#timestampseconds) |  | number | The number of seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [fromDate(date)](./firestore_.timestamp.md#timestampfromdate) | <code>static</code> | Creates a new timestamp from the given date. |
|  [fromJSON(json)](./firestore_.timestamp.md#timestampfromjson) | <code>static</code> | Builds a <code>Timestamp</code> instance from a JSON object created by [Timestamp.toJSON()](./firestore_.timestamp.md#timestamptojson)<!-- -->. |
|  [fromMillis(milliseconds)](./firestore_.timestamp.md#timestampfrommillis) | <code>static</code> | Creates a new timestamp from the given number of milliseconds. |
|  [isEqual(other)](./firestore_.timestamp.md#timestampisequal) |  | Returns true if this <code>Timestamp</code> is equal to the provided one. |
|  [now()](./firestore_.timestamp.md#timestampnow) | <code>static</code> | Creates a new timestamp with the current date, with millisecond precision. |
|  [toDate()](./firestore_.timestamp.md#timestamptodate) |  | Converts a <code>Timestamp</code> to a JavaScript <code>Date</code> object. This conversion causes a loss of precision since <code>Date</code> objects only support millisecond precision. |
|  [toJSON()](./firestore_.timestamp.md#timestamptojson) |  | Returns a JSON-serializable representation of this <code>Timestamp</code>. |
|  [toMillis()](./firestore_.timestamp.md#timestamptomillis) |  | Converts a <code>Timestamp</code> to a numeric timestamp (in milliseconds since epoch). This operation causes a loss of precision. |
|  [toString()](./firestore_.timestamp.md#timestamptostring) |  | Returns a textual representation of this <code>Timestamp</code>. |
|  [valueOf()](./firestore_.timestamp.md#timestampvalueof) |  | Converts this object to a primitive string, which allows <code>Timestamp</code> objects to be compared using the <code>&gt;</code>, <code>&lt;=</code>, <code>&gt;=</code> and <code>&gt;</code> operators. |

## Timestamp.(constructor)

Creates a new timestamp.

<b>Signature:</b>

```typescript
constructor(
    seconds: number, 
    nanoseconds: number);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  seconds | number | The number of seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive. |
|  nanoseconds | number | The non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanoseconds values that count forward in time. Must be from 0 to 999,999,999 inclusive. |

## Timestamp.nanoseconds

The fractions of a second at nanosecond resolution.\*

<b>Signature:</b>

```typescript
readonly nanoseconds: number;
```

## Timestamp.seconds

The number of seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z.

<b>Signature:</b>

```typescript
readonly seconds: number;
```

## Timestamp.fromDate()

Creates a new timestamp from the given date.

<b>Signature:</b>

```typescript
static fromDate(date: Date): Timestamp;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  date | Date | The date to initialize the <code>Timestamp</code> from. |

<b>Returns:</b>

[Timestamp](./firestore_.timestamp.md#timestamp_class)

A new `Timestamp` representing the same point in time as the given date.

## Timestamp.fromJSON()

Builds a `Timestamp` instance from a JSON object created by [Timestamp.toJSON()](./firestore_.timestamp.md#timestamptojson)<!-- -->.

<b>Signature:</b>

```typescript
static fromJSON(json: object): Timestamp;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  json | object |  |

<b>Returns:</b>

[Timestamp](./firestore_.timestamp.md#timestamp_class)

## Timestamp.fromMillis()

Creates a new timestamp from the given number of milliseconds.

<b>Signature:</b>

```typescript
static fromMillis(milliseconds: number): Timestamp;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  milliseconds | number | Number of milliseconds since Unix epoch 1970-01-01T00:00:00Z. |

<b>Returns:</b>

[Timestamp](./firestore_.timestamp.md#timestamp_class)

A new `Timestamp` representing the same point in time as the given number of milliseconds.

## Timestamp.isEqual()

Returns true if this `Timestamp` is equal to the provided one.

<b>Signature:</b>

```typescript
isEqual(other: Timestamp): boolean;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  other | [Timestamp](./firestore_.timestamp.md#timestamp_class) | The <code>Timestamp</code> to compare against. |

<b>Returns:</b>

boolean

true if this `Timestamp` is equal to the provided one.

## Timestamp.now()

Creates a new timestamp with the current date, with millisecond precision.

<b>Signature:</b>

```typescript
static now(): Timestamp;
```
<b>Returns:</b>

[Timestamp](./firestore_.timestamp.md#timestamp_class)

a new timestamp representing the current date.

## Timestamp.toDate()

Converts a `Timestamp` to a JavaScript `Date` object. This conversion causes a loss of precision since `Date` objects only support millisecond precision.

<b>Signature:</b>

```typescript
toDate(): Date;
```
<b>Returns:</b>

Date

JavaScript `Date` object representing the same point in time as this `Timestamp`<!-- -->, with millisecond precision.

## Timestamp.toJSON()

Returns a JSON-serializable representation of this `Timestamp`<!-- -->.

<b>Signature:</b>

```typescript
toJSON(): {
        seconds: number;
        nanoseconds: number;
        type: string;
    };
```
<b>Returns:</b>

{ seconds: number; nanoseconds: number; type: string; }

## Timestamp.toMillis()

Converts a `Timestamp` to a numeric timestamp (in milliseconds since epoch). This operation causes a loss of precision.

<b>Signature:</b>

```typescript
toMillis(): number;
```
<b>Returns:</b>

number

The point in time corresponding to this timestamp, represented as the number of milliseconds since Unix epoch 1970-01-01T00:00:00Z.

## Timestamp.toString()

Returns a textual representation of this `Timestamp`<!-- -->.

<b>Signature:</b>

```typescript
toString(): string;
```
<b>Returns:</b>

string

## Timestamp.valueOf()

Converts this object to a primitive string, which allows `Timestamp` objects to be compared using the `>`<!-- -->, `<=`<!-- -->, `>=` and `>` operators.

<b>Signature:</b>

```typescript
valueOf(): string;
```
<b>Returns:</b>

string

