Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# Transaction class
A reference to a transaction.

The `Transaction` object passed to a transaction's `updateFunction` provides the methods to read and write data within the transaction context. See [runTransaction()](./firestore_.md#runtransaction_6f03ec4)<!-- -->.

<b>Signature:</b>

```typescript
export declare class Transaction 
```

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [delete(documentRef)](./firestore_.transaction.md#transactiondelete) |  | Deletes the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. |
|  [get(documentRef)](./firestore_.transaction.md#transactionget) |  | Reads the document referenced by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. |
|  [set(documentRef, data)](./firestore_.transaction.md#transactionset) |  | Writes to the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. If the document does not exist yet, it will be created. |
|  [set(documentRef, data, options)](./firestore_.transaction.md#transactionset) |  | Writes to the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. If the document does not exist yet, it will be created. If you provide <code>merge</code> or <code>mergeFields</code>, the provided data can be merged into an existing document. |
|  [update(documentRef, data)](./firestore_.transaction.md#transactionupdate) |  | Updates fields in the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. The update will fail if applied to a document that does not exist. |
|  [update(documentRef, field, value, moreFieldsAndValues)](./firestore_.transaction.md#transactionupdate) |  | Updates fields in the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. The update will fail if applied to a document that does not exist.<!-- -->Nested fields can be updated by providing dot-separated field path strings or by providing <code>FieldPath</code> objects. |

## Transaction.delete()

Deletes the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->.

<b>Signature:</b>

```typescript
delete<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>): this;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be deleted. |

<b>Returns:</b>

this

This `Transaction` instance. Used for chaining method calls.

## Transaction.get()

Reads the document referenced by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->.

<b>Signature:</b>

```typescript
get<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>): Promise<DocumentSnapshot<AppModelType, DbModelType>>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be read. |

<b>Returns:</b>

Promise&lt;[DocumentSnapshot](./firestore_.documentsnapshot.md#documentsnapshot_class)<!-- -->&lt;AppModelType, DbModelType&gt;&gt;

A `DocumentSnapshot` with the read data.

## Transaction.set()

Writes to the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. If the document does not exist yet, it will be created.

<b>Signature:</b>

```typescript
set<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: WithFieldValue<AppModelType>): this;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be set. |
|  data | [WithFieldValue](./firestore_.md#withfieldvalue)<!-- -->&lt;AppModelType&gt; | An object of the fields and values for the document. |

<b>Returns:</b>

this

This `Transaction` instance. Used for chaining method calls.

#### Exceptions

Error - If the provided input is not a valid Firestore document.

## Transaction.set()

Writes to the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. If the document does not exist yet, it will be created. If you provide `merge` or `mergeFields`<!-- -->, the provided data can be merged into an existing document.

<b>Signature:</b>

```typescript
set<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: PartialWithFieldValue<AppModelType>, options: SetOptions): this;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be set. |
|  data | [PartialWithFieldValue](./firestore_.md#partialwithfieldvalue)<!-- -->&lt;AppModelType&gt; | An object of the fields and values for the document. |
|  options | [SetOptions](./firestore_.md#setoptions) | An object to configure the set behavior. |

<b>Returns:</b>

this

This `Transaction` instance. Used for chaining method calls.

#### Exceptions

Error - If the provided input is not a valid Firestore document.

## Transaction.update()

Updates fields in the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. The update will fail if applied to a document that does not exist.

<b>Signature:</b>

```typescript
update<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: UpdateData<DbModelType>): this;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be updated. |
|  data | [UpdateData](./firestore_.md#updatedata)<!-- -->&lt;DbModelType&gt; | An object containing the fields and values with which to update the document. Fields can contain dots to reference nested fields within the document. |

<b>Returns:</b>

this

This `Transaction` instance. Used for chaining method calls.

#### Exceptions

Error - If the provided input is not valid Firestore data.

## Transaction.update()

Updates fields in the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. The update will fail if applied to a document that does not exist.

Nested fields can be updated by providing dot-separated field path strings or by providing `FieldPath` objects.

<b>Signature:</b>

```typescript
update<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, field: string | FieldPath, value: unknown, ...moreFieldsAndValues: unknown[]): this;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be updated. |
|  field | string \| [FieldPath](./firestore_.fieldpath.md#fieldpath_class) | The first field to update. |
|  value | unknown | The first value. |
|  moreFieldsAndValues | unknown\[\] | Additional key/value pairs. |

<b>Returns:</b>

this

This `Transaction` instance. Used for chaining method calls.

#### Exceptions

Error - If the provided input is not valid Firestore data.

