Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# WriteBatch class
A write batch, used to perform multiple writes as a single atomic unit.

A `WriteBatch` object can be acquired by calling [writeBatch()](./firestore_.md#writebatch_231a8e0)<!-- -->. It provides methods for adding writes to the write batch. None of the writes will be committed (or visible locally) until [WriteBatch.commit()](./firestore_.writebatch.md#writebatchcommit) is called.

<b>Signature:</b>

```typescript
export declare class WriteBatch 
```

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [commit()](./firestore_.writebatch.md#writebatchcommit) |  | Commits all of the writes in this write batch as a single atomic unit.<!-- -->The result of these writes will only be reflected in document reads that occur after the returned promise resolves. If the client is offline, the write fails. If you would like to see local modifications or buffer writes until the client is online, use the full Firestore SDK. |
|  [delete(documentRef)](./firestore_.writebatch.md#writebatchdelete) |  | Deletes the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. |
|  [set(documentRef, data)](./firestore_.writebatch.md#writebatchset) |  | Writes to the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. If the document does not exist yet, it will be created. |
|  [set(documentRef, data, options)](./firestore_.writebatch.md#writebatchset) |  | Writes to the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. If the document does not exist yet, it will be created. If you provide <code>merge</code> or <code>mergeFields</code>, the provided data can be merged into an existing document. |
|  [update(documentRef, data)](./firestore_.writebatch.md#writebatchupdate) |  | Updates fields in the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. The update will fail if applied to a document that does not exist. |
|  [update(documentRef, field, value, moreFieldsAndValues)](./firestore_.writebatch.md#writebatchupdate) |  | Updates fields in the document referred to by this [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. The update will fail if applied to a document that does not exist.<!-- -->Nested fields can be update by providing dot-separated field path strings or by providing <code>FieldPath</code> objects. |

## WriteBatch.commit()

Commits all of the writes in this write batch as a single atomic unit.

The result of these writes will only be reflected in document reads that occur after the returned promise resolves. If the client is offline, the write fails. If you would like to see local modifications or buffer writes until the client is online, use the full Firestore SDK.

<b>Signature:</b>

```typescript
commit(): Promise<void>;
```
<b>Returns:</b>

Promise&lt;void&gt;

A `Promise` resolved once all of the writes in the batch have been successfully written to the backend as an atomic unit (note that it won't resolve while you're offline).

## WriteBatch.delete()

Deletes the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->.

<b>Signature:</b>

```typescript
delete<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>): WriteBatch;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be deleted. |

<b>Returns:</b>

[WriteBatch](./firestore_.writebatch.md#writebatch_class)

This `WriteBatch` instance. Used for chaining method calls.

## WriteBatch.set()

Writes to the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. If the document does not exist yet, it will be created.

<b>Signature:</b>

```typescript
set<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: WithFieldValue<AppModelType>): WriteBatch;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be set. |
|  data | [WithFieldValue](./firestore_.md#withfieldvalue)<!-- -->&lt;AppModelType&gt; | An object of the fields and values for the document. |

<b>Returns:</b>

[WriteBatch](./firestore_.writebatch.md#writebatch_class)

This `WriteBatch` instance. Used for chaining method calls.

## WriteBatch.set()

Writes to the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. If the document does not exist yet, it will be created. If you provide `merge` or `mergeFields`<!-- -->, the provided data can be merged into an existing document.

<b>Signature:</b>

```typescript
set<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: PartialWithFieldValue<AppModelType>, options: SetOptions): WriteBatch;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be set. |
|  data | [PartialWithFieldValue](./firestore_.md#partialwithfieldvalue)<!-- -->&lt;AppModelType&gt; | An object of the fields and values for the document. |
|  options | [SetOptions](./firestore_.md#setoptions) | An object to configure the set behavior. |

<b>Returns:</b>

[WriteBatch](./firestore_.writebatch.md#writebatch_class)

This `WriteBatch` instance. Used for chaining method calls.

#### Exceptions

Error - If the provided input is not a valid Firestore document.

## WriteBatch.update()

Updates fields in the document referred to by the provided [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. The update will fail if applied to a document that does not exist.

<b>Signature:</b>

```typescript
update<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: UpdateData<DbModelType>): WriteBatch;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be updated. |
|  data | [UpdateData](./firestore_.md#updatedata)<!-- -->&lt;DbModelType&gt; | An object containing the fields and values with which to update the document. Fields can contain dots to reference nested fields within the document. |

<b>Returns:</b>

[WriteBatch](./firestore_.writebatch.md#writebatch_class)

This `WriteBatch` instance. Used for chaining method calls.

#### Exceptions

Error - If the provided input is not valid Firestore data.

## WriteBatch.update()

Updates fields in the document referred to by this [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->. The update will fail if applied to a document that does not exist.

Nested fields can be update by providing dot-separated field path strings or by providing `FieldPath` objects.

<b>Signature:</b>

```typescript
update<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, field: string | FieldPath, value: unknown, ...moreFieldsAndValues: unknown[]): WriteBatch;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  documentRef | [DocumentReference](./firestore_.documentreference.md#documentreference_class)<!-- -->&lt;AppModelType, DbModelType&gt; | A reference to the document to be updated. |
|  field | string \| [FieldPath](./firestore_.fieldpath.md#fieldpath_class) | The first field to update. |
|  value | unknown | The first value. |
|  moreFieldsAndValues | unknown\[\] | Additional key value pairs. |

<b>Returns:</b>

[WriteBatch](./firestore_.writebatch.md#writebatch_class)

This `WriteBatch` instance. Used for chaining method calls.

#### Exceptions

Error - If the provided input is not valid Firestore data.

