Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# QuerySnapshot class
A `QuerySnapshot` contains zero or more `DocumentSnapshot` objects representing the results of a query. The documents can be accessed as an array via the `docs` property or enumerated using the `forEach` method. The number of documents can be determined via the `empty` and `size` properties.

<b>Signature:</b>

```typescript
export declare class QuerySnapshot<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [docs](./firestore_lite.querysnapshot.md#querysnapshotdocs) |  | Array&lt;[QueryDocumentSnapshot](./firestore_lite.querydocumentsnapshot.md#querydocumentsnapshot_class)<!-- -->&lt;AppModelType, DbModelType&gt;&gt; | An array of all the documents in the <code>QuerySnapshot</code>. |
|  [empty](./firestore_lite.querysnapshot.md#querysnapshotempty) |  | boolean | True if there are no documents in the <code>QuerySnapshot</code>. |
|  [query](./firestore_lite.querysnapshot.md#querysnapshotquery) |  | [Query](./firestore_lite.query.md#query_class)<!-- -->&lt;AppModelType, DbModelType&gt; | The query on which you called [getDocs()](./firestore_.md#getdocs_4e56953) in order to get this <code>QuerySnapshot</code>. |
|  [size](./firestore_lite.querysnapshot.md#querysnapshotsize) |  | number | The number of documents in the <code>QuerySnapshot</code>. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [forEach(callback, thisArg)](./firestore_lite.querysnapshot.md#querysnapshotforeach) |  | Enumerates all of the documents in the <code>QuerySnapshot</code>. |

## QuerySnapshot.docs

An array of all the documents in the `QuerySnapshot`<!-- -->.

<b>Signature:</b>

```typescript
get docs(): Array<QueryDocumentSnapshot<AppModelType, DbModelType>>;
```

## QuerySnapshot.empty

True if there are no documents in the `QuerySnapshot`<!-- -->.

<b>Signature:</b>

```typescript
get empty(): boolean;
```

## QuerySnapshot.query

The query on which you called [getDocs()](./firestore_.md#getdocs_4e56953) in order to get this `QuerySnapshot`<!-- -->.

<b>Signature:</b>

```typescript
readonly query: Query<AppModelType, DbModelType>;
```

## QuerySnapshot.size

The number of documents in the `QuerySnapshot`<!-- -->.

<b>Signature:</b>

```typescript
get size(): number;
```

## QuerySnapshot.forEach()

Enumerates all of the documents in the `QuerySnapshot`<!-- -->.

<b>Signature:</b>

```typescript
forEach(callback: (result: QueryDocumentSnapshot<AppModelType, DbModelType>) => void, thisArg?: unknown): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  callback | (result: [QueryDocumentSnapshot](./firestore_lite.querydocumentsnapshot.md#querydocumentsnapshot_class)<!-- -->&lt;AppModelType, DbModelType&gt;) =&gt; void | A callback to be called with a <code>QueryDocumentSnapshot</code> for each document in the snapshot. |
|  thisArg | unknown | The <code>this</code> binding for the callback. |

<b>Returns:</b>

void

