Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# functions package
Cloud Functions for Firebase

## Functions

|  Function | Description |
|  --- | --- |
|  <b>function(app, ...)</b> |
|  [getFunctions(app, regionOrCustomDomain)](./functions.md#getfunctions_60f2095) | Returns a [Functions](./functions.functions.md#functions_interface) instance for the given app. |
|  <b>function(functionsInstance, ...)</b> |
|  [connectFunctionsEmulator(functionsInstance, host, port)](./functions.md#connectfunctionsemulator_505c08d) | Modify this instance to communicate with the Cloud Functions emulator.<!-- -->Note: this must be called before this instance has been used to do any operations. |
|  [httpsCallable(functionsInstance, name, options)](./functions.md#httpscallable_1dd297c) | Returns a reference to the callable HTTPS trigger with the given name. |
|  [httpsCallableFromURL(functionsInstance, url, options)](./functions.md#httpscallablefromurl_7af6987) | Returns a reference to the callable HTTPS trigger with the specified url. |

## Classes

|  Class | Description |
|  --- | --- |
|  [FunctionsError](./functions.functionserror.md#functionserror_class) | An error returned by the Firebase Functions client SDK.<!-- -->See [FunctionsErrorCode](./functions.md#functionserrorcode) for full documentation of codes. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [Functions](./functions.functions.md#functions_interface) | A <code>Functions</code> instance. |
|  [HttpsCallable](./functions.httpscallable.md#httpscallable_interface) | A reference to a "callable" HTTP trigger in Cloud Functions. |
|  [HttpsCallableOptions](./functions.httpscallableoptions.md#httpscallableoptions_interface) | An interface for metadata about how calls should be executed. |
|  [HttpsCallableResult](./functions.httpscallableresult.md#httpscallableresult_interface) | An <code>HttpsCallableResult</code> wraps a single result from a function call. |
|  [HttpsCallableStreamOptions](./functions.httpscallablestreamoptions.md#httpscallablestreamoptions_interface) | An interface for metadata about how a stream call should be executed. |
|  [HttpsCallableStreamResult](./functions.httpscallablestreamresult.md#httpscallablestreamresult_interface) | An <code>HttpsCallableStreamResult</code> wraps a single streaming result from a function call. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [FunctionsErrorCode](./functions.md#functionserrorcode) | The set of Firebase Functions status codes. The codes are the same at the ones exposed by gRPC here: https://github.com/grpc/grpc/blob/master/doc/statuscodes.md<!-- -->Possible values: - 'cancelled': The operation was cancelled (typically by the caller). - 'unknown': Unknown error or an error from a different error domain. - 'invalid-argument': Client specified an invalid argument. Note that this differs from 'failed-precondition'. 'invalid-argument' indicates arguments that are problematic regardless of the state of the system (e.g. an invalid field name). - 'deadline-exceeded': Deadline expired before operation could complete. For operations that change the state of the system, this error may be returned even if the operation has completed successfully. For example, a successful response from a server could have been delayed long enough for the deadline to expire. - 'not-found': Some requested document was not found. - 'already-exists': Some document that we attempted to create already exists. - 'permission-denied': The caller does not have permission to execute the specified operation. - 'resource-exhausted': Some resource has been exhausted, perhaps a per-user quota, or perhaps the entire file system is out of space. - 'failed-precondition': Operation was rejected because the system is not in a state required for the operation's execution. - 'aborted': The operation was aborted, typically due to a concurrency issue like transaction aborts, etc. - 'out-of-range': Operation was attempted past the valid range. - 'unimplemented': Operation is not implemented or not supported/enabled. - 'internal': Internal errors. Means some invariants expected by underlying system has been broken. If you see one of these errors, something is very broken. - 'unavailable': The service is currently unavailable. This is most likely a transient condition and may be corrected by retrying with a backoff. - 'data-loss': Unrecoverable data loss or corruption. - 'unauthenticated': The request does not have valid authentication credentials for the operation. |
|  [FunctionsErrorCodeCore](./functions.md#functionserrorcodecore) | Functions error code string appended after "functions/" product prefix. See [FunctionsErrorCode](./functions.md#functionserrorcode) for full documentation of codes. |

## function(app, ...)

### getFunctions(app, regionOrCustomDomain) {:#getfunctions_60f2095}

Returns a [Functions](./functions.functions.md#functions_interface) instance for the given app.

<b>Signature:</b>

```typescript
export declare function getFunctions(app?: FirebaseApp, regionOrCustomDomain?: string): Functions;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | The [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) to use. |
|  regionOrCustomDomain | string | one of: a) The region the callable functions are located in (ex: us-central1) b) A custom domain hosting the callable functions (ex: https://mydomain.com) |

<b>Returns:</b>

[Functions](./functions.functions.md#functions_interface)

## function(functionsInstance, ...)

### connectFunctionsEmulator(functionsInstance, host, port) {:#connectfunctionsemulator_505c08d}

Modify this instance to communicate with the Cloud Functions emulator.

Note: this must be called before this instance has been used to do any operations.

<b>Signature:</b>

```typescript
export declare function connectFunctionsEmulator(functionsInstance: Functions, host: string, port: number): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  functionsInstance | [Functions](./functions.functions.md#functions_interface) |  |
|  host | string | The emulator host (ex: localhost) |
|  port | number | The emulator port (ex: 5001) |

<b>Returns:</b>

void

### httpsCallable(functionsInstance, name, options) {:#httpscallable_1dd297c}

Returns a reference to the callable HTTPS trigger with the given name.

<b>Signature:</b>

```typescript
export declare function httpsCallable<RequestData = unknown, ResponseData = unknown, StreamData = unknown>(functionsInstance: Functions, name: string, options?: HttpsCallableOptions): HttpsCallable<RequestData, ResponseData, StreamData>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  functionsInstance | [Functions](./functions.functions.md#functions_interface) |  |
|  name | string | The name of the trigger. |
|  options | [HttpsCallableOptions](./functions.httpscallableoptions.md#httpscallableoptions_interface) |  |

<b>Returns:</b>

[HttpsCallable](./functions.httpscallable.md#httpscallable_interface)<!-- -->&lt;RequestData, ResponseData, StreamData&gt;

### httpsCallableFromURL(functionsInstance, url, options) {:#httpscallablefromurl_7af6987}

Returns a reference to the callable HTTPS trigger with the specified url.

<b>Signature:</b>

```typescript
export declare function httpsCallableFromURL<RequestData = unknown, ResponseData = unknown, StreamData = unknown>(functionsInstance: Functions, url: string, options?: HttpsCallableOptions): HttpsCallable<RequestData, ResponseData, StreamData>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  functionsInstance | [Functions](./functions.functions.md#functions_interface) |  |
|  url | string | The url of the trigger. |
|  options | [HttpsCallableOptions](./functions.httpscallableoptions.md#httpscallableoptions_interface) |  |

<b>Returns:</b>

[HttpsCallable](./functions.httpscallable.md#httpscallable_interface)<!-- -->&lt;RequestData, ResponseData, StreamData&gt;

## FunctionsErrorCode

The set of Firebase Functions status codes. The codes are the same at the ones exposed by gRPC here: https://github.com/grpc/grpc/blob/master/doc/statuscodes.md

Possible values: - 'cancelled': The operation was cancelled (typically by the caller). - 'unknown': Unknown error or an error from a different error domain. - 'invalid-argument': Client specified an invalid argument. Note that this differs from 'failed-precondition'. 'invalid-argument' indicates arguments that are problematic regardless of the state of the system (e.g. an invalid field name). - 'deadline-exceeded': Deadline expired before operation could complete. For operations that change the state of the system, this error may be returned even if the operation has completed successfully. For example, a successful response from a server could have been delayed long enough for the deadline to expire. - 'not-found': Some requested document was not found. - 'already-exists': Some document that we attempted to create already exists. - 'permission-denied': The caller does not have permission to execute the specified operation. - 'resource-exhausted': Some resource has been exhausted, perhaps a per-user quota, or perhaps the entire file system is out of space. - 'failed-precondition': Operation was rejected because the system is not in a state required for the operation's execution. - 'aborted': The operation was aborted, typically due to a concurrency issue like transaction aborts, etc. - 'out-of-range': Operation was attempted past the valid range. - 'unimplemented': Operation is not implemented or not supported/enabled. - 'internal': Internal errors. Means some invariants expected by underlying system has been broken. If you see one of these errors, something is very broken. - 'unavailable': The service is currently unavailable. This is most likely a transient condition and may be corrected by retrying with a backoff. - 'data-loss': Unrecoverable data loss or corruption. - 'unauthenticated': The request does not have valid authentication credentials for the operation.

<b>Signature:</b>

```typescript
export type FunctionsErrorCode = `functions/${FunctionsErrorCodeCore}`;
```

## FunctionsErrorCodeCore

Functions error code string appended after "functions/" product prefix. See [FunctionsErrorCode](./functions.md#functionserrorcode) for full documentation of codes.

<b>Signature:</b>

```typescript
export type FunctionsErrorCodeCore = 'ok' | 'cancelled' | 'unknown' | 'invalid-argument' | 'deadline-exceeded' | 'not-found' | 'already-exists' | 'permission-denied' | 'resource-exhausted' | 'failed-precondition' | 'aborted' | 'out-of-range' | 'unimplemented' | 'internal' | 'unavailable' | 'data-loss' | 'unauthenticated';
```
