Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# installations package
The Firebase Installations Web SDK. This SDK does not work in a Node.js environment.

## Functions

|  Function | Description |
|  --- | --- |
|  <b>function(app, ...)</b> |
|  [getInstallations(app)](./installations.md#getinstallations_cf608e1) | Returns an instance of [Installations](./installations.installations.md#installations_interface) associated with the given [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) instance. |
|  <b>function(installations, ...)</b> |
|  [deleteInstallations(installations)](./installations.md#deleteinstallations_606c567) | Deletes the Firebase Installation and all associated data. |
|  [getId(installations)](./installations.md#getid_606c567) | Creates a Firebase Installation if there isn't one for the app and returns the Installation ID. |
|  [getToken(installations, forceRefresh)](./installations.md#gettoken_cf009a7) | Returns a Firebase Installations auth token, identifying the current Firebase Installation. |
|  [onIdChange(installations, callback)](./installations.md#onidchange_b579e0e) | Sets a new callback that will get called when Installation ID changes. Returns an unsubscribe function that will remove the callback when called. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [Installations](./installations.installations.md#installations_interface) | Public interface of the Firebase Installations SDK. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [IdChangeCallbackFn](./installations.md#idchangecallbackfn) | An user defined callback function that gets called when Installations ID changes. |
|  [IdChangeUnsubscribeFn](./installations.md#idchangeunsubscribefn) | Unsubscribe a callback function previously added via [IdChangeCallbackFn](./installations.md#idchangecallbackfn)<!-- -->. |

## function(app, ...)

### getInstallations(app) {:#getinstallations_cf608e1}

Returns an instance of [Installations](./installations.installations.md#installations_interface) associated with the given [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) instance.

<b>Signature:</b>

```typescript
export declare function getInstallations(app?: FirebaseApp): Installations;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | The [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) instance. |

<b>Returns:</b>

[Installations](./installations.installations.md#installations_interface)

## function(installations, ...)

### deleteInstallations(installations) {:#deleteinstallations_606c567}

Deletes the Firebase Installation and all associated data.

<b>Signature:</b>

```typescript
export declare function deleteInstallations(installations: Installations): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  installations | [Installations](./installations.installations.md#installations_interface) | The <code>Installations</code> instance. |

<b>Returns:</b>

Promise&lt;void&gt;

### getId(installations) {:#getid_606c567}

Creates a Firebase Installation if there isn't one for the app and returns the Installation ID.

<b>Signature:</b>

```typescript
export declare function getId(installations: Installations): Promise<string>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  installations | [Installations](./installations.installations.md#installations_interface) | The <code>Installations</code> instance. |

<b>Returns:</b>

Promise&lt;string&gt;

### getToken(installations, forceRefresh) {:#gettoken_cf009a7}

Returns a Firebase Installations auth token, identifying the current Firebase Installation.

<b>Signature:</b>

```typescript
export declare function getToken(installations: Installations, forceRefresh?: boolean): Promise<string>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  installations | [Installations](./installations.installations.md#installations_interface) | The <code>Installations</code> instance. |
|  forceRefresh | boolean | Force refresh regardless of token expiration. |

<b>Returns:</b>

Promise&lt;string&gt;

### onIdChange(installations, callback) {:#onidchange_b579e0e}

Sets a new callback that will get called when Installation ID changes. Returns an unsubscribe function that will remove the callback when called.

<b>Signature:</b>

```typescript
export declare function onIdChange(installations: Installations, callback: IdChangeCallbackFn): IdChangeUnsubscribeFn;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  installations | [Installations](./installations.installations.md#installations_interface) | The <code>Installations</code> instance. |
|  callback | [IdChangeCallbackFn](./installations.md#idchangecallbackfn) | The callback function that is invoked when FID changes. |

<b>Returns:</b>

[IdChangeUnsubscribeFn](./installations.md#idchangeunsubscribefn)

A function that can be called to unsubscribe.

## IdChangeCallbackFn

An user defined callback function that gets called when Installations ID changes.

<b>Signature:</b>

```typescript
export type IdChangeCallbackFn = (installationId: string) => void;
```

## IdChangeUnsubscribeFn

Unsubscribe a callback function previously added via [IdChangeCallbackFn](./installations.md#idchangecallbackfn)<!-- -->.

<b>Signature:</b>

```typescript
export type IdChangeUnsubscribeFn = () => void;
```
