Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# @firebase/messaging

## Functions

|  Function | Description |
|  --- | --- |
|  <b>function(app, ...)</b> |
|  [getMessaging(app)](./messaging_.md#getmessaging_cf608e1) | Retrieves a Firebase Cloud Messaging instance. |
|  <b>function(messaging, ...)</b> |
|  [deleteToken(messaging)](./messaging_.md#deletetoken_3fae4b1) | Deletes the registration token associated with this [Messaging](./messaging_.messaging.md#messaging_interface) instance and unsubscribes the [Messaging](./messaging_.messaging.md#messaging_interface) instance from the push subscription. |
|  [getToken(messaging, options)](./messaging_.md#gettoken_b538f38) | Subscribes the [Messaging](./messaging_.messaging.md#messaging_interface) instance to push notifications. Returns a Firebase Cloud Messaging registration token that can be used to send push messages to that [Messaging](./messaging_.messaging.md#messaging_interface) instance.<!-- -->If notification permission isn't already granted, this method asks the user for permission. The returned promise rejects if the user does not allow the app to show notifications. |
|  [onMessage(messaging, nextOrObserver)](./messaging_.md#onmessage_b9887da) | When a push message is received and the user is currently on a page for your origin, the message is passed to the page and an <code>onMessage()</code> event is dispatched with the payload of the push message. |
|  <b>function()</b> |
|  [isSupported()](./messaging_.md#issupported) | Checks if all required APIs exist in the browser. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [FcmOptions](./messaging_.fcmoptions.md#fcmoptions_interface) | Options for features provided by the FCM SDK for Web. See [WebpushFcmOptions](https://firebase.google.com/docs/reference/fcm/rest/v1/projects.messages#webpushfcmoptions)<!-- -->. |
|  [GetTokenOptions](./messaging_.gettokenoptions.md#gettokenoptions_interface) | Options for [getToken()](./messaging_.md#gettoken_b538f38)<!-- -->. |
|  [MessagePayload](./messaging_.messagepayload.md#messagepayload_interface) | Message payload that contains the notification payload that is represented with [NotificationPayload](./messaging_.notificationpayload.md#notificationpayload_interface) and the data payload that contains an arbitrary number of key-value pairs sent by developers through the [Send API](https://firebase.google.com/docs/reference/fcm/rest/v1/projects.messages#notification)<!-- -->. |
|  [Messaging](./messaging_.messaging.md#messaging_interface) | Public interface of the Firebase Cloud Messaging SDK. |
|  [NotificationPayload](./messaging_.notificationpayload.md#notificationpayload_interface) | Display notification details. Details are sent through the [Send API](https://firebase.google.com/docs/reference/fcm/rest/v1/projects.messages#notification)<!-- -->. |

## function(app, ...)

### getMessaging(app) {:#getmessaging_cf608e1}

Retrieves a Firebase Cloud Messaging instance.

<b>Signature:</b>

```typescript
export declare function getMessagingInWindow(app?: FirebaseApp): Messaging;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) |  |

<b>Returns:</b>

[Messaging](./messaging_.messaging.md#messaging_interface)

The Firebase Cloud Messaging instance associated with the provided firebase app.

## function(messaging, ...)

### deleteToken(messaging) {:#deletetoken_3fae4b1}

Deletes the registration token associated with this [Messaging](./messaging_.messaging.md#messaging_interface) instance and unsubscribes the [Messaging](./messaging_.messaging.md#messaging_interface) instance from the push subscription.

<b>Signature:</b>

```typescript
export declare function deleteToken(messaging: Messaging): Promise<boolean>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  messaging | [Messaging](./messaging_.messaging.md#messaging_interface) | The [Messaging](./messaging_.messaging.md#messaging_interface) instance. |

<b>Returns:</b>

Promise&lt;boolean&gt;

The promise resolves when the token has been successfully deleted.

### getToken(messaging, options) {:#gettoken_b538f38}

Subscribes the [Messaging](./messaging_.messaging.md#messaging_interface) instance to push notifications. Returns a Firebase Cloud Messaging registration token that can be used to send push messages to that [Messaging](./messaging_.messaging.md#messaging_interface) instance.

If notification permission isn't already granted, this method asks the user for permission. The returned promise rejects if the user does not allow the app to show notifications.

<b>Signature:</b>

```typescript
export declare function getToken(messaging: Messaging, options?: GetTokenOptions): Promise<string>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  messaging | [Messaging](./messaging_.messaging.md#messaging_interface) | The [Messaging](./messaging_.messaging.md#messaging_interface) instance. |
|  options | [GetTokenOptions](./messaging_.gettokenoptions.md#gettokenoptions_interface) | Provides an optional vapid key and an optional service worker registration. |

<b>Returns:</b>

Promise&lt;string&gt;

The promise resolves with an FCM registration token.

### onMessage(messaging, nextOrObserver) {:#onmessage_b9887da}

When a push message is received and the user is currently on a page for your origin, the message is passed to the page and an `onMessage()` event is dispatched with the payload of the push message.

<b>Signature:</b>

```typescript
export declare function onMessage(messaging: Messaging, nextOrObserver: NextFn<MessagePayload> | Observer<MessagePayload>): Unsubscribe;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  messaging | [Messaging](./messaging_.messaging.md#messaging_interface) | The [Messaging](./messaging_.messaging.md#messaging_interface) instance. |
|  nextOrObserver | [NextFn](./util.md#nextfn)<!-- -->&lt;[MessagePayload](./messaging_.messagepayload.md#messagepayload_interface)<!-- -->&gt; \| [Observer](./util.observer.md#observer_interface)<!-- -->&lt;[MessagePayload](./messaging_.messagepayload.md#messagepayload_interface)<!-- -->&gt; | This function, or observer object with <code>next</code> defined, is called when a message is received and the user is currently viewing your page. |

<b>Returns:</b>

[Unsubscribe](./util.md#unsubscribe)

To stop listening for messages execute this returned function.

## function()

### isSupported() {:#issupported}

Checks if all required APIs exist in the browser.

<b>Signature:</b>

```typescript
export declare function isWindowSupported(): Promise<boolean>;
```
<b>Returns:</b>

Promise&lt;boolean&gt;

a Promise that resolves to a boolean.

