Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# MessagePayload interface
Message payload that contains the notification payload that is represented with [NotificationPayload](./messaging_.notificationpayload.md#notificationpayload_interface) and the data payload that contains an arbitrary number of key-value pairs sent by developers through the [Send API](https://firebase.google.com/docs/reference/fcm/rest/v1/projects.messages#notification)<!-- -->.

<b>Signature:</b>

```typescript
export interface MessagePayload 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [collapseKey](./messaging_.messagepayload.md#messagepayloadcollapsekey) | string | The collapse key of the message. See [Non-collapsible and collapsible messages](https://firebase.google.com/docs/cloud-messaging/concept-options#collapsible_and_non-collapsible_messages) |
|  [data](./messaging_.messagepayload.md#messagepayloaddata) | { \[key: string\]: string; } | Arbitrary key/value payload. |
|  [fcmOptions](./messaging_.messagepayload.md#messagepayloadfcmoptions) | [FcmOptions](./messaging_.fcmoptions.md#fcmoptions_interface) | Options for features provided by the FCM SDK for Web. See [WebpushFcmOptions](https://firebase.google.com/docs/reference/fcm/rest/v1/projects.messages#webpushfcmoptions)<!-- -->. |
|  [from](./messaging_.messagepayload.md#messagepayloadfrom) | string | The sender of this message. |
|  [messageId](./messaging_.messagepayload.md#messagepayloadmessageid) | string | The message ID of a message. |
|  [notification](./messaging_.messagepayload.md#messagepayloadnotification) | [NotificationPayload](./messaging_.notificationpayload.md#notificationpayload_interface) | Display notification details. Details are sent through the [Send API](https://firebase.google.com/docs/reference/fcm/rest/v1/projects.messages#notification)<!-- -->. |

## MessagePayload.collapseKey

The collapse key of the message. See [Non-collapsible and collapsible messages](https://firebase.google.com/docs/cloud-messaging/concept-options#collapsible_and_non-collapsible_messages)

<b>Signature:</b>

```typescript
collapseKey: string;
```

## MessagePayload.data

Arbitrary key/value payload.

<b>Signature:</b>

```typescript
data?: {
        [key: string]: string;
    };
```

## MessagePayload.fcmOptions

Options for features provided by the FCM SDK for Web. See [WebpushFcmOptions](https://firebase.google.com/docs/reference/fcm/rest/v1/projects.messages#webpushfcmoptions)<!-- -->.

<b>Signature:</b>

```typescript
fcmOptions?: FcmOptions;
```

## MessagePayload.from

The sender of this message.

<b>Signature:</b>

```typescript
from: string;
```

## MessagePayload.messageId

The message ID of a message.

<b>Signature:</b>

```typescript
messageId: string;
```

## MessagePayload.notification

Display notification details. Details are sent through the [Send API](https://firebase.google.com/docs/reference/fcm/rest/v1/projects.messages#notification)<!-- -->.

<b>Signature:</b>

```typescript
notification?: NotificationPayload;
```
