Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# PerformanceTrace interface
The interface representing a `Trace`<!-- -->.

<b>Signature:</b>

```typescript
export interface PerformanceTrace 
```

## Methods

|  Method | Description |
|  --- | --- |
|  [getAttribute(attr)](./performance.performancetrace.md#performancetracegetattribute) | Retrieves the value which a custom attribute is set to. |
|  [getAttributes()](./performance.performancetrace.md#performancetracegetattributes) | Returns a map of all custom attributes of a trace instance. |
|  [getMetric(metricName)](./performance.performancetrace.md#performancetracegetmetric) | Returns the value of the custom metric by that name. If a custom metric with that name does not exist will return zero. |
|  [incrementMetric(metricName, num)](./performance.performancetrace.md#performancetraceincrementmetric) | Adds to the value of a custom metric. If a custom metric with the provided name does not exist, it creates one with that name and the value equal to the given number. The value will be floored down to an integer. |
|  [putAttribute(attr, value)](./performance.performancetrace.md#performancetraceputattribute) | Set a custom attribute of a trace to a certain value. |
|  [putMetric(metricName, num)](./performance.performancetrace.md#performancetraceputmetric) | Sets the value of the specified custom metric to the given number regardless of whether a metric with that name already exists on the trace instance or not. The value will be floored down to an integer. |
|  [record(startTime, duration, options)](./performance.performancetrace.md#performancetracerecord) | Records a trace from given parameters. This provides a direct way to use trace without a need to start/stop. This is useful for use cases in which the trace cannot directly be used (e.g. if the duration was captured before the Performance SDK was loaded). |
|  [removeAttribute(attr)](./performance.performancetrace.md#performancetraceremoveattribute) | Removes the specified custom attribute from a trace instance. |
|  [start()](./performance.performancetrace.md#performancetracestart) | Starts the timing for the trace instance. |
|  [stop()](./performance.performancetrace.md#performancetracestop) | Stops the timing of the trace instance and logs the data of the instance. |

## PerformanceTrace.getAttribute()

Retrieves the value which a custom attribute is set to.

<b>Signature:</b>

```typescript
getAttribute(attr: string): string | undefined;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  attr | string | Name of the custom attribute. |

<b>Returns:</b>

string \| undefined

## PerformanceTrace.getAttributes()

Returns a map of all custom attributes of a trace instance.

<b>Signature:</b>

```typescript
getAttributes(): {
        [key: string]: string;
    };
```
<b>Returns:</b>

{ \[key: string\]: string; }

## PerformanceTrace.getMetric()

Returns the value of the custom metric by that name. If a custom metric with that name does not exist will return zero.

<b>Signature:</b>

```typescript
getMetric(metricName: string): number;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  metricName | string | Name of the custom metric. |

<b>Returns:</b>

number

## PerformanceTrace.incrementMetric()

Adds to the value of a custom metric. If a custom metric with the provided name does not exist, it creates one with that name and the value equal to the given number. The value will be floored down to an integer.

<b>Signature:</b>

```typescript
incrementMetric(metricName: string, num?: number): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  metricName | string | The name of the custom metric. |
|  num | number | The number to be added to the value of the custom metric. If not provided, it uses a default value of one. |

<b>Returns:</b>

void

## PerformanceTrace.putAttribute()

Set a custom attribute of a trace to a certain value.

<b>Signature:</b>

```typescript
putAttribute(attr: string, value: string): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  attr | string | Name of the custom attribute. |
|  value | string | Value of the custom attribute. |

<b>Returns:</b>

void

## PerformanceTrace.putMetric()

Sets the value of the specified custom metric to the given number regardless of whether a metric with that name already exists on the trace instance or not. The value will be floored down to an integer.

<b>Signature:</b>

```typescript
putMetric(metricName: string, num: number): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  metricName | string | Name of the custom metric. |
|  num | number | Value to of the custom metric. |

<b>Returns:</b>

void

## PerformanceTrace.record()

Records a trace from given parameters. This provides a direct way to use trace without a need to start/stop. This is useful for use cases in which the trace cannot directly be used (e.g. if the duration was captured before the Performance SDK was loaded).

<b>Signature:</b>

```typescript
record(startTime: number, duration: number, options?: {
        metrics?: {
            [key: string]: number;
        };
        attributes?: {
            [key: string]: string;
        };
    }): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  startTime | number | trace start time since epoch in millisec. |
|  duration | number | The duration of the trace in millisec. |
|  options | { metrics?: { \[key: string\]: number; }; attributes?: { \[key: string\]: string; }; } | An object which can optionally hold maps of custom metrics and custom attributes. |

<b>Returns:</b>

void

## PerformanceTrace.removeAttribute()

Removes the specified custom attribute from a trace instance.

<b>Signature:</b>

```typescript
removeAttribute(attr: string): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  attr | string | Name of the custom attribute. |

<b>Returns:</b>

void

## PerformanceTrace.start()

Starts the timing for the trace instance.

<b>Signature:</b>

```typescript
start(): void;
```
<b>Returns:</b>

void

## PerformanceTrace.stop()

Stops the timing of the trace instance and logs the data of the instance.

<b>Signature:</b>

```typescript
stop(): void;
```
<b>Returns:</b>

void

