Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# FetchResponse interface
Defines a successful response (200 or 304).

<p>Modeled after the native `Response` interface, but simplified for Remote Config's use case.

<b>Signature:</b>

```typescript
export interface FetchResponse 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [config](./remote-config.fetchresponse.md#fetchresponseconfig) | [FirebaseRemoteConfigObject](./remote-config.firebaseremoteconfigobject.md#firebaseremoteconfigobject_interface) | Defines the map of parameters returned as "entries" in the fetch response body.<p>Only defined for 200 responses. |
|  [eTag](./remote-config.fetchresponse.md#fetchresponseetag) | string | Defines the ETag response header value.<p>Only defined for 200 and 304 responses. |
|  [status](./remote-config.fetchresponse.md#fetchresponsestatus) | number | The HTTP status, which is useful for differentiating success responses with data from those without.<p>The Remote Config client is modeled after the native <code>Fetch</code> interface, so HTTP status is first-class.<p>Disambiguation: the fetch response returns a legacy "state" value that is redundant with the HTTP status code. The former is normalized into the latter. |
|  [templateVersion](./remote-config.fetchresponse.md#fetchresponsetemplateversion) | number | The version number of the config template fetched from the server. |

## FetchResponse.config

Defines the map of parameters returned as "entries" in the fetch response body.

<p>Only defined for 200 responses.

<b>Signature:</b>

```typescript
config?: FirebaseRemoteConfigObject;
```

## FetchResponse.eTag

Defines the ETag response header value.

<p>Only defined for 200 and 304 responses.

<b>Signature:</b>

```typescript
eTag?: string;
```

## FetchResponse.status

The HTTP status, which is useful for differentiating success responses with data from those without.

<p>The Remote Config client is modeled after the native `Fetch` interface, so HTTP status is first-class.

<p>Disambiguation: the fetch response returns a legacy "state" value that is redundant with the HTTP status code. The former is normalized into the latter.

<b>Signature:</b>

```typescript
status: number;
```

## FetchResponse.templateVersion

The version number of the config template fetched from the server.

<b>Signature:</b>

```typescript
templateVersion?: number;
```
