Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# remote-config package
The Firebase Remote Config Web SDK. This SDK does not work in a Node.js environment.

## Functions

|  Function | Description |
|  --- | --- |
|  <b>function(app, ...)</b> |
|  [getRemoteConfig(app, options)](./remote-config.md#getremoteconfig_61d368f) |  |
|  <b>function(remoteConfig, ...)</b> |
|  [activate(remoteConfig)](./remote-config.md#activate_722a192) | Makes the last fetched config available to the getters. |
|  [ensureInitialized(remoteConfig)](./remote-config.md#ensureinitialized_722a192) | Ensures the last activated config are available to the getters. |
|  [fetchAndActivate(remoteConfig)](./remote-config.md#fetchandactivate_722a192) | Performs fetch and activate operations, as a convenience. |
|  [fetchConfig(remoteConfig)](./remote-config.md#fetchconfig_722a192) | Fetches and caches configuration from the Remote Config service. |
|  [getAll(remoteConfig)](./remote-config.md#getall_722a192) | Gets all config. |
|  [getBoolean(remoteConfig, key)](./remote-config.md#getboolean_476c09f) | Gets the value for the given key as a boolean.<!-- -->Convenience method for calling <code>remoteConfig.getValue(key).asBoolean()</code>. |
|  [getNumber(remoteConfig, key)](./remote-config.md#getnumber_476c09f) | Gets the value for the given key as a number.<!-- -->Convenience method for calling <code>remoteConfig.getValue(key).asNumber()</code>. |
|  [getString(remoteConfig, key)](./remote-config.md#getstring_476c09f) | Gets the value for the given key as a string. Convenience method for calling <code>remoteConfig.getValue(key).asString()</code>. |
|  [getValue(remoteConfig, key)](./remote-config.md#getvalue_476c09f) | Gets the [Value](./remote-config.value.md#value_interface) for the given key. |
|  [onConfigUpdate(remoteConfig, observer)](./remote-config.md#onconfigupdate_8b13b26) | Starts listening for real-time config updates from the Remote Config backend and automatically fetches updates from the Remote Config backend when they are available. |
|  [setCustomSignals(remoteConfig, customSignals)](./remote-config.md#setcustomsignals_aeeb95e) | Sets the custom signals for the app instance. |
|  [setLogLevel(remoteConfig, logLevel)](./remote-config.md#setloglevel_039a45b) | Defines the log level to use. |
|  <b>function()</b> |
|  [isSupported()](./remote-config.md#issupported) | This method provides two different checks:<!-- -->1. Check if IndexedDB exists in the browser environment. 2. Check if the current browser context allows IndexedDB <code>open()</code> calls. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [ConfigUpdate](./remote-config.configupdate.md#configupdate_interface) | Contains information about which keys have been updated. |
|  [ConfigUpdateObserver](./remote-config.configupdateobserver.md#configupdateobserver_interface) | Observer interface for receiving real-time Remote Config update notifications.<!-- -->NOTE: Although an <code>complete</code> callback can be provided, it will never be called because the ConfigUpdate stream is never-ending. |
|  [CustomSignals](./remote-config.customsignals.md#customsignals_interface) | Defines the type for representing custom signals and their values.<p>The values in CustomSignals must be one of the following types:<ul> <li><code>string</code> <li><code>number</code> <li><code>null</code> </ul> |
|  [FetchResponse](./remote-config.fetchresponse.md#fetchresponse_interface) | Defines a successful response (200 or 304).<p>Modeled after the native <code>Response</code> interface, but simplified for Remote Config's use case. |
|  [FirebaseRemoteConfigObject](./remote-config.firebaseremoteconfigobject.md#firebaseremoteconfigobject_interface) | Defines a self-descriptive reference for config key-value pairs. |
|  [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The Firebase Remote Config service interface. |
|  [RemoteConfigOptions](./remote-config.remoteconfigoptions.md#remoteconfigoptions_interface) | Options for Remote Config initialization. |
|  [RemoteConfigSettings](./remote-config.remoteconfigsettings.md#remoteconfigsettings_interface) | Defines configuration options for the Remote Config SDK. |
|  [Value](./remote-config.value.md#value_interface) | Wraps a value with metadata and type-safe getters. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [FetchStatus](./remote-config.md#fetchstatus) | Summarizes the outcome of the last attempt to fetch config from the Firebase Remote Config server.<ul> <li>"no-fetch-yet" indicates the [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance has not yet attempted to fetch config, or that SDK initialization is incomplete.</li> <li>"success" indicates the last attempt succeeded.</li> <li>"failure" indicates the last attempt failed.</li> <li>"throttle" indicates the last attempt was rate-limited.</li> </ul> |
|  [FetchType](./remote-config.md#fetchtype) | Indicates the type of fetch request.<ul> <li>"BASE" indicates a standard fetch request.</li> <li>"REALTIME" indicates a fetch request triggered by a real-time update.</li> </ul> |
|  [LogLevel](./remote-config.md#loglevel) | Defines levels of Remote Config logging. |
|  [Unsubscribe](./remote-config.md#unsubscribe) | A function that unsubscribes from a real-time event stream. |
|  [ValueSource](./remote-config.md#valuesource) | Indicates the source of a value.<ul> <li>"static" indicates the value was defined by a static constant.</li> <li>"default" indicates the value was defined by default config.</li> <li>"remote" indicates the value was defined by fetched config.</li> </ul> |

## function(app, ...)

### getRemoteConfig(app, options) {:#getremoteconfig_61d368f}

<b>Signature:</b>

```typescript
export declare function getRemoteConfig(app?: FirebaseApp, options?: RemoteConfigOptions): RemoteConfig;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | The [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) instance. |
|  options | [RemoteConfigOptions](./remote-config.remoteconfigoptions.md#remoteconfigoptions_interface) | Optional. The [RemoteConfigOptions](./remote-config.remoteconfigoptions.md#remoteconfigoptions_interface) with which to instantiate the Remote Config instance. |

<b>Returns:</b>

[RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface)

A [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance.

## function(remoteConfig, ...)

### activate(remoteConfig) {:#activate_722a192}

Makes the last fetched config available to the getters.

<b>Signature:</b>

```typescript
export declare function activate(remoteConfig: RemoteConfig): Promise<boolean>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |

<b>Returns:</b>

Promise&lt;boolean&gt;

A `Promise` which resolves to true if the current call activated the fetched configs. If the fetched configs were already activated, the `Promise` will resolve to false.

### ensureInitialized(remoteConfig) {:#ensureinitialized_722a192}

Ensures the last activated config are available to the getters.

<b>Signature:</b>

```typescript
export declare function ensureInitialized(remoteConfig: RemoteConfig): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |

<b>Returns:</b>

Promise&lt;void&gt;

A `Promise` that resolves when the last activated config is available to the getters.

### fetchAndActivate(remoteConfig) {:#fetchandactivate_722a192}

Performs fetch and activate operations, as a convenience.

<b>Signature:</b>

```typescript
export declare function fetchAndActivate(remoteConfig: RemoteConfig): Promise<boolean>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |

<b>Returns:</b>

Promise&lt;boolean&gt;

A `Promise` which resolves to true if the current call activated the fetched configs. If the fetched configs were already activated, the `Promise` will resolve to false.

### fetchConfig(remoteConfig) {:#fetchconfig_722a192}

Fetches and caches configuration from the Remote Config service.

<b>Signature:</b>

```typescript
export declare function fetchConfig(remoteConfig: RemoteConfig): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |

<b>Returns:</b>

Promise&lt;void&gt;

### getAll(remoteConfig) {:#getall_722a192}

Gets all config.

<b>Signature:</b>

```typescript
export declare function getAll(remoteConfig: RemoteConfig): Record<string, Value>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |

<b>Returns:</b>

Record&lt;string, [Value](./remote-config.value.md#value_interface)<!-- -->&gt;

All config.

### getBoolean(remoteConfig, key) {:#getboolean_476c09f}

Gets the value for the given key as a boolean.

Convenience method for calling <code>remoteConfig.getValue(key).asBoolean()</code>.

<b>Signature:</b>

```typescript
export declare function getBoolean(remoteConfig: RemoteConfig, key: string): boolean;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |
|  key | string | The name of the parameter. |

<b>Returns:</b>

boolean

The value for the given key as a boolean.

### getNumber(remoteConfig, key) {:#getnumber_476c09f}

Gets the value for the given key as a number.

Convenience method for calling <code>remoteConfig.getValue(key).asNumber()</code>.

<b>Signature:</b>

```typescript
export declare function getNumber(remoteConfig: RemoteConfig, key: string): number;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |
|  key | string | The name of the parameter. |

<b>Returns:</b>

number

The value for the given key as a number.

### getString(remoteConfig, key) {:#getstring_476c09f}

Gets the value for the given key as a string. Convenience method for calling <code>remoteConfig.getValue(key).asString()</code>.

<b>Signature:</b>

```typescript
export declare function getString(remoteConfig: RemoteConfig, key: string): string;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |
|  key | string | The name of the parameter. |

<b>Returns:</b>

string

The value for the given key as a string.

### getValue(remoteConfig, key) {:#getvalue_476c09f}

Gets the [Value](./remote-config.value.md#value_interface) for the given key.

<b>Signature:</b>

```typescript
export declare function getValue(remoteConfig: RemoteConfig, key: string): Value;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |
|  key | string | The name of the parameter. |

<b>Returns:</b>

[Value](./remote-config.value.md#value_interface)

The value for the given key.

### onConfigUpdate(remoteConfig, observer) {:#onconfigupdate_8b13b26}

Starts listening for real-time config updates from the Remote Config backend and automatically fetches updates from the Remote Config backend when they are available.

If a connection to the Remote Config backend is not already open, calling this method will open it. Multiple listeners can be added by calling this method again, but subsequent calls re-use the same connection to the backend.

<b>Signature:</b>

```typescript
export declare function onConfigUpdate(remoteConfig: RemoteConfig, observer: ConfigUpdateObserver): Unsubscribe;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |
|  observer | [ConfigUpdateObserver](./remote-config.configupdateobserver.md#configupdateobserver_interface) | The [ConfigUpdateObserver](./remote-config.configupdateobserver.md#configupdateobserver_interface) to be notified of config updates. |

<b>Returns:</b>

[Unsubscribe](./remote-config.md#unsubscribe)

An [Unsubscribe](./remote-config.md#unsubscribe) function to remove the listener.

### setCustomSignals(remoteConfig, customSignals) {:#setcustomsignals_aeeb95e}

Sets the custom signals for the app instance.

<b>Signature:</b>

```typescript
export declare function setCustomSignals(remoteConfig: RemoteConfig, customSignals: CustomSignals): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |
|  customSignals | [CustomSignals](./remote-config.customsignals.md#customsignals_interface) | Map (key, value) of the custom signals to be set for the app instance. If a key already exists, the value is overwritten. Setting the value of a custom signal to null unsets the signal. The signals will be persisted locally on the client. |

<b>Returns:</b>

Promise&lt;void&gt;

### setLogLevel(remoteConfig, logLevel) {:#setloglevel_039a45b}

Defines the log level to use.

<b>Signature:</b>

```typescript
export declare function setLogLevel(remoteConfig: RemoteConfig, logLevel: RemoteConfigLogLevel): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  remoteConfig | [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) | The [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance. |
|  logLevel | [RemoteConfigLogLevel](./remote-config.md#loglevel) | The log level to set. |

<b>Returns:</b>

void

## function()

### isSupported() {:#issupported}

This method provides two different checks:

1. Check if IndexedDB exists in the browser environment. 2. Check if the current browser context allows IndexedDB `open()` calls.

<b>Signature:</b>

```typescript
export declare function isSupported(): Promise<boolean>;
```
<b>Returns:</b>

Promise&lt;boolean&gt;

A `Promise` which resolves to true if a [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance can be initialized in this environment, or false if it cannot.

## FetchStatus

Summarizes the outcome of the last attempt to fetch config from the Firebase Remote Config server.

<ul> <li>"no-fetch-yet" indicates the [RemoteConfig](./remote-config.remoteconfig.md#remoteconfig_interface) instance has not yet attempted to fetch config, or that SDK initialization is incomplete.</li> <li>"success" indicates the last attempt succeeded.</li> <li>"failure" indicates the last attempt failed.</li> <li>"throttle" indicates the last attempt was rate-limited.</li> </ul>

<b>Signature:</b>

```typescript
export type FetchStatus = 'no-fetch-yet' | 'success' | 'failure' | 'throttle';
```

## FetchType

Indicates the type of fetch request.

<ul> <li>"BASE" indicates a standard fetch request.</li> <li>"REALTIME" indicates a fetch request triggered by a real-time update.</li> </ul>

<b>Signature:</b>

```typescript
export type FetchType = 'BASE' | 'REALTIME';
```

## LogLevel

Defines levels of Remote Config logging.

<b>Signature:</b>

```typescript
export type LogLevel = 'debug' | 'error' | 'silent';
```

## Unsubscribe

A function that unsubscribes from a real-time event stream.

<b>Signature:</b>

```typescript
export type Unsubscribe = () => void;
```

## ValueSource

Indicates the source of a value.

<ul> <li>"static" indicates the value was defined by a static constant.</li> <li>"default" indicates the value was defined by default config.</li> <li>"remote" indicates the value was defined by fetched config.</li> </ul>

<b>Signature:</b>

```typescript
export type ValueSource = 'static' | 'default' | 'remote';
```
