Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# FullMetadata interface
The full set of object metadata, including read-only properties.

<b>Signature:</b>

```typescript
export interface FullMetadata extends UploadMetadata 
```
<b>Extends:</b> [UploadMetadata](./storage.uploadmetadata.md#uploadmetadata_interface)

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [bucket](./storage.fullmetadata.md#fullmetadatabucket) | string | The bucket this object is contained in. |
|  [downloadTokens](./storage.fullmetadata.md#fullmetadatadownloadtokens) | string\[\] \| undefined | Tokens to allow access to the download URL. |
|  [fullPath](./storage.fullmetadata.md#fullmetadatafullpath) | string | The full path of this object. |
|  [generation](./storage.fullmetadata.md#fullmetadatageneration) | string | The object's generation. [https://cloud.google.com/storage/docs/metadata\#generation-number](https://cloud.google.com/storage/docs/metadata#generation-number) |
|  [metageneration](./storage.fullmetadata.md#fullmetadatametageneration) | string | The object's metageneration. [https://cloud.google.com/storage/docs/metadata\#generation-number](https://cloud.google.com/storage/docs/metadata#generation-number) |
|  [name](./storage.fullmetadata.md#fullmetadataname) | string | The short name of this object, which is the last component of the full path. For example, if fullPath is 'full/path/image.png', name is 'image.png'. |
|  [ref](./storage.fullmetadata.md#fullmetadataref) | [StorageReference](./storage.storagereference.md#storagereference_interface) \| undefined | <code>StorageReference</code> associated with this upload. |
|  [size](./storage.fullmetadata.md#fullmetadatasize) | number | The size of this object, in bytes. |
|  [timeCreated](./storage.fullmetadata.md#fullmetadatatimecreated) | string | A date string representing when this object was created. |
|  [updated](./storage.fullmetadata.md#fullmetadataupdated) | string | A date string representing when this object was last updated. |

## FullMetadata.bucket

The bucket this object is contained in.

<b>Signature:</b>

```typescript
bucket: string;
```

## FullMetadata.downloadTokens

Tokens to allow access to the download URL.

<b>Signature:</b>

```typescript
downloadTokens: string[] | undefined;
```

## FullMetadata.fullPath

The full path of this object.

<b>Signature:</b>

```typescript
fullPath: string;
```

## FullMetadata.generation

The object's generation. [https://cloud.google.com/storage/docs/metadata\#generation-number](https://cloud.google.com/storage/docs/metadata#generation-number)

<b>Signature:</b>

```typescript
generation: string;
```

## FullMetadata.metageneration

The object's metageneration. [https://cloud.google.com/storage/docs/metadata\#generation-number](https://cloud.google.com/storage/docs/metadata#generation-number)

<b>Signature:</b>

```typescript
metageneration: string;
```

## FullMetadata.name

The short name of this object, which is the last component of the full path. For example, if fullPath is 'full/path/image.png', name is 'image.png'.

<b>Signature:</b>

```typescript
name: string;
```

## FullMetadata.ref

`StorageReference` associated with this upload.

<b>Signature:</b>

```typescript
ref?: StorageReference | undefined;
```

## FullMetadata.size

The size of this object, in bytes.

<b>Signature:</b>

```typescript
size: number;
```

## FullMetadata.timeCreated

A date string representing when this object was created.

<b>Signature:</b>

```typescript
timeCreated: string;
```

## FullMetadata.updated

A date string representing when this object was last updated.

<b>Signature:</b>

```typescript
updated: string;
```
