Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# storage package
Cloud Storage for Firebase

## Functions

|  Function | Description |
|  --- | --- |
|  <b>function(app, ...)</b> |
|  [getStorage(app, bucketUrl)](./storage.md#getstorage_25f3a57) | Gets a [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) instance for the given Firebase app. |
|  <b>function(storage, ...)</b> |
|  [connectStorageEmulator(storage, host, port, options)](./storage.md#connectstorageemulator_e9039de) | Modify this [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) instance to communicate with the Cloud Storage emulator. |
|  [ref(storage, url)](./storage.md#ref_5672fc1) | Returns a [StorageReference](./storage.storagereference.md#storagereference_interface) for the given url. |
|  <b>function(ref, ...)</b> |
|  [deleteObject(ref)](./storage.md#deleteobject_30df0b2) | Deletes the object at this location. |
|  [getBlob(ref, maxDownloadSizeBytes)](./storage.md#getblob_1c7a935) | Downloads the data at the object's location. Returns an error if the object is not found.<!-- -->To use this functionality, you have to whitelist your app's origin in your Cloud Storage bucket. See also https://cloud.google.com/storage/docs/configuring-cors<!-- -->This API is not available in Node. |
|  [getBytes(ref, maxDownloadSizeBytes)](./storage.md#getbytes_1c7a935) | Downloads the data at the object's location. Returns an error if the object is not found.<!-- -->To use this functionality, you have to whitelist your app's origin in your Cloud Storage bucket. See also https://cloud.google.com/storage/docs/configuring-cors |
|  [getDownloadURL(ref)](./storage.md#getdownloadurl_30df0b2) | Returns the download URL for the given [StorageReference](./storage.storagereference.md#storagereference_interface)<!-- -->. |
|  [getMetadata(ref)](./storage.md#getmetadata_30df0b2) | A <code>Promise</code> that resolves with the metadata for this object. If this object doesn't exist or metadata cannot be retrieved, the promise is rejected. |
|  [getStream(ref, maxDownloadSizeBytes)](./storage.md#getstream_1c7a935) | Downloads the data at the object's location. Raises an error event if the object is not found.<!-- -->This API is only available in Node. |
|  [list(ref, options)](./storage.md#list_36af757) | List items (files) and prefixes (folders) under this storage reference.<!-- -->List API is only available for Firebase Rules Version 2.<!-- -->GCS is a key-blob store. Firebase Storage imposes the semantic of '/' delimited folder structure. Refer to GCS's List API if you want to learn more.<!-- -->To adhere to Firebase Rules's Semantics, Firebase Storage does not support objects whose paths end with "/" or contain two consecutive "/"s. Firebase Storage List API will filter these unsupported objects. list() may fail if there are too many unsupported objects in the bucket. |
|  [listAll(ref)](./storage.md#listall_30df0b2) | List all items (files) and prefixes (folders) under this storage reference.<!-- -->This is a helper method for calling list() repeatedly until there are no more results. The default pagination size is 1000.<!-- -->Note: The results may not be consistent if objects are changed while this operation is running.<!-- -->Warning: <code>listAll</code> may potentially consume too many resources if there are too many results. |
|  [updateMetadata(ref, metadata)](./storage.md#updatemetadata_a634608) | Updates the metadata for this object. |
|  [uploadBytes(ref, data, metadata)](./storage.md#uploadbytes_02686b1) | Uploads data to this object's location. The upload is not resumable. |
|  [uploadBytesResumable(ref, data, metadata)](./storage.md#uploadbytesresumable_02686b1) | Uploads data to this object's location. The upload can be paused and resumed, and exposes progress updates. |
|  [uploadString(ref, value, format, metadata)](./storage.md#uploadstring_277829d) | Uploads a string to this object's location. The upload is not resumable. |
|  <b>function(storageOrRef, ...)</b> |
|  [ref(storageOrRef, path)](./storage.md#ref_41be95d) | Returns a [StorageReference](./storage.storagereference.md#storagereference_interface) for the given path in the default bucket. |

## Classes

|  Class | Description |
|  --- | --- |
|  [StorageError](./storage.storageerror.md#storageerror_class) | An error returned by the Firebase Storage SDK. |

## Enumerations

|  Enumeration | Description |
|  --- | --- |
|  [StorageErrorCode](./storage.md#storageerrorcode) | Error codes that can be attached to <code>StorageError</code> objects. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) | A Firebase Storage instance. |
|  [FullMetadata](./storage.fullmetadata.md#fullmetadata_interface) | The full set of object metadata, including read-only properties. |
|  [ListOptions](./storage.listoptions.md#listoptions_interface) | The options <code>list()</code> accepts. |
|  [ListResult](./storage.listresult.md#listresult_interface) | Result returned by list(). |
|  [SettableMetadata](./storage.settablemetadata.md#settablemetadata_interface) | Object metadata that can be set at any time. |
|  [StorageObserver](./storage.storageobserver.md#storageobserver_interface) | A stream observer for Firebase Storage. |
|  [StorageReference](./storage.storagereference.md#storagereference_interface) | Represents a reference to a Google Cloud Storage object. Developers can upload, download, and delete objects, as well as get/set object metadata. |
|  [UploadMetadata](./storage.uploadmetadata.md#uploadmetadata_interface) | Object metadata that can be set at upload. |
|  [UploadResult](./storage.uploadresult.md#uploadresult_interface) | Result returned from a non-resumable upload. |
|  [UploadTask](./storage.uploadtask.md#uploadtask_interface) | Represents the process of uploading an object. Allows you to monitor and manage the upload. |
|  [UploadTaskSnapshot](./storage.uploadtasksnapshot.md#uploadtasksnapshot_interface) | Holds data about the current state of the upload task. |

## Variables

|  Variable | Description |
|  --- | --- |
|  [StringFormat](./storage.md#stringformat) | An enumeration of the possible string formats for upload. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [StringFormat](./storage.md#stringformat) | An enumeration of the possible string formats for upload. |
|  [TaskEvent](./storage.md#taskevent) | An event that is triggered on a task. |
|  [TaskState](./storage.md#taskstate) | Represents the current state of a running upload. |

## function(app, ...)

### getStorage(app, bucketUrl) {:#getstorage_25f3a57}

Gets a [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) instance for the given Firebase app.

<b>Signature:</b>

```typescript
export declare function getStorage(app?: FirebaseApp, bucketUrl?: string): FirebaseStorage;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | Firebase app to get [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) instance for. |
|  bucketUrl | string | The gs:// url to your Firebase Storage Bucket. If not passed, uses the app's default Storage Bucket. |

<b>Returns:</b>

[FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface)

A [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) instance.

## function(storage, ...)

### connectStorageEmulator(storage, host, port, options) {:#connectstorageemulator_e9039de}

Modify this [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) instance to communicate with the Cloud Storage emulator.

<b>Signature:</b>

```typescript
export declare function connectStorageEmulator(storage: FirebaseStorage, host: string, port: number, options?: {
    mockUserToken?: EmulatorMockTokenOptions | string;
}): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  storage | [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) | The [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) instance |
|  host | string | The emulator host (ex: localhost) |
|  port | number | The emulator port (ex: 5001) |
|  options | { mockUserToken?: [EmulatorMockTokenOptions](./util.md#emulatormocktokenoptions) \| string; } | Emulator options. <code>options.mockUserToken</code> is the mock auth token to use for unit testing Security Rules. |

<b>Returns:</b>

void

### ref(storage, url) {:#ref_5672fc1}

Returns a [StorageReference](./storage.storagereference.md#storagereference_interface) for the given url.

<b>Signature:</b>

```typescript
export declare function ref(storage: FirebaseStorage, url?: string): StorageReference;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  storage | [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) | [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) instance. |
|  url | string | URL. If empty, returns root reference. |

<b>Returns:</b>

[StorageReference](./storage.storagereference.md#storagereference_interface)

## function(ref, ...)

### deleteObject(ref) {:#deleteobject_30df0b2}

Deletes the object at this location.

<b>Signature:</b>

```typescript
export declare function deleteObject(ref: StorageReference): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | [StorageReference](./storage.storagereference.md#storagereference_interface) for object to delete. |

<b>Returns:</b>

Promise&lt;void&gt;

A `Promise` that resolves if the deletion succeeds.

### getBlob(ref, maxDownloadSizeBytes) {:#getblob_1c7a935}

Downloads the data at the object's location. Returns an error if the object is not found.

To use this functionality, you have to whitelist your app's origin in your Cloud Storage bucket. See also https://cloud.google.com/storage/docs/configuring-cors

This API is not available in Node.

<b>Signature:</b>

```typescript
export declare function getBlob(ref: StorageReference, maxDownloadSizeBytes?: number): Promise<Blob>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | StorageReference where data should be downloaded. |
|  maxDownloadSizeBytes | number | If set, the maximum allowed size in bytes to retrieve. |

<b>Returns:</b>

Promise&lt;Blob&gt;

A Promise that resolves with a Blob containing the object's bytes

### getBytes(ref, maxDownloadSizeBytes) {:#getbytes_1c7a935}

Downloads the data at the object's location. Returns an error if the object is not found.

To use this functionality, you have to whitelist your app's origin in your Cloud Storage bucket. See also https://cloud.google.com/storage/docs/configuring-cors

<b>Signature:</b>

```typescript
export declare function getBytes(ref: StorageReference, maxDownloadSizeBytes?: number): Promise<ArrayBuffer>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | StorageReference where data should be downloaded. |
|  maxDownloadSizeBytes | number | If set, the maximum allowed size in bytes to retrieve. |

<b>Returns:</b>

Promise&lt;ArrayBuffer&gt;

A Promise containing the object's bytes

### getDownloadURL(ref) {:#getdownloadurl_30df0b2}

Returns the download URL for the given [StorageReference](./storage.storagereference.md#storagereference_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare function getDownloadURL(ref: StorageReference): Promise<string>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | [StorageReference](./storage.storagereference.md#storagereference_interface) to get the download URL for. |

<b>Returns:</b>

Promise&lt;string&gt;

A `Promise` that resolves with the download URL for this object.

### getMetadata(ref) {:#getmetadata_30df0b2}

A `Promise` that resolves with the metadata for this object. If this object doesn't exist or metadata cannot be retrieved, the promise is rejected.

<b>Signature:</b>

```typescript
export declare function getMetadata(ref: StorageReference): Promise<FullMetadata>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | [StorageReference](./storage.storagereference.md#storagereference_interface) to get metadata from. |

<b>Returns:</b>

Promise&lt;[FullMetadata](./storage.fullmetadata.md#fullmetadata_interface)<!-- -->&gt;

### getStream(ref, maxDownloadSizeBytes) {:#getstream_1c7a935}

Downloads the data at the object's location. Raises an error event if the object is not found.

This API is only available in Node.

<b>Signature:</b>

```typescript
export declare function getStream(ref: StorageReference, maxDownloadSizeBytes?: number): ReadableStream;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | StorageReference where data should be downloaded. |
|  maxDownloadSizeBytes | number | If set, the maximum allowed size in bytes to retrieve. |

<b>Returns:</b>

ReadableStream

A stream with the object's data as bytes

### list(ref, options) {:#list_36af757}

List items (files) and prefixes (folders) under this storage reference.

List API is only available for Firebase Rules Version 2.

GCS is a key-blob store. Firebase Storage imposes the semantic of '/' delimited folder structure. Refer to GCS's List API if you want to learn more.

To adhere to Firebase Rules's Semantics, Firebase Storage does not support objects whose paths end with "/" or contain two consecutive "/"s. Firebase Storage List API will filter these unsupported objects. list() may fail if there are too many unsupported objects in the bucket.

<b>Signature:</b>

```typescript
export declare function list(ref: StorageReference, options?: ListOptions): Promise<ListResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | [StorageReference](./storage.storagereference.md#storagereference_interface) to get list from. |
|  options | [ListOptions](./storage.listoptions.md#listoptions_interface) | See [ListOptions](./storage.listoptions.md#listoptions_interface) for details. |

<b>Returns:</b>

Promise&lt;[ListResult](./storage.listresult.md#listresult_interface)<!-- -->&gt;

A `Promise` that resolves with the items and prefixes. `prefixes` contains references to sub-folders and `items` contains references to objects in this folder. `nextPageToken` can be used to get the rest of the results.

### listAll(ref) {:#listall_30df0b2}

List all items (files) and prefixes (folders) under this storage reference.

This is a helper method for calling list() repeatedly until there are no more results. The default pagination size is 1000.

Note: The results may not be consistent if objects are changed while this operation is running.

Warning: `listAll` may potentially consume too many resources if there are too many results.

<b>Signature:</b>

```typescript
export declare function listAll(ref: StorageReference): Promise<ListResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | [StorageReference](./storage.storagereference.md#storagereference_interface) to get list from. |

<b>Returns:</b>

Promise&lt;[ListResult](./storage.listresult.md#listresult_interface)<!-- -->&gt;

A `Promise` that resolves with all the items and prefixes under the current storage reference. `prefixes` contains references to sub-directories and `items` contains references to objects in this folder. `nextPageToken` is never returned.

### updateMetadata(ref, metadata) {:#updatemetadata_a634608}

Updates the metadata for this object.

<b>Signature:</b>

```typescript
export declare function updateMetadata(ref: StorageReference, metadata: SettableMetadata): Promise<FullMetadata>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | [StorageReference](./storage.storagereference.md#storagereference_interface) to update metadata for. |
|  metadata | [SettableMetadata](./storage.settablemetadata.md#settablemetadata_interface) | The new metadata for the object. Only values that have been explicitly set will be changed. Explicitly setting a value to null will remove the metadata. |

<b>Returns:</b>

Promise&lt;[FullMetadata](./storage.fullmetadata.md#fullmetadata_interface)<!-- -->&gt;

A `Promise` that resolves with the new metadata for this object.

### uploadBytes(ref, data, metadata) {:#uploadbytes_02686b1}

Uploads data to this object's location. The upload is not resumable.

<b>Signature:</b>

```typescript
export declare function uploadBytes(ref: StorageReference, data: Blob | Uint8Array | ArrayBuffer, metadata?: UploadMetadata): Promise<UploadResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | [StorageReference](./storage.storagereference.md#storagereference_interface) where data should be uploaded. |
|  data | Blob \| Uint8Array \| ArrayBuffer | The data to upload. |
|  metadata | [UploadMetadata](./storage.uploadmetadata.md#uploadmetadata_interface) | Metadata for the data to upload. |

<b>Returns:</b>

Promise&lt;[UploadResult](./storage.uploadresult.md#uploadresult_interface)<!-- -->&gt;

A Promise containing an UploadResult

### uploadBytesResumable(ref, data, metadata) {:#uploadbytesresumable_02686b1}

Uploads data to this object's location. The upload can be paused and resumed, and exposes progress updates.

<b>Signature:</b>

```typescript
export declare function uploadBytesResumable(ref: StorageReference, data: Blob | Uint8Array | ArrayBuffer, metadata?: UploadMetadata): UploadTask;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | [StorageReference](./storage.storagereference.md#storagereference_interface) where data should be uploaded. |
|  data | Blob \| Uint8Array \| ArrayBuffer | The data to upload. |
|  metadata | [UploadMetadata](./storage.uploadmetadata.md#uploadmetadata_interface) | Metadata for the data to upload. |

<b>Returns:</b>

[UploadTask](./storage.uploadtask.md#uploadtask_interface)

An UploadTask

### uploadString(ref, value, format, metadata) {:#uploadstring_277829d}

Uploads a string to this object's location. The upload is not resumable.

<b>Signature:</b>

```typescript
export declare function uploadString(ref: StorageReference, value: string, format?: StringFormat, metadata?: UploadMetadata): Promise<UploadResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ref | [StorageReference](./storage.storagereference.md#storagereference_interface) | [StorageReference](./storage.storagereference.md#storagereference_interface) where string should be uploaded. |
|  value | string | The string to upload. |
|  format | [StringFormat](./storage.md#stringformat) | The format of the string to upload. |
|  metadata | [UploadMetadata](./storage.uploadmetadata.md#uploadmetadata_interface) | Metadata for the string to upload. |

<b>Returns:</b>

Promise&lt;[UploadResult](./storage.uploadresult.md#uploadresult_interface)<!-- -->&gt;

A Promise containing an UploadResult

## function(storageOrRef, ...)

### ref(storageOrRef, path) {:#ref_41be95d}

Returns a [StorageReference](./storage.storagereference.md#storagereference_interface) for the given path in the default bucket.

<b>Signature:</b>

```typescript
export declare function ref(storageOrRef: FirebaseStorage | StorageReference, path?: string): StorageReference;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  storageOrRef | [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) \| [StorageReference](./storage.storagereference.md#storagereference_interface) | [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) or [StorageReference](./storage.storagereference.md#storagereference_interface)<!-- -->. |
|  path | string |  |

<b>Returns:</b>

[StorageReference](./storage.storagereference.md#storagereference_interface)

## StringFormat

An enumeration of the possible string formats for upload.

<b>Signature:</b>

```typescript
StringFormat: {
    readonly RAW: "raw";
    readonly BASE64: "base64";
    readonly BASE64URL: "base64url";
    readonly DATA_URL: "data_url";
}
```

## StringFormat

An enumeration of the possible string formats for upload.

<b>Signature:</b>

```typescript
export type StringFormat = (typeof StringFormat)[keyof typeof StringFormat];
```

## TaskEvent

An event that is triggered on a task.

<b>Signature:</b>

```typescript
export type TaskEvent = 'state_changed';
```

## TaskState

Represents the current state of a running upload.

<b>Signature:</b>

```typescript
export type TaskState = 'running' | 'paused' | 'success' | 'canceled' | 'error';
```

## StorageErrorCode

Error codes that can be attached to `StorageError` objects.

<b>Signature:</b>

```typescript
export declare enum StorageErrorCode 
```

## Enumeration Members

|  Member | Value | Description |
|  --- | --- | --- |
|  APP\_DELETED | <code>&quot;app-deleted&quot;</code> |  |
|  BUCKET\_NOT\_FOUND | <code>&quot;bucket-not-found&quot;</code> |  |
|  CANCELED | <code>&quot;canceled&quot;</code> |  |
|  CANNOT\_SLICE\_BLOB | <code>&quot;cannot-slice-blob&quot;</code> |  |
|  INTERNAL\_ERROR | <code>&quot;internal-error&quot;</code> |  |
|  INVALID\_ARGUMENT | <code>&quot;invalid-argument&quot;</code> |  |
|  INVALID\_ARGUMENT\_COUNT | <code>&quot;invalid-argument-count&quot;</code> |  |
|  INVALID\_CHECKSUM | <code>&quot;invalid-checksum&quot;</code> |  |
|  INVALID\_DEFAULT\_BUCKET | <code>&quot;invalid-default-bucket&quot;</code> |  |
|  INVALID\_EVENT\_NAME | <code>&quot;invalid-event-name&quot;</code> |  |
|  INVALID\_FORMAT | <code>&quot;invalid-format&quot;</code> |  |
|  INVALID\_ROOT\_OPERATION | <code>&quot;invalid-root-operation&quot;</code> |  |
|  INVALID\_URL | <code>&quot;invalid-url&quot;</code> |  |
|  NO\_DEFAULT\_BUCKET | <code>&quot;no-default-bucket&quot;</code> |  |
|  NO\_DOWNLOAD\_URL | <code>&quot;no-download-url&quot;</code> |  |
|  OBJECT\_NOT\_FOUND | <code>&quot;object-not-found&quot;</code> |  |
|  PROJECT\_NOT\_FOUND | <code>&quot;project-not-found&quot;</code> |  |
|  QUOTA\_EXCEEDED | <code>&quot;quota-exceeded&quot;</code> |  |
|  RETRY\_LIMIT\_EXCEEDED | <code>&quot;retry-limit-exceeded&quot;</code> |  |
|  SERVER\_FILE\_WRONG\_SIZE | <code>&quot;server-file-wrong-size&quot;</code> |  |
|  UNAUTHENTICATED | <code>&quot;unauthenticated&quot;</code> |  |
|  UNAUTHORIZED | <code>&quot;unauthorized&quot;</code> |  |
|  UNAUTHORIZED\_APP | <code>&quot;unauthorized-app&quot;</code> |  |
|  UNKNOWN | <code>&quot;unknown&quot;</code> |  |
|  UNSUPPORTED\_ENVIRONMENT | <code>&quot;unsupported-environment&quot;</code> |  |

