Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# StorageReference interface
Represents a reference to a Google Cloud Storage object. Developers can upload, download, and delete objects, as well as get/set object metadata.

<b>Signature:</b>

```typescript
export interface StorageReference 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [bucket](./storage.storagereference.md#storagereferencebucket) | string | The name of the bucket containing this reference's object. |
|  [fullPath](./storage.storagereference.md#storagereferencefullpath) | string | The full path of this object. |
|  [name](./storage.storagereference.md#storagereferencename) | string | The short name of this object, which is the last component of the full path. For example, if fullPath is 'full/path/image.png', name is 'image.png'. |
|  [parent](./storage.storagereference.md#storagereferenceparent) | [StorageReference](./storage.storagereference.md#storagereference_interface) \| null | A reference pointing to the parent location of this reference, or null if this reference is the root. |
|  [root](./storage.storagereference.md#storagereferenceroot) | [StorageReference](./storage.storagereference.md#storagereference_interface) | A reference to the root of this object's bucket. |
|  [storage](./storage.storagereference.md#storagereferencestorage) | [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) | The [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) instance associated with this reference. |

## Methods

|  Method | Description |
|  --- | --- |
|  [toString()](./storage.storagereference.md#storagereferencetostring) | Returns a gs:// URL for this object in the form <code>gs://&lt;bucket&gt;/&lt;path&gt;/&lt;to&gt;/&lt;object&gt;</code> |

## StorageReference.bucket

The name of the bucket containing this reference's object.

<b>Signature:</b>

```typescript
bucket: string;
```

## StorageReference.fullPath

The full path of this object.

<b>Signature:</b>

```typescript
fullPath: string;
```

## StorageReference.name

The short name of this object, which is the last component of the full path. For example, if fullPath is 'full/path/image.png', name is 'image.png'.

<b>Signature:</b>

```typescript
name: string;
```

## StorageReference.parent

A reference pointing to the parent location of this reference, or null if this reference is the root.

<b>Signature:</b>

```typescript
parent: StorageReference | null;
```

## StorageReference.root

A reference to the root of this object's bucket.

<b>Signature:</b>

```typescript
root: StorageReference;
```

## StorageReference.storage

The [FirebaseStorage](./storage.firebasestorage.md#firebasestorage_interface) instance associated with this reference.

<b>Signature:</b>

```typescript
storage: FirebaseStorage;
```

## StorageReference.toString()

Returns a gs:// URL for this object in the form `gs://<bucket>/<path>/<to>/<object>`

<b>Signature:</b>

```typescript
toString(): string;
```
<b>Returns:</b>

string

The gs:// URL.

