Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# UploadTask interface
Represents the process of uploading an object. Allows you to monitor and manage the upload.

<b>Signature:</b>

```typescript
export interface UploadTask 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [snapshot](./storage.uploadtask.md#uploadtasksnapshot) | [UploadTaskSnapshot](./storage.uploadtasksnapshot.md#uploadtasksnapshot_interface) | A snapshot of the current task state. |

## Methods

|  Method | Description |
|  --- | --- |
|  [cancel()](./storage.uploadtask.md#uploadtaskcancel) | Cancels a running task. Has no effect on a complete or failed task. |
|  [catch(onRejected)](./storage.uploadtask.md#uploadtaskcatch) | Equivalent to calling <code>then(null, onRejected)</code>. |
|  [on(event, nextOrObserver, error, complete)](./storage.uploadtask.md#uploadtaskon) | Listens for events on this task.<!-- -->Events have three callback functions (referred to as <code>next</code>, <code>error</code>, and <code>complete</code>).<!-- -->If only the event is passed, a function that can be used to register the callbacks is returned. Otherwise, the callbacks are passed after the event.<!-- -->Callbacks can be passed either as three separate arguments <em>or</em> as the <code>next</code>, <code>error</code>, and <code>complete</code> properties of an object. Any of the three callbacks is optional, as long as at least one is specified. In addition, when you add your callbacks, you get a function back. You can call this function to unregister the associated callbacks. |
|  [pause()](./storage.uploadtask.md#uploadtaskpause) | Pauses a currently running task. Has no effect on a paused or failed task. |
|  [resume()](./storage.uploadtask.md#uploadtaskresume) | Resumes a paused task. Has no effect on a currently running or failed task. |
|  [then(onFulfilled, onRejected)](./storage.uploadtask.md#uploadtaskthen) | This object behaves like a Promise, and resolves with its snapshot data when the upload completes. |

## UploadTask.snapshot

A snapshot of the current task state.

<b>Signature:</b>

```typescript
snapshot: UploadTaskSnapshot;
```

## UploadTask.cancel()

Cancels a running task. Has no effect on a complete or failed task.

<b>Signature:</b>

```typescript
cancel(): boolean;
```
<b>Returns:</b>

boolean

True if the cancel had an effect.

## UploadTask.catch()

Equivalent to calling `then(null, onRejected)`<!-- -->.

<b>Signature:</b>

```typescript
catch(onRejected: (error: StorageError) => unknown): Promise<unknown>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  onRejected | (error: [StorageError](./storage.storageerror.md#storageerror_class)<!-- -->) =&gt; unknown |  |

<b>Returns:</b>

Promise&lt;unknown&gt;

## UploadTask.on()

Listens for events on this task.

Events have three callback functions (referred to as `next`<!-- -->, `error`<!-- -->, and `complete`<!-- -->).

If only the event is passed, a function that can be used to register the callbacks is returned. Otherwise, the callbacks are passed after the event.

Callbacks can be passed either as three separate arguments <em>or</em> as the `next`<!-- -->, `error`<!-- -->, and `complete` properties of an object. Any of the three callbacks is optional, as long as at least one is specified. In addition, when you add your callbacks, you get a function back. You can call this function to unregister the associated callbacks.

<b>Signature:</b>

```typescript
on(event: TaskEvent, nextOrObserver?: StorageObserver<UploadTaskSnapshot> | null | ((snapshot: UploadTaskSnapshot) => unknown), error?: ((a: StorageError) => unknown) | null, complete?: Unsubscribe | null): Unsubscribe | Subscribe<UploadTaskSnapshot>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  event | [TaskEvent](./storage.md#taskevent) | The type of event to listen for. |
|  nextOrObserver | [StorageObserver](./storage.storageobserver.md#storageobserver_interface)<!-- -->&lt;[UploadTaskSnapshot](./storage.uploadtasksnapshot.md#uploadtasksnapshot_interface)<!-- -->&gt; \| null \| ((snapshot: [UploadTaskSnapshot](./storage.uploadtasksnapshot.md#uploadtasksnapshot_interface)<!-- -->) =&gt; unknown) | The <code>next</code> function, which gets called for each item in the event stream, or an observer object with some or all of these three properties (<code>next</code>, <code>error</code>, <code>complete</code>). |
|  error | ((a: [StorageError](./storage.storageerror.md#storageerror_class)<!-- -->) =&gt; unknown) \| null | A function that gets called with a <code>StorageError</code> if the event stream ends due to an error. |
|  complete | [Unsubscribe](./util.md#unsubscribe) \| null |  |

<b>Returns:</b>

[Unsubscribe](./util.md#unsubscribe) \| [Subscribe](./util.subscribe.md#subscribe_interface)<!-- -->&lt;[UploadTaskSnapshot](./storage.uploadtasksnapshot.md#uploadtasksnapshot_interface)<!-- -->&gt;

If only the event argument is passed, returns a function you can use to add callbacks (see the examples above). If more than just the event argument is passed, returns a function you can call to unregister the callbacks.

### Example 1

\*\*Pass callbacks separately or in an object.\*\*

```javascript
var next = function(snapshot) {};
var error = function(error) {};
var complete = function() {};

// The first example.
uploadTask.on(
    firebase.storage.TaskEvent.STATE_CHANGED,
    next,
    error,
    complete);

// This is equivalent to the first example.
uploadTask.on(firebase.storage.TaskEvent.STATE_CHANGED, {
  'next': next,
  'error': error,
  'complete': complete
});

// This is equivalent to the first example.
var subscribe = uploadTask.on(firebase.storage.TaskEvent.STATE_CHANGED);
subscribe(next, error, complete);

// This is equivalent to the first example.
var subscribe = uploadTask.on(firebase.storage.TaskEvent.STATE_CHANGED);
subscribe({
  'next': next,
  'error': error,
  'complete': complete
});

```

### Example 2

\*\*Any callback is optional.\*\*

```javascript
// Just listening for completion, this is legal.
uploadTask.on(
    firebase.storage.TaskEvent.STATE_CHANGED,
    null,
    null,
    function() {
      console.log('upload complete!');
    });

// Just listening for progress/state changes, this is legal.
uploadTask.on(firebase.storage.TaskEvent.STATE_CHANGED, function(snapshot) {
  var percent = snapshot.bytesTransferred / snapshot.totalBytes * 100;
  console.log(percent + "% done");
});

// This is also legal.
uploadTask.on(firebase.storage.TaskEvent.STATE_CHANGED, {
  'complete': function() {
    console.log('upload complete!');
  }
});

```

### Example 3

\*\*Use the returned function to remove callbacks.\*\*

```javascript
var unsubscribe = uploadTask.on(
    firebase.storage.TaskEvent.STATE_CHANGED,
    function(snapshot) {
      var percent = snapshot.bytesTransferred / snapshot.totalBytes * 100;
      console.log(percent + "% done");
      // Stop after receiving one update.
      unsubscribe();
    });

// This code is equivalent to the above.
var handle = uploadTask.on(firebase.storage.TaskEvent.STATE_CHANGED);
unsubscribe = handle(function(snapshot) {
  var percent = snapshot.bytesTransferred / snapshot.totalBytes * 100;
  console.log(percent + "% done");
  // Stop after receiving one update.
  unsubscribe();
});

```

## UploadTask.pause()

Pauses a currently running task. Has no effect on a paused or failed task.

<b>Signature:</b>

```typescript
pause(): boolean;
```
<b>Returns:</b>

boolean

True if the operation took effect, false if ignored.

## UploadTask.resume()

Resumes a paused task. Has no effect on a currently running or failed task.

<b>Signature:</b>

```typescript
resume(): boolean;
```
<b>Returns:</b>

boolean

True if the operation took effect, false if ignored.

## UploadTask.then()

This object behaves like a Promise, and resolves with its snapshot data when the upload completes.

<b>Signature:</b>

```typescript
then(onFulfilled?: ((snapshot: UploadTaskSnapshot) => unknown) | null, onRejected?: ((error: StorageError) => unknown) | null): Promise<unknown>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  onFulfilled | ((snapshot: [UploadTaskSnapshot](./storage.uploadtasksnapshot.md#uploadtasksnapshot_interface)<!-- -->) =&gt; unknown) \| null | The fulfillment callback. Promise chaining works as normal. |
|  onRejected | ((error: [StorageError](./storage.storageerror.md#storageerror_class)<!-- -->) =&gt; unknown) \| null | The rejection callback. |

<b>Returns:</b>

Promise&lt;unknown&gt;

