Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# UploadTaskSnapshot interface
Holds data about the current state of the upload task.

<b>Signature:</b>

```typescript
export interface UploadTaskSnapshot 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [bytesTransferred](./storage.uploadtasksnapshot.md#uploadtasksnapshotbytestransferred) | number | The number of bytes that have been successfully uploaded so far. |
|  [metadata](./storage.uploadtasksnapshot.md#uploadtasksnapshotmetadata) | [FullMetadata](./storage.fullmetadata.md#fullmetadata_interface) | Before the upload completes, contains the metadata sent to the server. After the upload completes, contains the metadata sent back from the server. |
|  [ref](./storage.uploadtasksnapshot.md#uploadtasksnapshotref) | [StorageReference](./storage.storagereference.md#storagereference_interface) | The reference that spawned this snapshot's upload task. |
|  [state](./storage.uploadtasksnapshot.md#uploadtasksnapshotstate) | [TaskState](./storage.md#taskstate) | The current state of the task. |
|  [task](./storage.uploadtasksnapshot.md#uploadtasksnapshottask) | [UploadTask](./storage.uploadtask.md#uploadtask_interface) | The task of which this is a snapshot. |
|  [totalBytes](./storage.uploadtasksnapshot.md#uploadtasksnapshottotalbytes) | number | The total number of bytes to be uploaded. |

## UploadTaskSnapshot.bytesTransferred

The number of bytes that have been successfully uploaded so far.

<b>Signature:</b>

```typescript
bytesTransferred: number;
```

## UploadTaskSnapshot.metadata

Before the upload completes, contains the metadata sent to the server. After the upload completes, contains the metadata sent back from the server.

<b>Signature:</b>

```typescript
metadata: FullMetadata;
```

## UploadTaskSnapshot.ref

The reference that spawned this snapshot's upload task.

<b>Signature:</b>

```typescript
ref: StorageReference;
```

## UploadTaskSnapshot.state

The current state of the task.

<b>Signature:</b>

```typescript
state: TaskState;
```

## UploadTaskSnapshot.task

The task of which this is a snapshot.

<b>Signature:</b>

```typescript
task: UploadTask;
```

## UploadTaskSnapshot.totalBytes

The total number of bytes to be uploaded.

<b>Signature:</b>

```typescript
totalBytes: number;
```
