/**
 * @license
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { version } from '../package.json';

export const AI_TYPE = 'AI';

export const DEFAULT_LOCATION = 'us-central1';

export const DEFAULT_DOMAIN = 'firebasevertexai.googleapis.com';

export const STAGING_URL =
  'https://staging-firebasevertexai.sandbox.googleapis.com';

export const DEFAULT_API_VERSION = 'v1beta';

export const PACKAGE_VERSION = version;

export const LANGUAGE_TAG = 'gl-js';

export const DEFAULT_FETCH_TIMEOUT_MS = 180 * 1000;

/**
 * Defines the name of the default in-cloud model to use for hybrid inference.
 */
export const DEFAULT_HYBRID_IN_CLOUD_MODEL = 'gemini-2.0-flash-lite';
